/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ws;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.jee.ws.WorkflowWebService;
import org.imixs.workflow.services.dataobjects.Entity;
import org.imixs.workflow.services.dataobjects.EntityAdapter;
import org.imixs.workflow.services.dataobjects.EntityCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@Remote(value={WorkflowWebService.class})
@WebService(name="WorkflowManagerService", targetNamespace="http://imixs.org/workflow/services", serviceName="WorkflowManagerService", portName="WorkflowManagerServicePort", wsdlLocation="ix_workflowservice.wsdl")
public class WorkflowWebServiceBean
implements WorkflowWebService {
    @EJB
    EntityService entityService;
    @EJB
    WorkflowService workflowManager;
    @Resource
    SessionContext ctx;

    @WebMethod
    public Entity getWorkItem(@WebParam(name="workitemid", mode=WebParam.Mode.IN) String uniqueid) throws Exception {
        ItemCollection ic = this.workflowManager.getWorkItem(uniqueid);
        return EntityAdapter.putItemCollection((ItemCollection)ic);
    }

    @WebMethod
    public EntityCollection getWorkList(@WebParam(name="key", mode=WebParam.Mode.IN) String name, @WebParam(name="startpos", mode=WebParam.Mode.IN) int startpos, @WebParam(name="count", mode=WebParam.Mode.IN) int count) throws Exception {
        Collection col = this.workflowManager.getWorkList(name, startpos, count);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public EntityCollection getWorkListByRef(@WebParam(name="key", mode=WebParam.Mode.IN) String aref, @WebParam(name="startpos", mode=WebParam.Mode.IN) int startpos, @WebParam(name="count", mode=WebParam.Mode.IN) int count) throws Exception {
        Collection col = this.workflowManager.getWorkListByRef(aref, startpos, count);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public EntityCollection getWorkListByCreator(@WebParam(name="key", mode=WebParam.Mode.IN) String name, @WebParam(name="startpos", mode=WebParam.Mode.IN) int startpos, @WebParam(name="count", mode=WebParam.Mode.IN) int count) throws Exception {
        Collection col = this.workflowManager.getWorkListByCreator(name, startpos, count);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public EntityCollection getWorkListByGroup(@WebParam(name="key", mode=WebParam.Mode.IN) String name, @WebParam(name="startpos", mode=WebParam.Mode.IN) int startpos, @WebParam(name="count", mode=WebParam.Mode.IN) int count) throws Exception {
        Collection col = this.workflowManager.getWorkListByGroup(name, startpos, count);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public EntityCollection getWorkListByProcessID(@WebParam(name="key", mode=WebParam.Mode.IN) int aID, @WebParam(name="startpos", mode=WebParam.Mode.IN) int startpos, @WebParam(name="count", mode=WebParam.Mode.IN) int count) throws Exception {
        Collection col = this.workflowManager.getWorkListByProcessID(aID, startpos, count);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public Entity processWorkItem(@WebParam(name="workitem", mode=WebParam.Mode.IN) Entity workitem, @WebParam(name="activityid", mode=WebParam.Mode.IN) int activityid) throws Exception {
        ItemCollection ic = EntityAdapter.getItemCollection((Entity)workitem);
        ic = this.workflowManager.processWorkItem(ic);
        return EntityAdapter.putItemCollection((ItemCollection)ic);
    }

    @WebMethod
    public void removeWorkItem(@WebParam(name="workitemid", mode=WebParam.Mode.IN) String uniqueid) throws Exception {
        ItemCollection itemCol = this.entityService.load(uniqueid);
        this.workflowManager.removeWorkItem(itemCol);
    }

    private EntityCollection buildEntityCollection(Collection<ItemCollection> col) throws Exception {
        EntityCollection wl = new EntityCollection();
        Iterator<ItemCollection> it = col.iterator();
        int max = col.size();
        int i = 0;
        Entity[] entities = new Entity[max];
        while (it.hasNext()) {
            Entity entity;
            ItemCollection icw = it.next();
            entities[i] = entity = EntityAdapter.putItemCollection((ItemCollection)icw);
            ++i;
        }
        if (max > 0) {
            wl.setEntities(entities);
        }
        return wl;
    }
}

