/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidWorkitemException;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.EntityServiceRemote;
import org.imixs.workflow.jee.jpa.CalendarItem;
import org.imixs.workflow.jee.jpa.DoubleItem;
import org.imixs.workflow.jee.jpa.Entity;
import org.imixs.workflow.jee.jpa.EntityIndex;
import org.imixs.workflow.jee.jpa.IntegerItem;
import org.imixs.workflow.jee.jpa.ReadAccessEntity;
import org.imixs.workflow.jee.jpa.TextItem;
import org.imixs.workflow.jee.jpa.WriteAccessEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@Local(value={EntityService.class})
@Remote(value={EntityServiceRemote.class})
public class EntityServiceBean
implements EntityService {
    @Resource
    SessionContext ctx;
    @Resource(name="READ_ACCESS_FIELDS")
    private String readAccessFields = "";
    @Resource(name="WRITE_ACCESS_FIELDS")
    private String writeAccessFields = "";
    @Resource(name="ACCESS_ROLES")
    private String accessRoles = "";
    @PersistenceContext(unitName="org.imixs.workflow.jee.jpa")
    private EntityManager manager;
    private Entity activeEntity;
    private EntityIndex activeEntityIndex = null;
    private Collection<EntityIndex> entityIndexCache = null;

    public String getAccessRoles() {
        return this.accessRoles;
    }

    public String getReadAccessFields() {
        return this.readAccessFields;
    }

    public String getWriteAccessFields() {
        return this.writeAccessFields;
    }

    public Collection<EntityIndex> findAllEntityIndices() {
        if (this.entityIndexCache != null) {
            return this.entityIndexCache;
        }
        Query q = this.manager.createQuery("SELECT entityindex FROM EntityIndex entityindex");
        return q.getResultList();
    }

    public Collection<ItemCollection> findAllEntities(String query, int startpos, int count) {
        Vector<ItemCollection> vectorResult = new Vector<ItemCollection>();
        try {
            List entityList;
            query = this.optimizeQuery(query);
            Query q = this.manager.createQuery(query);
            if (startpos >= 0) {
                q.setFirstResult(startpos);
            }
            if (count > 0) {
                q.setMaxResults(count);
            }
            if ((entityList = q.getResultList()) == null) {
                return vectorResult;
            }
            Iterator i$ = entityList.iterator();
            while (i$.hasNext()) {
                Entity aEntity;
                this.activeEntity = aEntity = (Entity)i$.next();
                try {
                    this.manager.refresh((Object)this.activeEntity);
                }
                catch (EntityNotFoundException ex) {
                    ex.printStackTrace();
                    return null;
                }
                vectorResult.add(this.implodeEntity());
            }
            return vectorResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return vectorResult;
        }
    }

    private String optimizeQuery(String aQuery) throws Exception {
        String nameList = "";
        StringTokenizer st = new StringTokenizer(aQuery = aQuery.trim());
        if (st.countTokens() < 5) {
            throw new Exception("Invalid query : " + aQuery);
        }
        st.nextToken();
        String sDistinct = st.nextToken();
        if (!"distinct".equals(sDistinct.toLowerCase().trim())) {
            int iDisPos = aQuery.toLowerCase().indexOf("select") + 6;
            aQuery = aQuery.substring(0, iDisPos) + " DISTINCT" + aQuery.substring(iDisPos);
        }
        if (this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return aQuery;
        }
        nameList = "'','" + this.ctx.getCallerPrincipal().getName().toString() + "'";
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS," + this.accessRoles;
        StringTokenizer roleListTokens = new StringTokenizer(roleList, ",");
        while (roleListTokens.hasMoreTokens()) {
            String testRole = roleListTokens.nextToken().trim();
            if ("".equals(testRole) || !this.ctx.isCallerInRole(testRole)) continue;
            nameList = nameList + ",'" + testRole + "'";
        }
        int iPos = 0;
        iPos = aQuery.toLowerCase().indexOf("join");
        if (iPos == -1) {
            iPos = aQuery.toLowerCase().indexOf("where");
        }
        if (iPos == -1) {
            iPos = aQuery.toLowerCase().indexOf("order by");
        }
        String firstPart = iPos == -1 ? aQuery : aQuery.substring(0, iPos - 1);
        firstPart = firstPart.trim();
        iPos = firstPart.length();
        String identifier = null;
        identifier = firstPart.substring(firstPart.lastIndexOf(32)).trim();
        if (identifier.endsWith(",")) {
            identifier = identifier.substring(0, identifier.length() - 1);
        }
        String aNewQuery = aQuery.substring(0, iPos);
        aNewQuery = aNewQuery + " JOIN " + identifier + ".readAccess access807 ";
        aQuery = (aNewQuery = aNewQuery + aQuery.substring(iPos)).trim();
        int iWherePos = aQuery.toLowerCase().indexOf("where");
        if (iWherePos > -1) {
            aQuery = aNewQuery = aQuery.substring(0, iWherePos + 5) + " (access807.value IS NULL OR access807.value IN (" + nameList + ")) AND " + aQuery.substring(iWherePos + 6);
        } else {
            int iOrderPos = aQuery.toLowerCase().indexOf("order by");
            aNewQuery = iOrderPos > -1 ? aQuery.substring(0, iOrderPos - 1) + " WHERE (access807.value IS NULL OR access807.value IN (" + nameList + ")) " + aQuery.substring(iOrderPos) : aQuery + " WHERE (access807.value IS NULL OR access807.value IN(" + nameList + ")) ";
            aQuery = aNewQuery;
        }
        return aQuery;
    }

    public ItemCollection load(String id) {
        this.activeEntity = null;
        this.activeEntity = (Entity)this.manager.find(Entity.class, (Object)id);
        if (this.activeEntity != null && this.isCallerReader()) {
            try {
                this.manager.refresh((Object)this.activeEntity);
            }
            catch (EntityNotFoundException ex) {
                ex.printStackTrace();
                return null;
            }
            return this.implodeEntity();
        }
        return null;
    }

    public void remove(ItemCollection itemcol) throws AccessDeniedException, InvalidWorkitemException {
        String sID = itemcol.getItemValueString("$uniqueid");
        this.activeEntity = (Entity)this.manager.find(Entity.class, (Object)sID);
        if (this.activeEntity != null) {
            if (!this.isCallerReader()) {
                throw new AccessDeniedException("EntityPersistanceManager: You are not allowed to perform this operation");
            }
        } else {
            throw new InvalidWorkitemException();
        }
        this.manager.remove((Object)this.activeEntity);
    }

    public void addIndex(String stitel, int ityp) throws Exception {
        stitel = stitel.toLowerCase();
        this.activeEntityIndex = (EntityIndex)this.manager.find(EntityIndex.class, (Object)stitel);
        if (this.activeEntityIndex != null) {
            return;
        }
        if (!this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            throw new AccessDeniedException("EntityPersistanceManager: You are not allowed to add index fields");
        }
        System.out.println("[EntityServiceBean] add new Index: " + stitel + ":" + ityp);
        this.activeEntityIndex = new EntityIndex(stitel, ityp);
        this.manager.persist((Object)this.activeEntityIndex);
        System.out.println("[EntityServiceBean] update IndexCache");
        Query queryIndex = this.manager.createQuery("SELECT wii FROM EntityIndex wii");
        this.entityIndexCache = queryIndex.getResultList();
        List entityList = null;
        Query q = this.manager.createQuery("SELECT wi FROM Entity wi");
        entityList = q.getResultList();
        System.out.println("[EntityServiceBean] found " + entityList.size() + " existing entities. Starting update...");
        this.updateAllEntityIndexFields(entityList, stitel);
        System.out.println("[EntityServiceBean] index update completed");
    }

    public void removeIndex(String stitel) throws Exception {
        int indexType = 0;
        stitel = stitel.toLowerCase();
        this.activeEntityIndex = (EntityIndex)this.manager.find(EntityIndex.class, (Object)stitel);
        if (this.activeEntityIndex == null) {
            return;
        }
        if (!this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            throw new AccessDeniedException("EntityPersistanceManager: You are not allowed to add index fields");
        }
        indexType = this.activeEntityIndex.typ;
        System.out.println("[EntityServiceBean] remove Index: " + stitel + ":" + indexType);
        this.manager.remove((Object)this.activeEntityIndex);
        Query queryIndex = this.manager.createQuery("SELECT wii FROM EntityIndex wii");
        this.entityIndexCache = queryIndex.getResultList();
        List entityList = null;
        String query = "SELECT wi FROM Entity wi ";
        switch (indexType) {
            case 3: {
                query = query + " JOIN wi.calendarItems AS i1 WHERE i1.itemName='" + stitel + "'";
                break;
            }
            case 2: {
                query = query + " JOIN wi.doubleItems AS i1 WHERE i1.itemName='" + stitel + "'";
                break;
            }
            case 1: {
                query = query + " JOIN wi.integerItems AS i1 WHERE i1.itemName='" + stitel + "'";
                break;
            }
            default: {
                query = query + " JOIN wi.textItems AS i1 WHERE i1.itemName='" + stitel + "'";
            }
        }
        System.out.println("[EntityServiceBean] remove Index - update query=" + query);
        Query q = this.manager.createQuery(query);
        entityList = q.getResultList();
        System.out.println("[EntityServiceBean] found " + entityList.size() + " affected entities. Starting update...");
        this.updateAllEntityIndexFields(entityList, null);
        System.out.println("[EntityServiceBean] index update completed");
    }

    public ItemCollection save(ItemCollection itemcol) throws AccessDeniedException {
        Calendar cal;
        String sID = itemcol.getItemValueString("$uniqueid");
        if (!"".equals(sID)) {
            this.activeEntity = (Entity)this.manager.find(Entity.class, (Object)sID);
            if (this.activeEntity != null) {
                try {
                    this.manager.refresh((Object)this.activeEntity);
                }
                catch (EntityNotFoundException ex) {
                    ex.printStackTrace();
                    this.activeEntity = null;
                }
            }
            if (this.activeEntity == null) {
                if (!(this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS") || this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.EDITORACCESS") || this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.AUTHORACCESS"))) {
                    throw new AccessDeniedException("EntityServiceBean: You are not allowed to perform this operation");
                }
                this.activeEntity = new Entity(sID);
                if (itemcol.hasItem("$Created")) {
                    Date datCreated = itemcol.getItemValueDate("$Created");
                    cal = Calendar.getInstance();
                    cal.setTime(datCreated);
                    this.activeEntity.setCreated(cal);
                }
                this.manager.persist((Object)this.activeEntity);
            } else if (!this.isCallerAuthor() || !this.isCallerReader()) {
                throw new AccessDeniedException("EntityServiceBean: You are not allowed to perform this operation");
            }
        } else {
            if (!(this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS") || this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.EDITORACCESS") || this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.AUTHORACCESS"))) {
                throw new AccessDeniedException("EntityServiceBean: You are not allowed to perform this operation");
            }
            this.activeEntity = new Entity();
            this.manager.persist((Object)this.activeEntity);
        }
        itemcol.removeItem("$isauthor");
        this.activeEntity.getData().setItemCollection(itemcol);
        String aType = itemcol.getItemValueString("type");
        if ("".equals(aType)) {
            aType = "Entity";
        }
        this.activeEntity.setType(aType);
        cal = Calendar.getInstance();
        try {
            this.activeEntity.getData().getItemCollection().replaceItemValue("$uniqueid", (Object)this.activeEntity.getId());
            this.activeEntity.getData().getItemCollection().replaceItemValue("$modified", (Object)cal.getTime());
            this.activeEntity.getData().getItemCollection().replaceItemValue("$created", (Object)this.activeEntity.getCreated().getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.explodeEntity();
        this.updateReadAccessList();
        this.updateWriteAccessList();
        this.activeEntity = (Entity)this.manager.merge((Object)this.activeEntity);
        return this.implodeEntity();
    }

    private void updateReadAccessList() {
        List colAccessEntities = this.activeEntity.getReadAccess();
        this.activeEntity.setReadAccess(null);
        for (ReadAccessEntity aItem : colAccessEntities) {
            this.manager.remove((Object)aItem);
        }
        Vector<String> vAccessFieldList = new Vector<String>();
        vAccessFieldList.add("$readAccess");
        if (this.readAccessFields != null && !"".equals(this.readAccessFields)) {
            String[] stringArrayList;
            for (String aentry : stringArrayList = this.readAccessFields.split(",")) {
                vAccessFieldList.add(aentry);
            }
        }
        ItemCollection itemCol = this.activeEntity.getData().getItemCollection();
        Vector<String> vValueList = new Vector<String>();
        for (String aentry : vAccessFieldList) {
            Vector vEntryList = itemCol.getItemValue(aentry);
            for (String aEntry : vEntryList) {
                if (aEntry == null || "".equals(aEntry)) continue;
                vValueList.add(aEntry);
            }
        }
        if (vValueList.size() == 0) {
            vValueList.add("");
        }
        Iterator iter = vValueList.iterator();
        while (iter.hasNext()) {
            this.addReadAccessEntity(this.activeEntity.getReadAccess(), new ReadAccessEntity(iter.next().toString()));
        }
    }

    private void updateWriteAccessList() {
        List colAccessEntities = this.activeEntity.getWriteAccess();
        this.activeEntity.setWriteAccess(null);
        for (WriteAccessEntity aItem : colAccessEntities) {
            this.manager.remove((Object)aItem);
        }
        Vector<String> vAccessFieldList = new Vector<String>();
        vAccessFieldList.add("$writeAccess");
        if (this.writeAccessFields != null && !"".equals(this.writeAccessFields)) {
            String[] stringArrayList;
            for (String aentry : stringArrayList = this.writeAccessFields.split(",")) {
                vAccessFieldList.add(aentry);
            }
        }
        ItemCollection itemCol = this.activeEntity.getData().getItemCollection();
        Vector<String> vValueList = new Vector<String>();
        for (String aentry : vAccessFieldList) {
            Vector vEntryList = itemCol.getItemValue(aentry);
            for (String aEntry : vEntryList) {
                if (aEntry == null || "".equals(aEntry)) continue;
                vValueList.add(aEntry);
            }
        }
        if (vValueList.size() == 0) {
            vValueList.add("");
        }
        Iterator iter = vValueList.iterator();
        while (iter.hasNext()) {
            this.addWriteAccessEntity(this.activeEntity.getWriteAccess(), new WriteAccessEntity(iter.next().toString()));
        }
    }

    private void explodeEntity() {
        this.removeIndexProperties();
        this.entityIndexCache = this.findAllEntityIndices();
        for (EntityIndex this.activeEntityIndex : this.entityIndexCache) {
            String name = this.activeEntityIndex.name;
            int typ = this.activeEntityIndex.typ;
            this.explodeItem(name, typ);
        }
    }

    private void removeIndexProperties() {
        List colText = this.activeEntity.getTextItems();
        for (TextItem aItem : colText) {
            this.manager.remove((Object)aItem);
        }
        this.activeEntity.getTextItems().clear();
        this.activeEntity.setTextItems(null);
        List colInteger = this.activeEntity.getIntegerItems();
        for (IntegerItem aItem : colInteger) {
            this.manager.remove((Object)aItem);
        }
        this.activeEntity.getIntegerItems().clear();
        this.activeEntity.setIntegerItems(null);
        List colDouble = this.activeEntity.getDoubleItems();
        for (DoubleItem aItem : colDouble) {
            this.manager.remove((Object)aItem);
        }
        this.activeEntity.getDoubleItems().clear();
        this.activeEntity.setDoubleItems(null);
        List colCalendar = this.activeEntity.getCalendarItems();
        for (CalendarItem aItem : colCalendar) {
            this.manager.remove((Object)aItem);
        }
        this.activeEntity.getCalendarItems().clear();
        this.activeEntity.setCalendarItems(null);
    }

    private void explodeItem(String name, int typ) {
        name = name.toLowerCase();
        Vector vValue = this.activeEntity.getData().getItemCollection().getItemValue(name);
        for (int i = 0; i < vValue.size(); ++i) {
            try {
                Object o = vValue.elementAt(i);
                if (typ == 0) {
                    this.addTextItem(this.activeEntity.getTextItems(), new TextItem(name, o.toString()));
                }
                if (typ == 1) {
                    this.addIntegerItem(this.activeEntity.getIntegerItems(), new IntegerItem(name, (Integer)o));
                }
                if (typ == 2) {
                    this.addDoubleItem(this.activeEntity.getDoubleItems(), new DoubleItem(name, (Double)o));
                }
                if (typ != 3) continue;
                if (o instanceof Date) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)o);
                    o = cal;
                }
                this.addCalendarItem(this.activeEntity.getCalendarItems(), new CalendarItem(name, (Calendar)o));
                continue;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        this.activeEntity.getData().getItemCollection().removeItem(name);
    }

    private ItemCollection implodeEntity() {
        ItemCollection detachedItemCollection = new ItemCollection();
        try {
            detachedItemCollection.replaceItemValue("$isauthor", (Object)this.isCallerAuthor());
        }
        catch (Exception e1) {
            // empty catch block
        }
        List textitems = this.activeEntity.getTextItems();
        for (TextItem ti : textitems) {
            try {
                Vector vValue = detachedItemCollection.getItemValue(ti.itemName);
                vValue.addElement(ti.itemValue);
                detachedItemCollection.replaceItemValue(ti.itemName, (Object)vValue);
            }
            catch (Exception e) {}
        }
        List integeritems = this.activeEntity.getIntegerItems();
        for (IntegerItem ii : integeritems) {
            try {
                Vector vValue = detachedItemCollection.getItemValue(ii.itemName);
                vValue.addElement(ii.itemValue);
                detachedItemCollection.replaceItemValue(ii.itemName, (Object)vValue);
            }
            catch (Exception e) {}
        }
        List doubleitems = this.activeEntity.getDoubleItems();
        for (DoubleItem di : doubleitems) {
            try {
                Vector vValue = detachedItemCollection.getItemValue(di.itemName);
                vValue.addElement(di.itemValue);
                detachedItemCollection.replaceItemValue(di.itemName, (Object)vValue);
            }
            catch (Exception e) {}
        }
        List calendaritems = this.activeEntity.getCalendarItems();
        for (CalendarItem ci : calendaritems) {
            try {
                Vector vValue = detachedItemCollection.getItemValue(ci.itemName);
                vValue.addElement(ci.itemValue.getTime());
                detachedItemCollection.replaceItemValue(ci.itemName, (Object)vValue);
            }
            catch (Exception e) {}
        }
        Map activeMap = this.activeEntity.getData().getItemCollection().getAllItems();
        if (activeMap != null) {
            for (Map.Entry mapEntry : activeMap.entrySet()) {
                String activePropertyName = mapEntry.getKey().toString();
                if (detachedItemCollection.hasItem(activePropertyName)) continue;
                Vector activePropertyValue = (Vector)mapEntry.getValue();
                Vector detachePropertyValue = new Vector();
                detachePropertyValue.addAll(activePropertyValue);
                try {
                    detachedItemCollection.replaceItemValue(activePropertyName, detachePropertyValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return detachedItemCollection;
    }

    @Deprecated
    private ItemCollection oldimplodeEntity() {
        ItemCollection detachedItemCollection = new ItemCollection();
        try {
            detachedItemCollection.replaceItemValue("$isauthor", (Object)this.isCallerAuthor());
        }
        catch (Exception e1) {
            // empty catch block
        }
        detachedItemCollection.getAllItems().putAll(this.activeEntity.getData().getItemCollection().getAllItems());
        List textitems = this.activeEntity.getTextItems();
        for (TextItem ti : textitems) {
            try {
                Vector vValue = detachedItemCollection.getItemValue(ti.itemName);
                vValue.addElement(ti.itemValue);
                detachedItemCollection.replaceItemValue(ti.itemName, (Object)vValue);
            }
            catch (Exception e) {}
        }
        List integeritems = this.activeEntity.getIntegerItems();
        for (IntegerItem ii : integeritems) {
            try {
                Vector vValue = detachedItemCollection.getItemValue(ii.itemName);
                vValue.addElement(ii.itemValue);
                detachedItemCollection.replaceItemValue(ii.itemName, (Object)vValue);
            }
            catch (Exception e) {}
        }
        List doubleitems = this.activeEntity.getDoubleItems();
        for (DoubleItem di : doubleitems) {
            try {
                Vector vValue = detachedItemCollection.getItemValue(di.itemName);
                vValue.addElement(di.itemValue);
                detachedItemCollection.replaceItemValue(di.itemName, (Object)vValue);
            }
            catch (Exception e) {}
        }
        List calendaritems = this.activeEntity.getCalendarItems();
        for (CalendarItem ci : calendaritems) {
            try {
                Vector vValue = detachedItemCollection.getItemValue(ci.itemName);
                vValue.addElement(ci.itemValue.getTime());
                detachedItemCollection.replaceItemValue(ci.itemName, (Object)vValue);
            }
            catch (Exception e) {}
        }
        return detachedItemCollection;
    }

    private boolean isCallerReader() {
        List readAccessList = this.activeEntity.getReadAccess();
        if (this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.NOACCESS")) {
            return false;
        }
        if (this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return true;
        }
        if (readAccessList == null || readAccessList.size() == 0) {
            return true;
        }
        boolean notemptyfield = false;
        for (ReadAccessEntity readAccessEntry : readAccessList) {
            String sAccessName = readAccessEntry.getValue();
            if (sAccessName == null || "".equals(sAccessName)) continue;
            notemptyfield = true;
            try {
                if (!this.ctx.getCallerPrincipal().getName().equals(sAccessName) && !this.ctx.isCallerInRole(sAccessName)) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return !notemptyfield;
    }

    private boolean isCallerAuthor() {
        List writeAccessList = this.activeEntity.getWriteAccess();
        if (this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.NOACCESS")) {
            return false;
        }
        if (this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS") || this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.EDITORACCESS")) {
            return true;
        }
        if (this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.AUTHORACCESS")) {
            if (writeAccessList == null || writeAccessList.size() == 0) {
                return false;
            }
            for (WriteAccessEntity writeAccessEntry : writeAccessList) {
                String sAccessName = writeAccessEntry.getValue();
                if (sAccessName == null || "".equals(sAccessName)) continue;
                try {
                    if (!this.ctx.getCallerPrincipal().getName().equals(sAccessName) && !this.ctx.isCallerInRole(sAccessName)) continue;
                    return true;
                }
                catch (Exception e) {
                }
            }
        }
        return false;
    }

    private void updateAllEntityIndexFields(Collection<Entity> entityList, String newIndexField) throws Exception {
        long count = 0L;
        for (Entity this.activeEntity : entityList) {
            if (newIndexField != null && !this.activeEntity.getData().getItemCollection().hasItem(newIndexField)) continue;
            try {
                this.manager.refresh((Object)this.activeEntity);
            }
            catch (EntityNotFoundException ex) {
                ex.printStackTrace();
                throw ex;
            }
            ItemCollection itemCol = this.implodeEntity();
            this.activeEntity.getData().setItemCollection(itemCol);
            this.explodeEntity();
            this.manager.merge((Object)this.activeEntity);
            ++count;
        }
        System.out.println("[EntityServiceBean] " + count + " effective updates");
    }

    private void addTextItem(Collection<TextItem> col, TextItem newItem) {
        for (TextItem aItem : col) {
            if (!aItem.itemName.equals(newItem.itemName) || !aItem.itemValue.equals(newItem.itemValue)) continue;
            return;
        }
        col.add(newItem);
    }

    private void addReadAccessEntity(Collection<ReadAccessEntity> col, ReadAccessEntity newItem) {
        for (ReadAccessEntity aItem : col) {
            if (!aItem.getValue().equals(newItem.getValue())) continue;
            return;
        }
        col.add(newItem);
    }

    private void addWriteAccessEntity(Collection<WriteAccessEntity> col, WriteAccessEntity newItem) {
        for (WriteAccessEntity aItem : col) {
            if (!aItem.getValue().equals(newItem.getValue())) continue;
            return;
        }
        col.add(newItem);
    }

    private void addCalendarItem(Collection<CalendarItem> col, CalendarItem newItem) {
        for (CalendarItem aItem : col) {
            if (!aItem.itemName.equals(newItem.itemName) || !aItem.itemValue.equals(newItem.itemValue)) continue;
            return;
        }
        col.add(newItem);
    }

    private void addDoubleItem(Collection<DoubleItem> col, DoubleItem newItem) {
        for (DoubleItem aItem : col) {
            if (!aItem.itemName.equals(newItem.itemName) || !aItem.itemValue.equals(newItem.itemValue)) continue;
            return;
        }
        col.add(newItem);
    }

    private void addIntegerItem(Collection<IntegerItem> col, IntegerItem newItem) {
        for (IntegerItem aItem : col) {
            if (!aItem.itemName.equals(newItem.itemName) || !aItem.itemValue.equals(newItem.itemValue)) continue;
            return;
        }
        col.add(newItem);
    }
}

