/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ejb.WorkflowScheduler;
import org.imixs.workflow.jee.ejb.WorkflowSchedulerRemote;
import org.imixs.workflow.jee.ejb.WorkflowService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Local(value={WorkflowScheduler.class})
@Remote(value={WorkflowSchedulerRemote.class})
public class WorkflowSchedulerBean
implements WorkflowScheduler {
    private Date startDate;
    private Date endDate;
    private int interval;
    private String id;
    private int iProcessWorkItems = 0;
    private int iScheduledWorkItems = 0;
    private Collection<ItemCollection> colScheduledActivities = null;
    @Resource
    SessionContext ctx;
    @EJB
    WorkflowService workflowService;
    @EJB
    EntityService entityService;
    @EJB
    ModelService modelService;
    @Resource
    TimerService timerService;

    public void scheduleWorkflow(ItemCollection timerdescription) throws Exception {
        this.validateTimerDescription(timerdescription);
        this.cancelScheduleWorkflow(timerdescription.getItemValueString("id"));
        Calendar calNow = Calendar.getInstance();
        String msg = "Started: " + calNow.getTime() + " by " + this.ctx.getCallerPrincipal().getName();
        timerdescription.replaceItemValue("statusmessage", (Object)msg);
        timerdescription.replaceItemValue("$created", (Object)calNow.getTime());
        this.timerService.createTimer(this.startDate, (long)this.interval, (Serializable)timerdescription);
    }

    public ItemCollection findTimerDescription(String id) throws Exception {
        Timer timer = this.getTimer(id);
        if (timer != null) {
            ItemCollection adescription = (ItemCollection)timer.getInfo();
            adescription.replaceItemValue("nextTimeout", (Object)timer.getNextTimeout());
            adescription.replaceItemValue("timeRemaining", (Object)timer.getTimeRemaining());
            return adescription;
        }
        ItemCollection adescription = new ItemCollection();
        adescription.replaceItemValue("id", (Object)id);
        return adescription;
    }

    public Collection<ItemCollection> findAllTimerDescriptions() throws Exception {
        Vector<ItemCollection> v = new Vector<ItemCollection>();
        Iterator i$ = this.timerService.getTimers().iterator();
        while (i$.hasNext()) {
            Timer obj;
            Timer timer = obj = (Timer)i$.next();
            ItemCollection adescription = null;
            if (!(timer.getInfo() instanceof ItemCollection)) continue;
            adescription = (ItemCollection)timer.getInfo();
            adescription.replaceItemValue("nextTimeout", (Object)timer.getNextTimeout());
            adescription.replaceItemValue("timeRemaining", (Object)timer.getTimeRemaining());
            v.add(adescription);
        }
        return v;
    }

    public void cancelScheduleWorkflow(String id) throws Exception {
        Timer timer = this.getTimer(id);
        if (timer != null) {
            timer.cancel();
            System.out.println("[WorkflowScheduler] cancelScheduleWorkflow: " + id);
        }
    }

    private Timer getTimer(String id) throws Exception {
        for (Timer obj : this.timerService.getTimers()) {
            ItemCollection adescription;
            Timer timer = obj;
            if (!(timer.getInfo() instanceof ItemCollection) || !id.equals((adescription = (ItemCollection)timer.getInfo()).getItemValueString("id"))) continue;
            return timer;
        }
        return null;
    }

    private void validateTimerDescription(ItemCollection atimerDesc) throws Exception {
        boolean valid = true;
        try {
            this.startDate = (Date)atimerDesc.getItemValue("datstart").firstElement();
            this.endDate = (Date)atimerDesc.getItemValue("datstop").firstElement();
            this.interval = atimerDesc.getItemValueInteger("numinterval");
            this.id = atimerDesc.getItemValueString("id");
            if ("".equals(this.id)) {
                valid = false;
            }
        }
        catch (Exception e) {
            valid = false;
        }
        if (!valid) {
            throw new Exception("TimerDescirption is not valid! datstart(Date), datstop(Date), numinterval(Integer), id(String) need to be sported!");
        }
    }

    @Timeout
    public void processWorkItems(Timer timer) {
        Calendar calNow;
        String sModelVersion = null;
        String sTimerID = null;
        try {
            ItemCollection adescription = (ItemCollection)timer.getInfo();
            sTimerID = adescription.getItemValueString("id");
            System.out.println("[WorkflowScheduler]  Processing : " + sTimerID);
            sModelVersion = adescription.getItemValueString("$modelversion");
            if ("".equals(sModelVersion)) {
                sModelVersion = this.modelService.getLatestVersion();
            }
            System.out.println("[WorkflowScheduler] ModelVersion=" + sModelVersion);
            System.out.println("[WorkflowScheduler] start process Workitems...");
            this.iProcessWorkItems = 0;
            this.iScheduledWorkItems = 0;
            this.colScheduledActivities = this.findScheduledActivities(sModelVersion);
            System.out.println("[WorkflowScheduler]  " + this.colScheduledActivities.size() + " scheduled activityEntities found");
            for (ItemCollection aactivityEntity : this.colScheduledActivities) {
                this.processWorkList(aactivityEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("[WorkflowScheduler]  finished successfull");
        System.out.println("[WorkflowScheduler] " + this.iProcessWorkItems + " workitems checked");
        System.out.println("[WorkflowScheduler] " + this.iScheduledWorkItems + " workitems processed");
        if (this.endDate != null && (calNow = Calendar.getInstance()).getTime().after(this.endDate)) {
            timer.cancel();
            System.out.println("[WorkflowScheduler] cancelScheduleWorkflow: " + sTimerID);
        }
    }

    private Collection<ItemCollection> findScheduledActivities(String aModelVersion) throws Exception {
        Vector<ItemCollection> vectorActivities = new Vector<ItemCollection>();
        Collection colProcessList = null;
        colProcessList = aModelVersion != null ? this.modelService.getProcessEntityListByVersion(aModelVersion) : this.modelService.getProcessEntityList();
        for (ItemCollection aprocessentity : colProcessList) {
            int processid = aprocessentity.getItemValueInteger("numprocessid");
            Collection aActivityList = this.modelService.getActivityEntityListByVersion(processid, aModelVersion);
            for (ItemCollection aactivityEntity : aActivityList) {
                if (!"1".equals(aactivityEntity.getItemValueString("keyScheduledActivity"))) continue;
                vectorActivities.add(aactivityEntity);
            }
        }
        return vectorActivities;
    }

    private void processWorkList(ItemCollection activityEntity) throws Exception {
        int iProcessID = activityEntity.getItemValueInteger("numprocessid");
        String sModelVersion = activityEntity.getItemValueString("$modelversion");
        String sQuery = activityEntity.getItemValueString("txtscheduledview");
        Collection worklist = null;
        worklist = sQuery != null && !"".equals(sQuery) ? this.entityService.findAllEntities(sQuery, 0, -1) : this.workflowService.getWorkListByProcessID(iProcessID, 0, -1, null, 0);
        this.iProcessWorkItems += worklist.size();
        for (ItemCollection workitem : worklist) {
            if (iProcessID != workitem.getItemValueInteger("$processid") || !sModelVersion.equals(workitem.getItemValueString("$modelversion")) || !this.workItemInDue(workitem, activityEntity)) continue;
            int iActivityID = activityEntity.getItemValueInteger("numActivityID");
            workitem.replaceItemValue("$activityid", (Object)iActivityID);
            this.processWorkitem(workitem);
            ++this.iScheduledWorkItems;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void processWorkitem(ItemCollection aWorkitem) {
        try {
            this.workflowService.processWorkItem(aWorkitem);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean workItemInDue(ItemCollection doc, ItemCollection docActivity) {
        try {
            int iCompareType = -1;
            int iDelayUnit = -1;
            Date dateTimeCompare = null;
            int iActivityDelay = 0;
            String suniqueid = doc.getItemValueString("$uniqueid");
            String sDelayUnit = docActivity.getItemValueString("keyActivityDelayUnit");
            iDelayUnit = Integer.parseInt(sDelayUnit);
            iActivityDelay = docActivity.getItemValueInteger("numActivityDelay");
            if ("1".equals(sDelayUnit)) {
                sDelayUnit = "minutes";
            }
            if ("2".equals(sDelayUnit)) {
                sDelayUnit = "hours";
            }
            if ("3".equals(sDelayUnit)) {
                sDelayUnit = "days";
            }
            if (iDelayUnit == 1) {
                iActivityDelay *= 60;
            } else if (iDelayUnit == 2) {
                iActivityDelay *= 3600;
            } else if (iDelayUnit == 3) {
                iActivityDelay *= 86400;
            }
            iCompareType = Integer.parseInt(docActivity.getItemValueString("keyScheduledBaseObject"));
            Date dateTimeNow = Calendar.getInstance().getTime();
            switch (iCompareType) {
                case 1: {
                    if (!doc.hasItem("timWorkflowLastAccess")) {
                        return false;
                    }
                    dateTimeCompare = (Date)doc.getItemValue("timWorkflowLastAccess").firstElement();
                    System.out.println("[WorkflowScheduler] " + suniqueid + ": timWorkflowLastAccess=" + dateTimeCompare);
                    dateTimeCompare = this.adjustSecond(dateTimeCompare, iActivityDelay);
                    return dateTimeCompare.before(dateTimeNow);
                }
                case 2: {
                    dateTimeCompare = (Date)doc.getItemValue("$modified").firstElement();
                    System.out.println("[WorkflowScheduler] " + suniqueid + ": modified=" + dateTimeCompare);
                    dateTimeCompare = this.adjustSecond(dateTimeCompare, iActivityDelay);
                    return dateTimeCompare.before(dateTimeNow);
                }
                case 3: {
                    dateTimeCompare = (Date)doc.getItemValue("$created").firstElement();
                    System.out.println("[WorkflowScheduler] " + suniqueid + ": doc.getCreated() =" + dateTimeCompare);
                    dateTimeCompare = this.adjustSecond(dateTimeCompare, iActivityDelay);
                    return dateTimeCompare.before(dateTimeNow);
                }
                case 4: {
                    String sNameOfField = docActivity.getItemValueString("keyTimeCompareField");
                    if (!doc.hasItem(sNameOfField)) {
                        System.out.println("[WorkflowScheduler] " + suniqueid + ": CompareType =" + sNameOfField + " no value found!");
                        return false;
                    }
                    dateTimeCompare = (Date)doc.getItemValue(sNameOfField).firstElement();
                    System.out.println("[WorkflowScheduler] " + suniqueid + ": " + sNameOfField + "=" + dateTimeCompare);
                    dateTimeCompare = this.adjustSecond(dateTimeCompare, iActivityDelay);
                    System.out.println("[WorkflowScheduler] " + suniqueid + ": Compare " + dateTimeCompare + " <-> " + dateTimeNow);
                    return dateTimeCompare.before(dateTimeNow);
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Date adjustSecond(Date adate, int seconds) {
        Calendar calTimeCompare = Calendar.getInstance();
        calTimeCompare.setTime(adate);
        calTimeCompare.add(13, seconds);
        return calTimeCompare.getTime();
    }
}

