/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.plugins.extended;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.imixs.workflow.jee.plugins.MailPlugin;

public class OpenLDAPMailPlugin
extends MailPlugin {
    public final String LDAP_JNDI_NAME = "org.imixs.mail.directory";

    public InternetAddress getInternetAddress(String aAddr) throws AddressException {
        if (aAddr.indexOf(64) > -1) {
            return super.getInternetAddress(aAddr);
        }
        try {
            aAddr = this.fetchEmail(aAddr);
        }
        catch (NamingException e) {
            System.out.println("OpenLDAPMailPlugin: mail for '" + aAddr + "' not found");
        }
        return new InternetAddress(aAddr);
    }

    private String fetchEmail(String aUsername) throws NamingException {
        SearchResult entry;
        Attributes attrs;
        Attribute attr;
        InitialContext initCtx = new InitialContext();
        DirContext ldapCtx = (DirContext)initCtx.lookup("org.imixs.mail.directory");
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        String searchfilter = "";
        searchfilter = "(uid=" + aUsername + ")";
        NamingEnumeration<SearchResult> answer = ldapCtx.search("", searchfilter, ctls);
        if (answer.hasMore() && (attr = (attrs = (entry = answer.next()).getAttributes()).get("mail")) != null) {
            return (String)attr.get(0);
        }
        return aUsername;
    }
}

