package org.imixs.workflow.jee.plugins;

import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;

/**
 * This abstract class implements a basic set of functions for implementing
 * plugins with Interfaces to JEE API
 * 
 * @author Ralph Soika
 * 
 */
public abstract class AbstractPlugin extends org.imixs.workflow.plugins.AbstractPlugin {
	javax.ejb.SessionContext jeeSessionContext;

	/**
	 * Initialize Plugin and get an instance of the EJB Session Context
	 */
	public void init(WorkflowContext actx) throws Exception {
		super.init(actx);
		// cast Workflow Session Context to EJB Session Context
		jeeSessionContext = (javax.ejb.SessionContext) ctx.getSessionContext();
	}

	
	public abstract int run(ItemCollection documentContext,
			ItemCollection documentActivity) throws Exception;

	
	public abstract void close(int status) throws Exception;

	
	
	/**
	 * determines the current username (callerPrincipal)
	 * @return
	 */
	public String getUserName() {
		return jeeSessionContext.getCallerPrincipal().getName();
	}
	
	
}
