package org.imixs.workflow.jee.plugins;

import java.util.*;

import javax.annotation.Resource;
import javax.mail.*;
import javax.mail.internet.*;
import javax.naming.*;

import org.imixs.workflow.*;

/**
 * This plugin supports a Mail interface to send mail like defined in the model
 * using the Mail tab in an activity Entity. This plugin uses the JEE Mail
 * Interface Currentyl no HTML Mail is supported
 * 
 * @author Ralph Soika
 * 
 */
public class MailPlugin extends AbstractPlugin {

	int idebugmode;
	public ItemCollection adocumentContext;
	//Vector vectorHistory = new Vector();

	// Mail objects
	Session mailSession;
	MimeMessage mailMessage = null;
	Multipart mimeMultipart=null;

	@Resource(name = "IX_MAIL_SESSION")
	private String sIXMailSession = "org.imixs.workflow.jee.mailsession";

	private boolean debugMode() throws Exception {
		return (idebugmode > 0);
	}

	/**
	 * the init method is responsible for initializing the mail session object
	 * receifed from the jndi context
	 * 
	 * The Default name of the Mail Session is
	 * 'org.imixs.workflow.jee.mailsession' The name can be overwritten by the
	 * EJB Properties of the workflowmanager
	 */
	public void init(WorkflowContext actx) throws Exception {
		super.init(actx);
		idebugmode = actx.getDebugLevel();
		// Initialize mail session
		InitialContext ic = new InitialContext();
		String snName = "";
		snName = "java:comp/env/mail/" + sIXMailSession;
		mailSession = (Session) ic.lookup(snName);
	}

	public int run(ItemCollection documentContext,
			ItemCollection documentActivity) throws Exception {

	
		String sFrom;
		String sReplyTo = "";
		adocumentContext = documentContext;
		
		InternetAddress[] recipientsTo,recipientsCC;

		try {
			if (debugMode())
				System.out.println("[MailPlugin] JEE V08.0714 ...");

			// reset mailMessage object
			mailMessage = null;

			// check if mail is active?
			if ("1".equals(documentActivity
					.getItemValueString("keyMailInactive")))
				return Plugin.PLUGIN_OK;

			// check if recipients are defined
			String snamMailReceifer = documentActivity
					.getItemValueString("namMailReceiver");
			String skeyMailReceiverFields = documentActivity
					.getItemValueString("keyMailReceiverFields");

			InternetAddress inetAddr = null;
			if (((snamMailReceifer != null) && (!"".equals(documentActivity
					.getItemValueString("namMailReceiver"))))
					|| ((skeyMailReceiverFields != null) && (!""
							.equals(documentActivity
									.getItemValueString("keyMailReceiverFields"))))) {

				sFrom = getUserName();

				// check if sender is defined....
				if ((sFrom == null) || ("".equals(sFrom)))
					return Plugin.PLUGIN_OK;

				// first initialize mail message object
				initializeMailMessage();

				// check for ReplyTo...
				if ("1".equals(documentActivity
						.getItemValueString("keyMailReplyToCurrentUser")))
					sReplyTo = getUserName();
				else
					sReplyTo = documentActivity
							.getItemValueString("namMailReplyToUser");

				// sender = CurrentUser?
				mailMessage.setFrom(getInternetAddress(sFrom));

				// replay to?
				if ((sReplyTo != null) && (!"".equals(sReplyTo))) {
					InternetAddress[] resplysAdrs = new InternetAddress[1];
					resplysAdrs[0] = getInternetAddress(sReplyTo);
					mailMessage.setReplyTo(resplysAdrs);
				}

				// build Recipient from Vector namMailReceiver
				Vector vectorRecipients = documentActivity
						.getItemValue("namMailReceiver");
				if (vectorRecipients == null)
					vectorRecipients = new Vector();

				// read keyMailReceiverFields (mulit value)
				// here are the field names defined
				mergeMappedFieldValues(documentContext, vectorRecipients,
						documentActivity.getItemValue("keyMailReceiverFields"));

				// cancel send mail if no receipiens defined
				if (vectorRecipients.size() == 0) {
					mailMessage = null;
					return Plugin.PLUGIN_OK;
				}

				/*
				 * In the following code the vector with email addresses will be
				 * transformed into a InternetAddress array. Therefore the
				 * helper getInternetAddress() method will be called which can
				 * be over written by a subclass. The Method call
				 * getInternetAddressArray ensures additional that no 'null'
				 * values will be stored into the array as this would throw a
				 * exception into the setReceipients call of the mailMessage
				 * object
				 */

				// set TO Recipient
				recipientsTo = getInternetAddressArray(vectorRecipients);
				mailMessage
						.setRecipients(Message.RecipientType.TO, recipientsTo);

				// build Recipient Vector from namMailReceiver
				vectorRecipients = documentActivity
						.getItemValue("namMailReceiverCC");
				if (vectorRecipients == null)
					vectorRecipients = new Vector();

				// now read keyMailReceiverFieldsCC (multi value)
				mergeMappedFieldValues(documentContext, vectorRecipients,
						documentActivity
								.getItemValue("keyMailReceiverFieldsCC"));

				// set CC Recipients
				// build array...
				recipientsCC = getInternetAddressArray(vectorRecipients);
				mailMessage
						.setRecipients(Message.RecipientType.CC, recipientsCC);

				// set Subject
				mailMessage
						.setSubject(replaceDynamicValues(documentActivity
								.getItemValueString("txtMailSubject"),
								documentContext));

				// build mail body...
				String aBodyText = documentActivity
						.getItemValueString("rtfMailBody");
				if (aBodyText != null) {
					aBodyText = replaceDynamicValues(aBodyText, documentContext);
					// set mailbody
					MimeBodyPart messagePart = new MimeBodyPart();
					messagePart.setText(aBodyText);
					mimeMultipart.addBodyPart(messagePart);
					// mimeMulitPart object can be extended from subclases
				}

				// write debug Log
				if ((recipientsTo.length > 0) && debugMode()) {
					System.out.println("[MailPlugin] New Mail prepered for sending...");
					System.out.println("[MailPlugin] Type: PlainText");
					System.out.println("[MailPlugin] From: " + sFrom);
					System.out.println("[MailPlugin] SendTo ("
							+ recipientsTo.length + " Receipients):");

					for (int j = 0; j < recipientsTo.length; j++)
						System.out.println("[MailPlugin]     "
								+  recipientsTo[j].getAddress());

					System.out.println("[MailPlugin] CopyTo ("
							+ recipientsCC.length + " Receipients):");
					for (int j = 0; j < recipientsCC.length; j++)
						System.out.println("[MailPlugin]     "
								+  recipientsCC[j].getAddress());
				}

				

			} else {
				if (debugMode())
					System.out
							.println("[MailPlugin] No Receipients defined for this Activity...");

			}

		} catch (Exception e) {
			System.out.println("[MailPlugin] Warning run():" + e.toString());
			e.printStackTrace();
			return Plugin.PLUGIN_WARNING;
		}

		return Plugin.PLUGIN_OK;
	}

	public void close(int status) throws Exception {
		if (status == Plugin.PLUGIN_OK && mailSession != null
				&& mailMessage != null) {
			// Send the message
			try {
				if (debugMode()) 
					System.out.println("[MailPlugin] SendMessage now...");

				// if send message fails (e.g. for policy reasons) the process
				// will
				// continue. only a exception is thrown

				// Transport.send(mailMessage);

				// A simple transport.send command did not work if mail host
				// needs
				// a authentification. Therefor we use a manual smtp connection

				Transport trans = mailSession.getTransport("smtp");
				trans.connect(mailSession.getProperty("mail.smtp.user"),
						mailSession.getProperty("mail.smtp.password"));

				mailMessage.setContent(mimeMultipart);
				
				
				mailMessage.saveChanges();
				trans.sendMessage(mailMessage, mailMessage.getAllRecipients());
				trans.close();
				

			} catch (Exception esend) {
				esend.printStackTrace();
			}
		}
	}

	/**
	 * initializes a new mail Message object
	 * 
	 * @throws AddressException
	 * @throws MessagingException
	 */
	public void initializeMailMessage() throws AddressException,
			MessagingException {

		// Alle Properties ausgeben....
		/*
		 * Properties props = mailSession.getProperties(); Enumeration
		 * enumer=props.keys(); while (enumer.hasMoreElements()) { String
		 * aKey=enumer.nextElement().toString(); System.out
		 * .println("[MailPlugin]  ProperyName= "+aKey); System.out
		 * .println("[MailPlugin]  PropertyValue= "
		 * +props.getProperty(aKey).toString()); }
		 */
		mailMessage = new MimeMessage(mailSession);
		mailMessage.setSentDate(new Date());
		mailMessage.setFrom();
		mimeMultipart = new MimeMultipart();
	}

	/**
	 * this method merges the field values form a workitem into a existing
	 * vector. The fields are defined in the vector p_VectorFieldList
	 * 
	 */
	private void mergeMappedFieldValues(ItemCollection documentContext,
			Vector p_VectorDestination, Vector p_VectorFieldList) {
		try {
			if ((p_VectorFieldList != null) && (p_VectorFieldList.size() > 0)) {
				// read field list....
				Enumeration enumFields = p_VectorFieldList.elements();
				while (enumFields.hasMoreElements()) {
					// get values for every field from the workitem
					String sFeldName = (String) enumFields.nextElement();
					Vector vValues = documentContext.getItemValue(sFeldName);
					// move values into the vector p_VectorDestination
					if ((vValues != null) && (vValues.size() > 0)) {
						Enumeration enumValues = vValues.elements();
						while (enumValues.hasMoreElements()) {
							Object o = enumValues.nextElement();

							// onyl append if value was not added before to
							// avoid duplicates
							if (p_VectorDestination.indexOf(o) == -1)
								p_VectorDestination.addElement(o);
						}
					}
				}
			}
		} catch (Exception e) {
			System.out.println("[MailPlugin] mergeMappedFieldValues Error :"
					+ e.toString());
			e.printStackTrace();
		}
	}

	/**
	 * this helper method creates an internet address from a string if the
	 * string has illegal characters like whitespace the string will be
	 * surrounded with "". If you subclass this MailPlugin Class you can
	 * overwrite this method to return a different mail-address name or lookup a
	 * mail attribute in a directory like a ldap directory.
	 * 
	 * @param aAddr
	 * @return
	 * @throws AddressException
	 */
	public InternetAddress getInternetAddress(String aAddr)
			throws AddressException {

		InternetAddress inetAddr = null;

		try {
			// surround with "" if space
			if (aAddr.indexOf(" ") > -1)
				inetAddr = new InternetAddress("\"" + aAddr + "\"");
			else
				inetAddr = new InternetAddress(aAddr);

		} catch (AddressException ae) {
			// return empty address part
			ae.printStackTrace();
			return null;
		}
		return inetAddr;
	}

	/**
	 * this method transforms a vector of emails into a InternetAddress Array.
	 * Null values will be removed from list
	 * 
	 * @param aList
	 * @return
	 */
	private InternetAddress[] getInternetAddressArray(Vector aList) {
		// set TO Recipient
		// store valid addresses into atemp vector to avoid null values
		InternetAddress inetAddr = null;
		Vector vReceipsTemp = new Vector();
		for (int i = 0; i < aList.size(); i++) {
			try {
				inetAddr = getInternetAddress(aList.elementAt(i).toString());
				if (inetAddr != null && !"".equals(inetAddr.getAddress()))
					vReceipsTemp.add(inetAddr);
			} catch (AddressException e) {
				// no todo
			}

		}

		// rebuild new InternetAddress array from TempVector...
		InternetAddress[] receipsAdrs = new InternetAddress[vReceipsTemp.size()];
		for (int i = 0; i < vReceipsTemp.size(); i++) {
			receipsAdrs[i] = (InternetAddress) vReceipsTemp.elementAt(i);
		}
		return receipsAdrs;
	}

	public Session getMailSession() {
		return mailSession;
	}

	public Message getMailMessage() {
		return mailMessage;
	}
	 
	public Multipart getMultipart() {
		return mimeMultipart;
	}

}
