/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.plugins;

import java.util.Collection;
import javax.ejb.EJBTransactionRolledbackException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.jee.plugins.AbstractPlugin;

public class VersionPlugin
extends AbstractPlugin {
    private EntityService entityService = null;
    private WorkflowService workflowService = null;
    private String versionMode = "";
    private int versionActivityID = -1;
    private ItemCollection version = null;

    public void init(WorkflowContext actx) throws Exception {
        super.init(actx);
        if (actx instanceof WorkflowService) {
            this.workflowService = (WorkflowService)actx;
            this.entityService = this.workflowService.getEntityService();
        }
        if (this.workflowService == null) {
            throw new RuntimeException("VersionPlugin unable to access WorkflowSerive");
        }
    }

    public ItemCollection getVersion() {
        return this.version;
    }

    public void setVersion(ItemCollection version) {
        this.version = version;
    }

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws Exception {
        this.versionMode = adocumentActivity.getItemValueString("keyVersion");
        this.versionActivityID = adocumentActivity.getItemValueInteger("numVersionActivityID");
        if ("1".equals(this.versionMode) || "2".equals(this.versionMode)) {
            if ("1".equals(this.versionMode)) {
                this.version = this.createVersion(adocumentContext);
                if (this.ctx.getDebugLevel() > 0) {
                    System.out.println("[VersionPlugin] new version created");
                }
                if (this.versionActivityID > 0) {
                    this.version.replaceItemValue("$ActivityID", (Object)this.versionActivityID);
                    this.version = this.workflowService.processWorkItem(this.version);
                } else {
                    this.version = this.entityService.save(this.version);
                }
                return 0;
            }
            if ("2".equals(adocumentActivity.getItemValueString("keyVersion"))) {
                String sworkitemID = adocumentContext.getItemValueString("$WorkItemID");
                String query = " SELECT workitem FROM Entity AS workitem  JOIN workitem.textItems AS t1 WHERE t1.itemName = '$workitemid' AND t1.itemValue ='" + sworkitemID + "'";
                Collection col = this.entityService.findAllEntities(query, 0, -1);
                for (ItemCollection aVersion : col) {
                    String sWorkitemRef = aVersion.getItemValueString("$workitemIDRef");
                    if (!"".equals(sWorkitemRef)) continue;
                    String id = adocumentContext.getItemValueString("$uniqueID");
                    aVersion.replaceItemValue("$WorkItemIDRef", (Object)id);
                    if (this.versionActivityID > 0) {
                        aVersion.replaceItemValue("$ActivityID", (Object)this.versionActivityID);
                        aVersion = this.workflowService.processWorkItem(aVersion);
                    } else {
                        aVersion = this.entityService.save(aVersion);
                    }
                    this.version = aVersion;
                }
                adocumentContext.removeItem("$WorkItemIDRef");
            }
        }
        return 0;
    }

    public void close(int status) throws Exception {
        if (status == 2) {
            throw new EJBTransactionRolledbackException();
        }
    }

    public ItemCollection createVersion(ItemCollection sourceItemCollection) throws Exception {
        ItemCollection itemColNewVersion = new ItemCollection();
        itemColNewVersion.replaceAllItems(sourceItemCollection.getAllItems());
        String id = sourceItemCollection.getItemValueString("$uniqueid");
        if ("".equals(id)) {
            throw new Exception("Error - unable to create a version from a new workitem!");
        }
        itemColNewVersion.getAllItems().remove("$uniqueid");
        itemColNewVersion.replaceItemValue("$WorkItemIDRef", (Object)id);
        return itemColNewVersion;
    }
}

