/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.plugins.extended;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.plugins.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LucenePlugin
extends AbstractPlugin {
    IndexWriter writer = null;
    static List<String> searchFieldList = null;
    static List<String> indexFieldListAnalyse = null;
    static List<String> indexFieldListNoAnalyse = null;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");
    private static int MAX_SEARCH_RESULT = 100;

    public void init(WorkflowContext actx) throws Exception {
        super.init(actx);
    }

    public int run(ItemCollection documentContext, ItemCollection activity) throws Exception {
        int nextProcessID = activity.getItemValueInteger("numnextprocessid");
        int currentProcessID = documentContext.getItemValueInteger("$processid");
        documentContext.replaceItemValue("$processid", (Object)nextProcessID);
        LucenePlugin.addWorkitem(documentContext);
        documentContext.replaceItemValue("$processid", (Object)currentProcessID);
        return 0;
    }

    public void close(int status) throws Exception {
    }

    public static boolean addWorkitem(ItemCollection documentContext) throws Exception {
        ArrayList<ItemCollection> workitems = new ArrayList<ItemCollection>();
        workitems.add(documentContext);
        LucenePlugin.addWorklist(workitems);
        return true;
    }

    public static boolean addWorklist(Collection<ItemCollection> worklist) throws Exception {
        Properties prop = LucenePlugin.loadProperties();
        if (prop.isEmpty()) {
            return false;
        }
        IndexWriter awriter = LucenePlugin.createIndexWriter(prop);
        try {
            for (ItemCollection workitem : worklist) {
                Term term = new Term("$uniqueid", workitem.getItemValueString("$uniqueid"));
                if (LucenePlugin.matchConditions(prop, workitem)) {
                    awriter.updateDocument(term, LucenePlugin.createDocument(prop, workitem));
                    continue;
                }
                awriter.deleteDocuments(term);
            }
        }
        catch (Exception luceneEx) {
            logger.warning(" Lucene Exception : " + luceneEx.getMessage());
            throw luceneEx;
        }
        finally {
            logger.fine(" close writer");
            awriter.optimize();
            awriter.close();
        }
        logger.fine(" update worklist successfull");
        return true;
    }

    public static boolean matchConditions(Properties prop, ItemCollection aworktiem) {
        String typePattern = prop.getProperty("MatchingType");
        String processIDPattern = prop.getProperty("MatchingProcessID");
        String type = aworktiem.getItemValueString("Type");
        String sPid = aworktiem.getItemValueInteger("$Processid") + "";
        if (typePattern != null && !"".equals(typePattern) && !type.matches(typePattern)) {
            return false;
        }
        return processIDPattern == null || "".equals(processIDPattern) || sPid.matches(processIDPattern);
    }

    public static List<ItemCollection> search(String sSearchTerm, WorkflowService workflowService) throws Exception {
        ArrayList<ItemCollection> workitems = new ArrayList<ItemCollection>();
        if (sSearchTerm == null || "".equals(sSearchTerm)) {
            return workitems;
        }
        long ltime = System.currentTimeMillis();
        Properties prop = LucenePlugin.loadProperties();
        if (prop.isEmpty()) {
            return workitems;
        }
        String sIndexDir = prop.get("IndexDir") + "";
        try {
            FSDirectory directory = FSDirectory.open((File)new File(sIndexDir));
            IndexSearcher searcher = new IndexSearcher((Directory)directory, true);
            KeywordAnalyzer analyzer = new KeywordAnalyzer();
            QueryParser parser = new QueryParser(Version.LUCENE_31, "content", (Analyzer)analyzer);
            if (!workflowService.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
                String[] roleList;
                String sAccessTerm = "($readaccess:ANONYMOUS $readaccess:" + workflowService.getUserName();
                for (String string : roleList = workflowService.getUserRoles()) {
                    if ("".equals(string) || !workflowService.isUserInRole(string)) continue;
                    sAccessTerm = sAccessTerm + " $readaccess:" + string;
                }
                sAccessTerm = sAccessTerm + ") AND ";
                sSearchTerm = sAccessTerm + sSearchTerm;
            }
            logger.info("  lucene search:" + sSearchTerm);
            if (!"".equals(sSearchTerm)) {
                parser.setAllowLeadingWildcard(true);
                TopDocs topDocs = searcher.search(parser.parse(sSearchTerm), 1000);
                logger.fine("  total hits=" + topDocs.totalHits);
                ScoreDoc[] scoreDosArray = topDocs.scoreDocs;
                for (String string : scoreDosArray) {
                    Document doc = searcher.doc(((ScoreDoc)string).doc);
                    String sID = doc.get("$uniqueid");
                    logger.fine("  lucene $uniqueid=" + sID);
                    ItemCollection itemCol = workflowService.getEntityService().load(sID);
                    if (itemCol != null) {
                        workitems.add(itemCol);
                    }
                    if (workitems.size() >= MAX_SEARCH_RESULT) break;
                }
            }
            searcher.close();
            directory.close();
            logger.info(" lucene serach: " + (System.currentTimeMillis() - ltime) + " ms");
        }
        catch (Exception e) {
            logger.warning("  lucene error!");
            e.printStackTrace();
        }
        return workitems;
    }

    public static Document createDocument(Properties prop, ItemCollection aworkitem) {
        String sValue = null;
        Document doc = new Document();
        String sContent = "";
        for (String aFieldname : searchFieldList) {
            sValue = "";
            Vector vValues = aworkitem.getItemValue(aFieldname);
            if (vValues.size() == 0) continue;
            for (Object o : vValues) {
                if (o == null) continue;
                if (o instanceof Calendar || o instanceof Date) {
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
                    String sDateValue = o instanceof Calendar ? dateformat.format(((Calendar)o).getTime()) : dateformat.format((Date)o);
                    sValue = sValue + sDateValue + ",";
                    continue;
                }
                sValue = sValue + o.toString() + ",";
            }
            if (sValue == null) continue;
            logger.fine("  add SearchField: " + aFieldname + " = " + sValue);
            sContent = sContent + sValue + ",";
        }
        logger.fine("  content = " + sContent);
        doc.add((Fieldable)new Field("content", sContent, Field.Store.NO, Field.Index.ANALYZED));
        for (String aFieldname : indexFieldListAnalyse) {
            LucenePlugin.addFieldValue(doc, aworkitem, aFieldname, true);
        }
        for (String aFieldname : indexFieldListNoAnalyse) {
            LucenePlugin.addFieldValue(doc, aworkitem, aFieldname, false);
        }
        doc.add((Fieldable)new Field("$uniqueid", aworkitem.getItemValueString("$uniqueid"), Field.Store.YES, Field.Index.NOT_ANALYZED));
        Vector vReadAccess = aworkitem.getItemValue("$readAccess");
        if (vReadAccess.size() == 0 || vReadAccess.size() == 1 && "".equals(((String)vReadAccess.firstElement()).toString())) {
            sValue = "ANONYMOUS";
            doc.add((Fieldable)new Field("$readaccess", sValue, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        } else {
            sValue = "";
            for (String sReader : vReadAccess) {
                doc.add((Fieldable)new Field("$readaccess", sReader, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
        return doc;
    }

    private static void addFieldValue(Document doc, ItemCollection aworkitem, String aFieldname, boolean analyzeValue) {
        String sValue = null;
        Vector vValues = aworkitem.getItemValue(aFieldname);
        if (vValues.size() == 0) {
            return;
        }
        if (vValues.firstElement() == null) {
            return;
        }
        Object o = vValues.firstElement();
        if (o instanceof Calendar || o instanceof Date) {
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
            String sDateValue = o instanceof Calendar ? dateformat.format(((Calendar)o).getTime()) : dateformat.format((Date)o);
            sValue = sDateValue;
        } else {
            sValue = o.toString();
        }
        logger.fine("  add IndexField (analyse=" + analyzeValue + "): " + aFieldname + " = " + sValue);
        if (analyzeValue) {
            doc.add((Fieldable)new Field(aFieldname, sValue, Field.Store.NO, Field.Index.ANALYZED));
        } else {
            doc.add((Fieldable)new Field(aFieldname, sValue, Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
    }

    public static IndexWriter createIndexWriter(Properties prop) throws Exception {
        String sName;
        String sIndexDir = prop.get("IndexDir") + "";
        String sFulltextFieldList = prop.get("FulltextFieldList") + "";
        String sIndexFieldListAnalyse = prop.get("IndexFieldListAnalyze") + "";
        String sIndexFieldListNoAnalyse = prop.get("IndexFieldListNoAnalyze") + "";
        logger.fine("IndexDir:" + sIndexDir);
        logger.fine("FulltextFieldList:" + sFulltextFieldList);
        logger.fine("IndexFieldListAnalyse:" + sIndexFieldListAnalyse);
        logger.fine("IndexFieldListNoAnalyse:" + sIndexFieldListNoAnalyse);
        StringTokenizer st = new StringTokenizer(sFulltextFieldList, ",");
        searchFieldList = new ArrayList<String>();
        while (st.hasMoreElements()) {
            sName = st.nextToken().toLowerCase();
            if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
            searchFieldList.add(sName);
        }
        st = new StringTokenizer(sIndexFieldListAnalyse, ",");
        indexFieldListAnalyse = new ArrayList<String>();
        while (st.hasMoreElements()) {
            sName = st.nextToken().toLowerCase();
            if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
            indexFieldListAnalyse.add(sName);
        }
        st = new StringTokenizer(sIndexFieldListNoAnalyse, ",");
        indexFieldListNoAnalyse = new ArrayList<String>();
        while (st.hasMoreElements()) {
            sName = st.nextToken().toLowerCase();
            if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
            indexFieldListNoAnalyse.add(sName);
        }
        FSDirectory indexDir = FSDirectory.open((File)new File(sIndexDir));
        StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_31);
        IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_31, (Analyzer)analyzer);
        iwc.setWriteLockTimeout(10000L);
        return new IndexWriter((Directory)indexDir, iwc);
    }

    public static IndexSearcher createIndexSearcher() throws Exception {
        Properties properties = LucenePlugin.loadProperties();
        String sIndexDir = properties.get("IndexDir") + "";
        FSDirectory directory = FSDirectory.open((File)new File(sIndexDir));
        return new IndexSearcher((Directory)directory, true);
    }

    public static Properties loadProperties() throws Exception {
        Properties prop = new Properties();
        try {
            prop.load(Thread.currentThread().getContextClassLoader().getResource("imixs-search.properties").openStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prop;
    }
}

