/*******************************************************************************
 *  Imixs IX Workflow Technology
 *  Copyright (C) 2001, 2008 Imixs Software Solutions GmbH,  
 *  http://www.imixs.com
 *  
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the terms of the GNU General Public License 
 *  as published by the Free Software Foundation; either version 2 
 *  of the License, or (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 *  General Public License for more details.
 *  
 *  You can receive a copy of the GNU General Public
 *  License at http://www.gnu.org/licenses/gpl.html
 *  
 *  Contributors:  
 *  	Imixs Software Solutions GmbH - initial API and implementation
 *  	Ralph Soika
 *******************************************************************************/

package org.imixs.workflow.jee.ejb;

import java.util.Collection;
import java.util.List;

import org.imixs.workflow.ItemCollection;

/**
 * The ModelManager is the JEE Implementation of the IX Workflow API Interface
 * org.imixs.workflow.Model. The Interface acts as a Service Facade and extends
 * the standard interface with methods to store model informations. The
 * ModelManager is independend form the IX JEE Entity EJBs and uses the standard
 * IntemCollection Object as a data transfer object to comunitcate with clients.
 * 
 * Find Details: https://ix-workflow.dev.java.net/
 * 
 * https://www.imixs.org
 * 
 * @see org.imixs.workflow.Model
 * @author rsoika
 * 
 */
public interface ModelService extends org.imixs.workflow.ExtendedModel {

	/**
	 * Saves or updates a ProcessEntitiy represented by an ItemCollection. The
	 * Entity is unique identified of its Attributes 'numProcessID' and
	 * '$modelversion' The Method verifies that an existing instance will be
	 * updated.
	 * 
	 * @param ic
	 * @throws Exception
	 */
	public void saveProcessEntity(ItemCollection ic) throws Exception;

	/**
	 * Saves or updates an ActivityEntity represented by an ItemCollection. The
	 * Entity is unique identified of its Attributes 'numProcessID',
	 * 'numActivityID' and '$modelversion' The Method verifies that an existing
	 * instance will be updated.
	 * 
	 * @param ic
	 * @throws Exception
	 */
	public void saveActivityEntity(ItemCollection ic) throws Exception;

	/**
	 * Saves or updates an EnvironmentEntity represented by an ItemCollection.
	 * The Entity is unique identified of its Attributes 'txtName' and
	 * '$modelversion' The Method verifies that an existing instance will be
	 * updated.
	 * 
	 * @param ic
	 * @throws Exception
	 */
	public void saveEnvironmentEntity(ItemCollection ic) throws Exception;
	
	
	
	
	/**
	 * returns the processList for a specific model version
	 * 
	 * @param aModelVersion
	 * @return
	 * @throws Exception
	 */
	public Collection<ItemCollection> getProcessEntityListByVersion(String aModelVersion)
			throws Exception;

	/**
	 * returns the ActivityList for a specific model version
	 * 
	 * @param aProcessID
	 * @param aModelVersion
	 * @return
	 * @throws Exception
	 */
	public Collection<ItemCollection> getActivityEntityListByVersion(int aProcessID, String aModelVersion)
			throws Exception;

	
	
	
	/**
	 * returns the EnvironmentList
	 * 
	 * @param aModelVersion
	 * @return
	 * @throws Exception
	 */
	public Collection<ItemCollection> getEnvironmentEntityList()
			throws Exception;

	/**
	 * returns the EnvironmentList for a specific model version
	 * 
	 * @param aModelVersion
	 * @return
	 * @throws Exception
	 */
	public Collection<ItemCollection> getEnvironmentEntityListByVersion(String aModelVersion)
			throws Exception;

	/**
	 * This method removes an existing model with the corresponding modelversion
	 * 
	 * @param aModelVersion
	 * @throws Exception
	 */
	public void removeModelVersion(String aModelVersion) throws Exception;

	
	
	
	public String getLatestVersion() throws Exception;

	

	/**
	 * returns a String list of all accessible Modelversions
	 * 
	 * @return
	 */
	public List<String> getAllModelVersions()  throws Exception;
	
	/*
	 * Extended Service Methods
	 */
	
	
	
	/**
	 * returns all the activities in a list for a corresponding process entity
	 * The method returns only Activities where keypublicresult != "0"
	 * 
	 * @return List<ItemCollection> of activity Entities
	 */
	public List<ItemCollection> getPublicActivities(int aprocessid);

	public List<ItemCollection> getPublicActivitiesByVersion(int aprocessid,
			String version);

	/**
	 * returns a String list of all existing ProcessGroup Names
	 * 
	 * @return
	 */
	public List<String> getAllWorkflowGroups();

	public List<String> getAllWorkflowGroupsByVersion(String version);


	/**
	 * returns a list of all ProcessEntities which are the first one in each
	 * ProcessGroup. So for each ProcessGroup the ProcessEntity with the lowest
	 * processID will be returned.
	 * 
	 * @return
	 */
	public List<ItemCollection> getAllStartProcessEntities();

	public List<ItemCollection> getAllStartProcessEntitiesByVersion(
			String version);

	/**
	 * returns a list of all ProcessEntities for a specific ProcessGroup
	 * 
	 * @return
	 */
	public List<ItemCollection> getAllProcessEntitiesByGroup(String aGroup);

}
