/*******************************************************************************
 *  Imixs IX Workflow Technology
 *  Copyright (C) 2001, 2008 Imixs Software Solutions GmbH,  
 *  http://www.imixs.com
 *  
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the terms of the GNU General Public License 
 *  as published by the Free Software Foundation; either version 2 
 *  of the License, or (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 *  General Public License for more details.
 *  
 *  You can receive a copy of the GNU General Public
 *  License at http://www.gnu.org/licenses/gpl.html
 *  
 *  Contributors:  
 *  	Imixs Software Solutions GmbH - initial API and implementation
 *  	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.jee.ejb;

import java.util.Collection;

import org.imixs.workflow.ItemCollection;

/**
 * This Interface represents a schedueld Workflow Service. 
 * It is used by the WorkflowSchedulerBean which implements 
 * a timer service to schedule workflow processing
 * 
 * @author rsoika
 *
 */
public interface WorkflowScheduler {

	/**
	 * schedules a new Workflow Service. The method expects an ItemCollection
	 * (timerdescription) with the following informations:
	 * 
	 * datstart - Date Object datstop - Date Object numInterval - Integer Object
	 * (interval in seconds) id - String - unique identifier for the schedule
	 * Service. This param should contain the EJB name as only one scheduled
	 * Workflow should run inside a single WorkflowInstance.
	 * If a timer with the id is already running the method stops this timer object first 
	 * and reschedules the timer .
	 */
	public void scheduleWorkflow(ItemCollection timerdescription)
			throws Exception;

	/**
	 * cancles a running timer instance. After cancel a timer the corresponding
	 * timerDescripton (ItemCollection) is no longer valid
	 * 
	 */
	public void cancelScheduleWorkflow(String id) throws Exception;

	/**
	 * this method returns a Itemcollection with the TimerDescirpiton for the
	 * specific timer object.
	 * 
	 * @param id
	 *            identifies the timer object
	 * @return ItemCollection containing the TimerDescription
	 * @throws Exception
	 */
	public ItemCollection findTimerDescription(String id) throws Exception;

	
	/**
	 * returns a list of all Timer Descriptions loaded by this Instance.
	 * @return
	 */
	public Collection<ItemCollection> findAllTimerDescriptions() throws Exception;
}
