/*******************************************************************************
 *  Imixs IX Workflow Technology
 *  Copyright (C) 2001, 2008 Imixs Software Solutions GmbH,  
 *  http://www.imixs.com
 *  
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the terms of the GNU General Public License 
 *  as published by the Free Software Foundation; either version 2 
 *  of the License, or (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 *  General Public License for more details.
 *  
 *  You can receive a copy of the GNU General Public
 *  License at http://www.gnu.org/licenses/gpl.html
 *  
 *  Contributors:  
 *  	Imixs Software Solutions GmbH - initial API and implementation
 *  	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.jee.jpa;

import javax.persistence.Basic;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;

import org.imixs.workflow.ItemCollection;

/**
 * The EntityData Bean holds the ItemCollection data of an Entity Bean. The
 * Entity Bean has an OneToOne RelationShip to the EntityData Bean. The usage of
 * the EntityData Bean by the Entity Bean supports a lazy loading mechanism.
 * 
 * @see org.imixs.workflow.jee.jpa.Entity
 * @author Ralph Soika
 * @version 1.0
 * 
 */
@javax.persistence.Entity
public class EntityData implements java.io.Serializable {

	/**
	 * default serial id
	 */
	private static final long serialVersionUID = 1L;

	@SuppressWarnings("unused")
	@Id
	@GeneratedValue
	private int id;

	private ItemCollection itemCollection;

	public EntityData() {
		super();
		itemCollection = new ItemCollection();
	}

	/**
	 * returns the data object part of the Entity represented by a
	 * org.imixs.workflow.ItemCollection.
	 * 
	 * @return ItemCollection
	 */
	@Lob
	@Basic
	public ItemCollection getItemCollection() {
		return itemCollection;
	}

	/**
	 * sets a data object for this Entity.
	 * 
	 * @param data
	 */
	public void setItemCollection(ItemCollection itemCol) {
		this.itemCollection = itemCol;
	}

}
