/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.jpa;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.imixs.workflow.jee.jpa.CalendarItem;
import org.imixs.workflow.jee.jpa.DoubleItem;
import org.imixs.workflow.jee.jpa.EntityData;
import org.imixs.workflow.jee.jpa.IntegerItem;
import org.imixs.workflow.jee.jpa.ReadAccessEntity;
import org.imixs.workflow.jee.jpa.TextItem;
import org.imixs.workflow.jee.jpa.WriteAccessEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@javax.persistence.Entity
public class Entity
implements Serializable {
    private static final long serialVersionUID = -1060228926637366942L;
    private String id;
    private String type;
    private Calendar created;
    private Calendar modified;
    private EntityData data;
    private List<ReadAccessEntity> readAccess;
    private List<WriteAccessEntity> writeAccess;
    private List<TextItem> textItems;
    private List<IntegerItem> integerItems;
    private List<DoubleItem> doubleItems;
    private List<CalendarItem> calendarItems;

    public Entity() {
        Calendar cal;
        String sIDPart1 = Long.toHexString(System.currentTimeMillis());
        double d = Math.random() * 9.0E8;
        int i = new Double(d).intValue();
        String sIDPart2 = Integer.toHexString(i);
        this.id = sIDPart1 + "-" + sIDPart2;
        this.created = cal = Calendar.getInstance();
    }

    public Entity(String aID) {
        this();
        this.id = aID;
    }

    @Id
    public String getId() {
        return this.id;
    }

    protected void setId(String aID) {
        this.id = aID;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreated() {
        return this.created;
    }

    public void setCreated(Calendar created) {
        this.created = created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getModified() {
        return this.modified;
    }

    public void setModified(Calendar modified) {
        this.modified = modified;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="itemValue")
    public List<TextItem> getTextItems() {
        if (this.textItems == null) {
            this.textItems = new Vector<TextItem>();
        }
        return this.textItems;
    }

    public void setTextItems(List<TextItem> textItems) {
        this.textItems = textItems;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="itemValue")
    public List<IntegerItem> getIntegerItems() {
        if (this.integerItems == null) {
            this.integerItems = new Vector<IntegerItem>();
        }
        return this.integerItems;
    }

    public void setIntegerItems(List<IntegerItem> integerItems) {
        this.integerItems = integerItems;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="itemValue")
    public List<DoubleItem> getDoubleItems() {
        if (this.doubleItems == null) {
            this.doubleItems = new Vector<DoubleItem>();
        }
        return this.doubleItems;
    }

    public void setDoubleItems(List<DoubleItem> doubleItems) {
        this.doubleItems = doubleItems;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="itemValue")
    public List<CalendarItem> getCalendarItems() {
        if (this.calendarItems == null) {
            this.calendarItems = new Vector<CalendarItem>();
        }
        return this.calendarItems;
    }

    public void setCalendarItems(List<CalendarItem> calendarItems) {
        this.calendarItems = calendarItems;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public EntityData getData() {
        if (this.data == null) {
            this.data = new EntityData();
        }
        return this.data;
    }

    public void setData(EntityData data) {
        this.data = data;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public List<ReadAccessEntity> getReadAccess() {
        if (this.readAccess == null) {
            this.readAccess = new Vector<ReadAccessEntity>();
        }
        return this.readAccess;
    }

    public void setReadAccess(List<ReadAccessEntity> acl) {
        this.readAccess = acl;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public List<WriteAccessEntity> getWriteAccess() {
        if (this.writeAccess == null) {
            this.writeAccess = new Vector<WriteAccessEntity>();
        }
        return this.writeAccess;
    }

    public void setWriteAccess(List<WriteAccessEntity> acl) {
        this.writeAccess = acl;
    }

    @PrePersist
    @PreUpdate
    private void updateModified() {
        Calendar cal;
        this.modified = cal = Calendar.getInstance();
    }
}

