/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.jsf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.util.ItemCollectionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkflowController {
    protected ItemCollection workitemItemCollection = null;
    protected ItemCollectionAdapter workitemAdapter = null;
    private String type;
    private ArrayList<ItemCollectionAdapter> activityList;
    private ArrayList<ItemCollectionAdapter> startProcessList = null;
    private String modelVersion = null;
    private ArrayList<ItemCollectionAdapter> workitems = null;
    private int maxSearchResult = 10;
    private int row = 0;
    private boolean endOfList = false;
    private int queryType = 0;
    private String searchQuery = null;
    final int QUERY_WORKLIST_BY_OWNER = 0;
    final int QUERY_WORKLIST_BY_CREATOR = 1;
    final int QUERY_WORKLIST_BY_AUTHOR = 2;
    final int QUERY_WORKLIST_ALL = 3;
    final int QUERY_WORKLIST_ARCHIVE = 4;
    final int QUERY_SEARCH = 5;
    @EJB
    private EntityService entityService;
    @EJB
    private ModelService modelService;
    @EJB
    private WorkflowService workflowService;

    public AbstractWorkflowController() {
        this.setType("workitem");
        this.workitemItemCollection = new ItemCollection();
        this.workitemAdapter = new ItemCollectionAdapter(this.workitemItemCollection);
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    public ModelService getModelService() {
        return this.modelService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public String getID() {
        if (this.workitemItemCollection == null) {
            return null;
        }
        return this.workitemItemCollection.getItemValueString("$uniqueid");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getModelVersion() {
        if (this.modelVersion == null) {
            try {
                this.modelVersion = this.modelService.getLatestVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public int getMaxSearchResult() {
        return this.maxSearchResult;
    }

    public void setMaxSearchResult(int searchCount) {
        this.maxSearchResult = searchCount;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String query) {
        this.searchQuery = query;
    }

    public void setWorkitem(ItemCollection aworkitem) {
        this.workitemItemCollection = aworkitem != null ? aworkitem : new ItemCollection();
        this.workitemAdapter.setItemCollection(this.workitemItemCollection);
    }

    public ItemCollection getWorkitem() {
        return this.workitemItemCollection;
    }

    public void doCreateWorkitem(ActionEvent event) throws Exception {
        List children = event.getComponent().getChildren();
        String processEntityIdentifier = "";
        for (int i = 0; i < children.size(); ++i) {
            UIParameter currentParam;
            if (!(children.get(i) instanceof UIParameter) || !(currentParam = (UIParameter)children.get(i)).getName().equals("id") || currentParam.getValue() == null) continue;
            processEntityIdentifier = currentParam.getValue().toString();
            break;
        }
        if (processEntityIdentifier != null && !"".equals(processEntityIdentifier)) {
            String sProcessModelVersion = null;
            String sProcessID = processEntityIdentifier;
            if (processEntityIdentifier.indexOf(124) > -1) {
                sProcessModelVersion = processEntityIdentifier.substring(0, processEntityIdentifier.indexOf(124));
                sProcessID = processEntityIdentifier.substring(processEntityIdentifier.indexOf(124) + 1);
                this.setModelVersion(sProcessModelVersion);
            }
            this.doCreateWorkitem(Integer.parseInt(sProcessID));
        }
    }

    public void doCreateWorkitem(int ProcessID) throws Exception {
        ItemCollection itemColProcessEntity = null;
        try {
            itemColProcessEntity = this.modelService.getProcessEntityByVersion(ProcessID, this.getModelVersion());
            if (itemColProcessEntity == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception eproc) {
            throw new Exception("unable to find ProcessEntity in model version " + this.getModelVersion() + " for ID=" + ProcessID);
        }
        String sEditorID = itemColProcessEntity.getItemValueString("txteditorid");
        int processID = itemColProcessEntity.getItemValueInteger("numProcessID");
        String sWorkflowGroup = itemColProcessEntity.getItemValueString("txtworkflowgroup");
        this.workitemItemCollection = new ItemCollection();
        this.workitemItemCollection.replaceItemValue("$ProcessID", (Object)new Integer(processID));
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String sUser = externalContext.getRemoteUser();
        this.workitemItemCollection.replaceItemValue("namCreator", (Object)sUser);
        this.workitemItemCollection.replaceItemValue("$WriteAccess", (Object)sUser);
        this.workitemItemCollection.replaceItemValue("$modelversion", (Object)this.getModelVersion());
        this.workitemItemCollection.replaceItemValue("txtworkflowgroup", (Object)sWorkflowGroup);
        this.workitemItemCollection.replaceItemValue("txteditorid", (Object)sEditorID);
        this.workitemItemCollection.replaceItemValue("type", (Object)this.getType());
        this.setWorkitem(this.workitemItemCollection);
    }

    public void doProcessWorkitem(ActionEvent event) throws Exception {
        List children = event.getComponent().getChildren();
        int activityID = -1;
        for (int i = 0; i < children.size(); ++i) {
            UIParameter currentParam;
            if (!(children.get(i) instanceof UIParameter) || !(currentParam = (UIParameter)children.get(i)).getName().equals("id") || currentParam.getValue() == null) continue;
            activityID = Integer.parseInt(currentParam.getValue().toString());
            break;
        }
        this.workitemItemCollection.replaceItemValue("$activityid", (Object)activityID);
        this.workitemItemCollection = this.workflowService.processWorkItem(this.workitemItemCollection);
        this.setWorkitem(this.workitemItemCollection);
        this.doReset(event);
    }

    public void doEdit(ActionEvent event) {
        ItemCollectionAdapter currentSelection = null;
        UIComponent component = event.getComponent();
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            currentSelection = (ItemCollectionAdapter)((UIData)parent).getRowData();
            this.setWorkitem(currentSelection.getItemCollection());
            break;
        }
    }

    public void doDelete(ActionEvent event) throws Exception {
        ItemCollectionAdapter currentSelection = null;
        UIComponent component = event.getComponent();
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            currentSelection = (ItemCollectionAdapter)((UIData)parent).getRowData();
            this.entityService.remove(currentSelection.getItemCollection());
            this.setWorkitem(null);
            this.doReset(event);
            break;
        }
    }

    public void doReset(ActionEvent event) {
        this.workitems = null;
        this.row = 0;
    }

    public void doRefresh(ActionEvent event) {
        this.workitems = null;
    }

    public void doSwitchToWorklistByAuthor(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_BY_AUTHOR;
        this.doReset(event);
    }

    public void doSwitchToWorklistByOwner(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_BY_OWNER;
        this.doReset(event);
    }

    public void doSwitchToWorklistByCreator(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_BY_CREATOR;
        this.doReset(event);
    }

    public void doSwitchToWorklistArchive(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_ARCHIVE;
        this.doReset(event);
    }

    public void doSwitchToWorklistAll(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_ALL;
        this.doReset(event);
    }

    public void doSwitchToSearchlist(ActionEvent event) {
        this.queryType = this.QUERY_SEARCH;
        this.doReset(event);
    }

    public void doLoadNext(ActionEvent event) {
        this.row += this.maxSearchResult;
        this.workitems = null;
    }

    public void doLoadPrev(ActionEvent event) {
        this.row -= this.maxSearchResult;
        if (this.row < 0) {
            this.row = 0;
        }
        this.workitems = null;
    }

    public List<ItemCollectionAdapter> getWorkitems() {
        if (this.workitems == null) {
            this.loadWorkItemList();
        }
        return this.workitems;
    }

    public int getRow() {
        return this.row;
    }

    public boolean isEndOfList() {
        return this.endOfList;
    }

    private void loadWorkItemList() {
        this.workitems = new ArrayList();
        List<ItemCollection> col = null;
        try {
            long lTime = System.currentTimeMillis();
            switch (this.queryType) {
                case 0: {
                    col = this.findWorkitemsByOwner(this.row, this.maxSearchResult);
                    break;
                }
                case 1: {
                    col = this.findWorkitemsByCreator(this.row, this.maxSearchResult);
                    break;
                }
                case 2: {
                    col = this.findWorkitemsByAuthor(this.row, this.maxSearchResult);
                    break;
                }
                case 5: {
                    col = this.findWorkitemsByQuery(this.getSearchQuery(), this.row, this.maxSearchResult);
                    break;
                }
                default: {
                    col = this.findAllWorkitems(this.row, this.maxSearchResult);
                }
            }
            lTime = System.currentTimeMillis() - lTime;
            System.out.println("  loadWorkItemList (" + lTime + " ms)");
            this.endOfList = col.size() < this.maxSearchResult;
            for (ItemCollection aworkitem : col) {
                this.workitems.add(new ItemCollectionAdapter(aworkitem));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.setWorkitem(null);
    }

    private List<ItemCollection> findWorkitemsByQuery(String query, int row, int count) {
        ArrayList<ItemCollection> workitemList = new ArrayList<ItemCollection>();
        if (query == null || "".equals(query)) {
            return workitemList;
        }
        Collection col = this.entityService.findAllEntities(query, row, count);
        workitemList.addAll(col);
        return workitemList;
    }

    private List<ItemCollection> findWorkitemsByOwner(int row, int count) {
        ArrayList<ItemCollection> teamList = new ArrayList<ItemCollection>();
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String name = externalContext.getRemoteUser();
        String sQuery = "SELECT wi FROM Entity as wi  JOIN wi.textItems as t2  WHERE wi.type= '" + this.getType() + "'" + " AND t2.itemName = 'namowner' and t2.itemValue = '" + name + "'" + " ORDER BY wi.modified desc";
        Collection col = this.entityService.findAllEntities(sQuery, row, count);
        teamList.addAll(col);
        return teamList;
    }

    private List<ItemCollection> findWorkitemsByAuthor(int row, int count) {
        ArrayList<ItemCollection> teamList = new ArrayList<ItemCollection>();
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String name = externalContext.getRemoteUser();
        String sQuery = "SELECT wi FROM Entity as wi  JOIN wi.writeAccess wa  WHERE wi.type = '" + this.getType() + "'" + " AND wa.value = '" + name + "'" + " ORDER BY wi.modified desc";
        Collection col = this.entityService.findAllEntities(sQuery, row, count);
        teamList.addAll(col);
        return teamList;
    }

    private List<ItemCollection> findWorkitemsByCreator(int row, int count) {
        ArrayList<ItemCollection> teamList = new ArrayList<ItemCollection>();
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String name = externalContext.getRemoteUser();
        String sQuery = "SELECT wi FROM Entity as wi  JOIN wi.textItems as t2  WHERE wi.type = '" + this.getType() + "'" + " AND t2.itemName = 'namcreator' and t2.itemValue = '" + name + "'" + " ORDER BY wi.modified desc";
        Collection col = this.entityService.findAllEntities(sQuery, row, count);
        teamList.addAll(col);
        return teamList;
    }

    private List<ItemCollection> findAllWorkitems(int row, int count) {
        ArrayList<ItemCollection> teamList = new ArrayList<ItemCollection>();
        String sQuery = "SELECT wi FROM Entity AS wi  WHERE wi.type= '" + this.getType() + "' ORDER BY wi.modified desc";
        Collection col = this.entityService.findAllEntities(sQuery, row, count);
        teamList.addAll(col);
        return teamList;
    }

    public String getWorkflowResult() {
        if (this.workitemItemCollection == null) {
            return "show_worklist";
        }
        String sResult = this.workitemItemCollection.getItemValueString("txtworkflowresultmessage");
        if (sResult == null || "".equals(sResult)) {
            return "show_worklist";
        }
        return sResult;
    }

    public Map getItem() throws Exception {
        return this.workitemAdapter.getItem();
    }

    public Map getItemList() throws Exception {
        return this.workitemAdapter.getItemList();
    }

    public Map getItemListArray() throws Exception {
        return this.workitemAdapter.getItemListArray();
    }

    public ArrayList<ItemCollectionAdapter> getActivities() {
        this.activityList = new ArrayList();
        if (this.workitemItemCollection == null) {
            return this.activityList;
        }
        int processId = this.workitemItemCollection.getItemValueInteger("$processid");
        String sversion = this.workitemItemCollection.getItemValueString("$modelversion");
        List col = sversion != null && !"".equals(sversion) ? this.modelService.getPublicActivitiesByVersion(processId, sversion) : this.modelService.getPublicActivitiesByVersion(processId, this.getModelVersion());
        for (ItemCollection aworkitem : col) {
            this.activityList.add(new ItemCollectionAdapter(aworkitem));
        }
        return this.activityList;
    }

    public ArrayList<ItemCollectionAdapter> getStartProcessList() {
        if (this.startProcessList != null) {
            return this.startProcessList;
        }
        this.startProcessList = new ArrayList();
        List col = this.modelService.getAllStartProcessEntitiesByVersion(this.getModelVersion());
        for (ItemCollection aworkitem : col) {
            this.startProcessList.add(new ItemCollectionAdapter(aworkitem));
        }
        return this.startProcessList;
    }

    public boolean isNewWorkitem() {
        try {
            return !this.workitemItemCollection.hasItem("numlastactivityid");
        }
        catch (Exception e) {
            return true;
        }
    }
}

