package org.imixs.workflow.jee.jsf.util;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * This Backing Bean acts as a Login Helper Class. Can be used to identify the
 * login state
 * 
 * @author rsoika
 * 
 */
public class LoginMB {

	/**
	 * returns true if user is authenticated 
	 * @return
	 */
	public boolean isAuthenticated() {		
		return (getUserPrincipal() != null);
	}

	/**
	 * returns the userPrincipal Name 
	 * @return
	 */
	public String getUserPrincipal() {
		FacesContext context = FacesContext.getCurrentInstance();
		ExternalContext externalContext = context.getExternalContext();
		return externalContext.getUserPrincipal() != null ? externalContext
				.getUserPrincipal().toString() : null;
	}

	/**
	 * returns the remote user Name
	 * @return
	 */
	public String getRemoteUser() {
		FacesContext context = FacesContext.getCurrentInstance();
		ExternalContext externalContext = context.getExternalContext();
		String remoteUser = externalContext.getRemoteUser();
		return remoteUser;
	}

	/**
	 * returns the full qualified server URI from the current web context
	 * @return
	 */
	public String getServerURI() {
		HttpServletRequest servletRequest = (HttpServletRequest) FacesContext
				.getCurrentInstance().getExternalContext().getRequest();

		
		String port=""+servletRequest.getLocalPort();
		
		String server = servletRequest.getServerName();
		return "http://"+ server+":"+port+"";

	}

	/**
	 * invalidates the current user session
	 * @param event
	 */
	public void doLogout(ActionEvent event) {
		FacesContext context = FacesContext.getCurrentInstance();
		ExternalContext externalContext = context.getExternalContext();

		HttpSession session = (HttpSession) externalContext.getSession(false);

		session.invalidate();

	}

}
