/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItem;
import org.imixs.workflow.xml.XMLItemCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLItemCollectionAdapter {
    public static ItemCollection getItemCollection(XMLItemCollection entity) {
        ItemCollection itemCol = new ItemCollection();
        if (entity == null) {
            return itemCol;
        }
        try {
            XMLItem[] items = entity.getItem();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    XMLItem it = items[i];
                    String key = it.getName();
                    Vector<Object> myVector = new Vector<Object>(Arrays.asList(it.getValue()));
                    itemCol.replaceItemValue(key, myVector);
                }
            }
        }
        catch (Exception e) {
            System.out.println("[XMLItemCollectionAdapter] getItemCollection error");
            System.out.println(e.toString());
            itemCol = null;
        }
        return itemCol;
    }

    public static XMLItemCollection putItemCollection(ItemCollection aItemCollection) throws Exception {
        String sName = null;
        XMLItemCollection entity = new XMLItemCollection();
        int i = 0;
        try {
            if (aItemCollection != null) {
                Iterator it = aItemCollection.getAllItems().entrySet().iterator();
                int max = aItemCollection.getAllItems().entrySet().size();
                XMLItem[] items = new XMLItem[max];
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    sName = (String)entry.getKey();
                    Vector vOrg = (Vector)entry.getValue();
                    XMLItem item = new XMLItem();
                    item.setName(sName);
                    item.setValue(vOrg.toArray());
                    items[i] = item;
                    ++i;
                }
                entity.setItem(items);
            }
        }
        catch (Exception e) {
            System.out.println("[XMLItemCollectionAdapter] Error putItemCollection (" + sName + ")");
            throw e;
        }
        return entity;
    }

    public static EntityCollection putCollection(Collection<ItemCollection> col) throws Exception {
        EntityCollection entiCol = new EntityCollection();
        Iterator<ItemCollection> it = col.iterator();
        int max = col.size();
        int i = 0;
        XMLItemCollection[] entities = new XMLItemCollection[max];
        while (it.hasNext()) {
            XMLItemCollection entity;
            ItemCollection icw = it.next();
            entities[i] = entity = XMLItemCollectionAdapter.putItemCollection(icw);
            ++i;
        }
        if (max > 0) {
            entiCol.setEntity(entities);
        }
        return entiCol;
    }
}

