/*******************************************************************************
 * Imixs IX Workflow Technology
 * Copyright (C) 2003, 2007 Imixs Software Solutions GmbH,  
 * http://www.imixs.com
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation version 2.1.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You can receive a copy of the GNU Lesser General Public
 * License at http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:  
 * 	Imixs Software Solutions GmbH - initial API and implementation
 * 	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.webservices.soap;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

import org.imixs.workflow.webservices.Base64;



/**
 * The ServiceClient is a WebService Client which encapsulate the SOAP
 * communication with a web serice endpoint. This Class is build on the Apache
 * Axiom and a simple URL Connection Class. The ServiceClient supports methods
 * for easy establishing a webservice communication. You can call a webservice
 * method by using the callSOAPAction method. The method expects the soap action
 * represended by a String object and a OMElement with the parameters for the
 * web service method call. The OMElement can be build on the Axiom framework or
 * easyly by usning the helper class DataObjectUtil. After a SOAPMethod call the
 * serviceClient returns also a OMElement with the soap response represendet
 * again by a OMElement which contains only the method response object. To
 * receife the hohle soap response use the getSOAPResponse method.
 * 
 * @see org.imixs.workflow.service.client.axiom.DataObjectUtil
 * @author Ralph Soika
 * 
 */
public class ServiceClient {
	public final static int SOAP11 = 11;

	public final static int SOAP12 = 12;

//	private SOAPFactory factory = null;

	private int iSoapType = SOAP11;

	private String serviceEndpoint;
	
	private String sUser=null;
	
	private String sPassword=null;

	private String encoding = "UTF-8";

	private int iLastHTTPResult = 0;

//	private OMElement lastSOAPResponse = null;

	public ServiceClient(String aServiceEndpoint) {
		serviceEndpoint = aServiceEndpoint;
	}

	

	// Sets credentials
	public void setCredentials(String auser, String apw) {
		sUser=auser;
		sPassword=apw;
	}


	public void setSoapType(int i) {
		iSoapType = i;
	}

	public void setEncoding(String aEncoding) {
		encoding = aEncoding;
	}



	/**
	 * This method calls a soap methode with the requestEntity Object in the
	 * SOAP Body. The requestEntity must be a valid OMElement. To generate this
	 * element you can use the helper class DataObjectUtil The method returns
	 * the body OMElement from the SOAP request if the SOAP envelope is valid
	 * 
	 * The method makes use urlConnection instat of the
	 * org.apache.commons.httpclient Framework.
	 * 
	 * @see org.imixs.workflow.service.client.axiom.DataObjectUtil
	 * @param soapAction
	 * @param requestEntity
	 * @return
	 */
	public Object callSOAPAction(QName soapAction, Object requestEntity) throws Exception{
	//	OMElement responseElement = null;
		PrintWriter printWriter = null;
		String sSoapAction = soapAction.getLocalPart();
		
		try {
			URLConnection urlConnection = new URL(serviceEndpoint)
					.openConnection();
			urlConnection.setDoOutput(true);
			urlConnection.setDoInput(true);
			urlConnection.setAllowUserInteraction(false);

			// Authorization
			if (sUser != null) {

				urlConnection
						.setRequestProperty(
								"Authorization",
								"Basic "
										+ this
												.getAccessByUser());
			}
			/** * HEADER ** */
			urlConnection.setRequestProperty("Content-Type",
					"text/xml; charset=" +encoding);
			
			urlConnection.setRequestProperty("SOAPAction", "/" + sSoapAction);

		//	SOAPEnvelope envelope = this.createSOAPEnvelope();
			// add Request Body...
		//	envelope.getBody().addChild(requestEntity);
			// compute length
		//	urlConnection.setRequestProperty("Content-Length", ""+new Integer( envelope.toString().getBytes().length));

			printWriter = new PrintWriter(new BufferedWriter(
					new OutputStreamWriter(urlConnection.getOutputStream(),
							encoding)));

		//	printWriter.write(envelope.toString());
			printWriter.close();
			String sHTTPResponse = urlConnection.getHeaderField(0);
			try {
				iLastHTTPResult = Integer.parseInt(sHTTPResponse.substring(9,
						12));
			} catch (Exception eNumber) {
				//eNumber.printStackTrace();
				iLastHTTPResult = 500;
			}

			InputStream is = urlConnection.getInputStream();
			// create the parser
			XMLStreamReader parser = XMLInputFactory.newInstance()
					.createXMLStreamReader(is);
			// create the builder
			/*
			StAXOMBuilder builder = new StAXOMBuilder(parser);
			// get the root element (in this case the envelope)
			responseElement = builder.getDocumentElement();
			lastSOAPResponse = responseElement;
			QName opNameBody = new QName(
					"http://schemas.xmlsoap.org/soap/envelope/", "Body");
			// now try to receife body and response element
			OMElement soapBody = responseElement
					.getFirstChildWithName(opNameBody);
					
			if (soapBody != null)
				responseElement = soapBody.getFirstElement();
			*/
		} catch (Exception ioe) {
			//ioe.printStackTrace();
			throw ioe;
		} finally {
			// Release current connection
			if (printWriter != null)
				printWriter.close();
		}
return null;
	//	return responseElement;

	}

	public int getLastHTTPResult() {
		return iLastHTTPResult;
	}

	public Object getLastSOAPResponse() {
		return null;
		//return lastSOAPResponse;
	}

	/**
	 * This mehtod creates a SOAP Envelop based on the current SOAPType
	 * 
	 * @return
	 */
	private Object createSOAPEnvelope() {
		/*
		if (iSoapType == SOAP12)
			factory = OMAbstractFactory.getSOAP12Factory();
		else
			factory = OMAbstractFactory.getSOAP11Factory();

		SOAPEnvelope envelope = factory.getDefaultEnvelope();
*/
		/*
		 * xsNameSpace = factory.createOMNamespace(
		 * "http://www.w3.org/2001/XMLSchema", "xs");
		 * 
		 * xsiNameSpace = factory.createOMNamespace(
		 * "http://www.w3.org/2001/XMLSchema-instance", "xsi");
		 */
		// OMElement body = envelope.getBody();
	//	return envelope;
		return null;
	}

	/**
	 * Diese Methode setzt f�r den Zugriff auf eine URL eine Definierte UserID +
	 * Passwort
	 */
	private String getAccessByUser() {
		String sURLAccess = "";
		// UserID:Passwort
		String sUserCode = sUser + ":"
				+ sPassword;
		// String convertieren
		char[] authcode=Base64.encode(sUserCode.getBytes());
		sURLAccess = String.valueOf(authcode);
		return sURLAccess;
	}
}
