/*******************************************************************************
 * Imixs IX Workflow Technology
 * Copyright (C) 2003, 2007 Imixs Software Solutions GmbH,  
 * http://www.imixs.com
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation version 2.1.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You can receive a copy of the GNU Lesser General Public
 * License at http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:  
 * 	Imixs Software Solutions GmbH - initial API and implementation
 * 	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.webservices.soap;

import javax.xml.namespace.QName;

import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;


/**
 * The WorkflowManagerClient is a WebSerice Client for the Imixs WorkflowManager
 * Service based on the Apache Axiom Framework. The WorkflowManagerClient uses
 * the helper class org.imixs.workflow.service.client.axiom.ServiceClient to
 * establish SOAP Connections
 * 
 * @see org.imixs.workflow.RestClient.client.axiom.ServiceClient
 * @author Ralph Soika
 * 
 */
public class WorkflowManagerClient implements WorkflowManagerService {
	private ServiceClient serviceClient = null;

	private String NAME_SPACE = "http://imixs.org/workflow/services";

	public WorkflowManagerClient(String aServiceEndpoint, String aUserName,
			String aPassword) {
		serviceClient = new ServiceClient(aServiceEndpoint);
		serviceClient.setCredentials(aUserName,
				aPassword);

	}

	public String getNameSpace() {
		return NAME_SPACE;
	}

	public void setNameSpace(String s) {
		NAME_SPACE = s;
	}

	public ServiceClient getServiceClient() {
		return serviceClient;
	}

	public XMLItemCollection createWorkItem(int processID) throws Exception {
		// Operation definieren
		QName opName = new QName(NAME_SPACE, "createWorkItem");
		// create Parameter for Operation 
		Object[] opArgs = new Object[] { new Integer(processID) };
		// create OMElement for Reqeust 
	//	OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,new String[] {"processid"});

	//	OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		/*
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof XMLItemCollection)
			return (XMLItemCollection) o;
		else*/
			return null;

	}

	public XMLItemCollection getWorkItem(String workitemID)
			throws Exception {
		// Operation definieren
		QName opName = new QName(NAME_SPACE, "getWorkItem");
		// Parameter f�r Operation definieren
		Object[] opArgs = new Object[] { workitemID };
		// OMElement f�r Reqeust erzeugen
	//	OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,new String[] {"workitemid","attributes"});

//		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		/*
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof XMLItemCollection)
			return (XMLItemCollection) o;
		else*/
			return null;

	}

	public EntityCollection getWorkList(String name, int start, int count) throws Exception {
		return getWorkListByMethodName("getWorkList", name, start, count);
	}

	public EntityCollection getWorkListByCreator(String name, int start,
			int count) throws Exception {
		return getWorkListByMethodName("getWorkListByCreator", name, start,
				count);
	}

	public EntityCollection getWorkListByGroup(String name, int start,
			int count) throws Exception {
		return getWorkListByMethodName("getWorkListByGroup", name, start,
				count);

	}
	
	
	

	public EntityCollection getWorkListByRef(String aref, int startpos,
			int count) throws Exception {
		return getWorkListByMethodName("getWorkListByRef", aref, startpos,
				count);
	}

	public EntityCollection getWorkListByProcessID(int id, int start,
			int count) throws Exception {
		return getWorkListByMethodName("getWorkListByProcessID", "" + id,
				start, count);

	}

	public boolean isAuthor(String workitemID) throws Exception {
		// Operation definieren
		QName opName = new QName(NAME_SPACE, "isAuthor");
		// Parameter f�r Operation definieren
		Object[] opArgs = new Object[] { workitemID };
		// OMElement f�r Reqeust erzeugen
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,new String[] {"workitemid"});

		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		Boolean bResult = (Boolean) DataObjectUtil.deserialize(response);

		return bResult.booleanValue();
		*/
		return false;
	}

	public XMLItemCollection processWorkItem(XMLItemCollection workitem, int activityID) throws Exception {
		// Operation definieren
		QName opName = new QName(NAME_SPACE, "processWorkItem");
		// Parameter f�r Operation definieren
		Object[] opArgs = new Object[] { workitem, new Integer(activityID) };
		// OMElement f�r Reqeust erzeugen
	//	OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,new String[] {"workitem","activityid","attributes"});
	//	OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		/*
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof XMLItemCollection)
			return (XMLItemCollection) o;
		else*/
			return null;

	}

	public void removeWorkItem(String workitemid) throws Exception {
		// Operation definieren
		QName opName = new QName(NAME_SPACE, "removeWorkItem");
		// Parameter f�r Operation definieren
		Object[] opArgs = new Object[] { workitemid };
		// OMElement f�r Reqeust erzeugen
	//	OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,new String[] {"workitemid"});

	//	serviceClient.callSOAPAction(opName, requestData);
	}

	private EntityCollection getWorkListByMethodName(String aMethodName,
			String name, int start, int count)
			throws Exception {
		// Operation definieren
		QName opName = new QName(NAME_SPACE, aMethodName);
		// Parameter f�r Operation definieren
		Object[] opArgs = new Object[] { name, new Integer(start),
				new Integer(count) };
		// OMElement f�r Reqeust erzeugen
	//	OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,new String[] {"key","startpos","count","attributes"});
		
	//	OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		//Object o = DataObjectUtil.deserialize(response);
	//	if (o instanceof EntityCollection)
	//		return (EntityCollection) o;
	//	else
			return new EntityCollection();

	}

}
