/*******************************************************************************
 * Imixs IX Workflow Technology
 * Copyright (C) 2003, 2007 Imixs Software Solutions GmbH,  
 * http://www.imixs.com
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation version 2.1.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You can receive a copy of the GNU Lesser General Public
 * License at http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:  
 * 	Imixs Software Solutions GmbH - initial API and implementation
 * 	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.webservices.soap;

import javax.xml.namespace.QName;

import org.imixs.workflow.xml.EntityCollection;


/**
 * The WorkflowModelClient is a WebSerice Client for the Imixs WorkflowModel
 * Service based on the Apache Axiom Framework. The WorkflowModelClient uses the
 * helper class org.imixs.workflow.service.client.axiom.ServiceClient to
 * establish SOAP Connections
 * 
 * Since 1.7.0
 * 
 * This WebService Client also implements the new ModelService Methods provided
 * by the IX JEE Workflow Version 1.7.0. So This client is compatible to both -
 * the IX Workflow API and the IX JEE Implementation with MultiModel Support
 * 
 * @see org.imixs.workflow.RestClient.client.axiom.ServiceClient
 * @author Ralph Soika
 * 
 */
public class WorkflowModelClient implements WorkflowModelService {
	private ServiceClient serviceClient = null;

	private String NAME_SPACE = "http://imixs.org/workflow/services";

	public WorkflowModelClient(String aServiceEndpoint, String aUserName,
			String aPassword) {
		serviceClient = new ServiceClient(aServiceEndpoint);
		// serviceClient.setCredentials(new
		// UsernamePasswordCredentials(aUserName, aPassword));
		serviceClient.setCredentials(aUserName, aPassword);

	}

	public String getNameSpace() {
		return NAME_SPACE;
	}

	public void setNameSpace(String s) {
		NAME_SPACE = s;
	}

	public ServiceClient getServiceClient() {
		return serviceClient;
	}

	public EntityCollection getProcessList() throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "getProcessList");
		// create Parameter for Operation
		Object[] opArgs = new Object[] {};
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				null);

		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof EntityCollection)
			return (EntityCollection) o;
		else*/
			return new EntityCollection();

	}

	public EntityCollection getProcessListByVersion(String modelVersion)
			throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "getProcessListByVersion");
		// create Parameter for Operation
		Object[] opArgs = new Object[] { modelVersion };
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "modelversion" });

		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof EntityCollection)
			return (EntityCollection) o;
		else*/
			return new EntityCollection();

	}

	public EntityCollection getActivityList(int processID) throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "getActivityList");
		// create Parameter for Operation
		Object[] opArgs = new Object[] { new Integer(processID) };
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "processid" });

		// System.out.println("Request="+requestData);
		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof EntityCollection)
			return (EntityCollection) o;
		else*/
			return new EntityCollection();
	}

	public EntityCollection getActivityListByVersion(int processID,
			String modelVersion) throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "getActivityListByVersion");
		// create Parameter for Operation
		Object[] opArgs = new Object[] { new Integer(processID), modelVersion };
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "processid", "modelversion" });

		// System.out.println("Request="+requestData);
		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof EntityCollection)
			return (EntityCollection) o;
		else*/
			return new EntityCollection();
	}

	public EntityCollection getEnvironmentList() throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "getEnvironmentList");
		// create Parameter for Operation
		Object[] opArgs = new Object[] {};
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				null);

		OMElement response = serviceClient.callSOAPAction(opName, requestData);

		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof EntityCollection)
			return (EntityCollection) o;
		else*/
			return new EntityCollection();

	}

	public EntityCollection getEnvironmentListByVersion(String modelVersion)
			throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "getEnvironmentListByVersion");
		// create Parameter for Operation
		Object[] opArgs = new Object[] { modelVersion };
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "modelversion" });

		OMElement response = serviceClient.callSOAPAction(opName, requestData);

		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof EntityCollection)
			return (EntityCollection) o;
		else*/
			return new EntityCollection();

	}

	public void updateActivityList(int processID, EntityCollection activityList)
			throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "updateActivityList");
		// create Parameter for Operation
		Object[] opArgs = new Object[] { new Integer(processID), activityList };
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "processid", "activitylist" });

		serviceClient.callSOAPAction(opName, requestData);
*/
	}

	public void updateEnvironmentList(EntityCollection envList)
			throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "updateEnvironmentList");
		// create Parameter for Operation

		Object[] opArgs = new Object[] { envList };
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "environmentlist" });

		serviceClient.callSOAPAction(opName, requestData);
		*/
	}

	public void updateProcessList(EntityCollection envList) throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "updateProcessList");
		// create Parameter for Operation
		Object[] opArgs = new Object[] { envList };
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "processlist" });

		serviceClient.callSOAPAction(opName, requestData);*/
	}

	public void removeModelVersion(String modelVersion) throws Exception {
		// create Operation
		QName opName = new QName(NAME_SPACE, "removeModelVersion");
		// create Parameter for Operation
		Object[] opArgs = new Object[] { modelVersion };
		// create OMElement for Request
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "modelversion" });

		serviceClient.callSOAPAction(opName, requestData);
*/
	}

}
