/*******************************************************************************
 *  Imixs IX Workflow Technology
 *  Copyright (C) 2001, 2008 Imixs Software Solutions GmbH,  
 *  http://www.imixs.com
 *  
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the terms of the GNU General Public License 
 *  as published by the Free Software Foundation; either version 2 
 *  of the License, or (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 *  General Public License for more details.
 *  
 *  You can receive a copy of the GNU General Public
 *  License at http://www.gnu.org/licenses/gpl.html
 *  
 *  Contributors:  
 *  	Imixs Software Solutions GmbH - initial API and implementation
 *  	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.webservices.soap;

import org.imixs.workflow.xml.EntityCollection;

/**
 * Service Interface for the WorkflowModel
 * 
 * @author Ralph Soika
 * @version 1.0
 */

public interface WorkflowModelService {

	/**
	 * returns the processList for the highest model version
	 * 
	 * @return
	 * @throws Exception
	 */
	public EntityCollection getProcessList() throws Exception;

	/**
	 * returns the ActivityList for the highest model version
	 * 
	 * @param aProcessID
	 * @return
	 * @throws Exception
	 */
	public EntityCollection getActivityList(int aProcessID) throws Exception;

	/**
	 * Updates a ProcessList
	 * 
	 * @param aProcessList
	 * @throws Exception
	 */
	public void updateProcessList(EntityCollection aProcessList)
			throws Exception;

	/**
	 * Updates a ActivityList
	 * 
	 * @param aProcessID
	 * @param aActivityList
	 * @throws Exception
	 */
	public void updateActivityList(int aProcessID,
			EntityCollection aActivityList) throws Exception;

	/**
	 * returns the EnvironmentList for the highest model version
	 * 
	 * @return
	 * @throws Exception
	 */
	public EntityCollection getEnvironmentList() throws Exception;

	/**
	 * updates the environmentList
	 * 
	 * @param aEnvironmentList
	 * @throws Exception
	 */
	public void updateEnvironmentList(EntityCollection aEnvironmentList)
			throws Exception;

	/**
	 * returns the processList for a specific model version
	 * 
	 * @param aModelVersion
	 * @return
	 * @throws Exception
	 */
	public EntityCollection getProcessListByVersion(String aModelVersion)
			throws Exception;

	/**
	 * returns the ActivityList for a specific model version
	 * 
	 * @param aProcessID
	 * @param aModelVersion
	 * @return
	 * @throws Exception
	 */
	public EntityCollection getActivityListByVersion(int aProcessID,
			String aModelVersion) throws Exception;

	/**
	 * returns the EnvironmentList for a specific model version
	 * 
	 * @param aModelVersion
	 * @return
	 * @throws Exception
	 */
	public EntityCollection getEnvironmentListByVersion(String aModelVersion)
			throws Exception;

	/**
	 * This method removes an existing model with the corresponding modelversion
	 * 
	 * @param aModelVersion
	 * @throws Exception
	 */
	public void removeModelVersion(String aModelVersion) throws Exception;

}
