/*******************************************************************************
 * Imixs IX Workflow Technology
 * Copyright (C) 2003, 2007 Imixs Software Solutions GmbH,  
 * http://www.imixs.com
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation version 2.1.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You can receive a copy of the GNU Lesser General Public
 * License at http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:  
 * 	Imixs Software Solutions GmbH - initial API and implementation
 * 	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.webservices.soap;

import javax.xml.namespace.QName;

import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;


/**
 * The WorkflowManagerClient is a WebSerice Client for the Imixs WorkflowManager
 * Service based on the Apache Axiom Framework. The WorkflowManagerClient uses
 * the helper class org.imixs.workflow.service.client.axiom.ServiceClient to
 * establish SOAP Connections
 * 
 * @see org.imixs.workflow.RestClient.client.axiom.ServiceClient
 * @author Ralph Soika
 * 
 */
public class WorkflowReportClient implements WorkflowReportService {
	private ServiceClient serviceClient = null;

	private String NAME_SPACE = "http://imixs.org/workflow/services";

	public WorkflowReportClient(String aServiceEndpoint, String aUserName,
			String aPassword) {
		serviceClient = new ServiceClient(aServiceEndpoint);
		serviceClient.setCredentials(aUserName, aPassword);

	}

	public String getNameSpace() {
		return NAME_SPACE;
	}

	public void setNameSpace(String s) {
		NAME_SPACE = s;
	}

	public ServiceClient getServiceClient() {
		return serviceClient;
	}

	

	public XMLItemCollection getReport(String name)
			throws Exception {
		// define Operation
		QName opName = new QName(NAME_SPACE, "getReport");
		// define Parameter
		Object[] opArgs = new Object[] { name };
		// create OMElement Reqeust
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "reportid", "attributes" });

		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof XMLItemCollection)
			return (XMLItemCollection) o;
		else*/
			return null;
	}

	public EntityCollection getReportList(int start, int count) throws Exception {
		// define Operation
		QName opName = new QName(NAME_SPACE, "getReportList");
		// define Parameter
		Object[] opArgs = new Object[] { new Integer(start),
				new Integer(count) };
		// create OMElement
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "startpos", "count", "attributes" });

		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof EntityCollection)
			return (EntityCollection) o;
		else*/
			return new EntityCollection();

	}

	public EntityCollection processQuery(String reportid) throws Exception {
		// define Operation
		QName opName = new QName(NAME_SPACE, "processQuery");
		// define Parameter
		Object[] opArgs = new Object[] { reportid };
		// create OMElement
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "reportid", "attributes" });
		OMElement response = serviceClient.callSOAPAction(opName, requestData);
		// get result object
		Object o = DataObjectUtil.deserialize(response);
		if (o instanceof EntityCollection)
			return (EntityCollection) o;
		else*/
			return new EntityCollection();

	}

	public void updateReport(XMLItemCollection report) throws Exception {
		// define Operation
		QName opName = new QName(NAME_SPACE, "updateReport");
		// define Parameter
		Object[] opArgs = new Object[] { report };
		// create OMElement
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "report" });
		serviceClient.callSOAPAction(opName, requestData);
*/
	}

	public void updateReportList(EntityCollection reportList) throws Exception {

		// define Operation
		QName opName = new QName(NAME_SPACE, "updateReportList");
		// define Parameter

		Object[] opArgs = new Object[] { reportList };
		// create OMElement
		/*
		OMElement requestData = DataObjectUtil.getOMElement(opName, opArgs,
				new String[] { "reportlist" });

		serviceClient.callSOAPAction(opName, requestData);
		*/
	}

}
