package org.imixs.workflow.webservices.soap;

import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;

/**
 * Service Interface of a ReportService. This Service Interface supports methods
 * to create, process and find report instances. This interface should be used
 * by a workflowReportService server component.
 * 
 * A Report Entity is identified by its name represented by the attribute
 * 'txtname' So a ReportService Implementation should ensure that txtname is a
 * unique key for the report entity.
 * 
 * Also each report entity holds a EQL Query in the attribute "txtquery". this
 * eql statement will be processed by the processQuery method and should return
 * a collection of entities defined by the query.
 * 
 * 
 * 
 * @author rsoika
 * 
 */
public interface WorkflowReportService {

	/**
	 * updates a Entity Report Object. The Entity representing a report must
	 * have at least the attributes : txtQuery, numMaxCount, numStartPost,
	 * txtName.
	 * 
	 * txtName is the unique key to be use to get a query.
	 * 
	 * @param report
	 * @throws Exception
	 */
	public void updateReport(XMLItemCollection report) throws Exception;

	/**
	 * updates a list of Entity Report Objects. Each Entity representing a
	 * report must have at least the attributes : txtQuery, numMaxCount,
	 * numStartPost, txtName.
	 * 
	 * txtName is the unique key to be use to get a query.
	 * 
	 * @param reportList
	 * @throws Exception
	 */
	public void updateReportList(EntityCollection reportList) throws Exception;

	/**
	 * returns a QueryEntity Object identified by the attribute txtname
	 * 
	 * @param aID
	 * @return entity object representing the Report
	 * @throws Exception
	 */
	public XMLItemCollection getReport(String name) throws Exception;

	/**
	 * This method returns a collection of reports (Maps). The web service
	 * should return a subset of a collection if the start and count parameters
	 * differ form the value -1. The web service has to care that the
	 * CallerPrincipal has read access rights for each report to be returned.
	 * 
	 * 
	 * The method returns only workitems the call has sufficient read access
	 * for.
	 */
	public EntityCollection getReportList(int startpos, int count)
			throws Exception;

	/**
	 * Process a QueryEntity Object identified by the attribute txtname All
	 * informations about the Query are stored in the QueryObject these
	 * attributes are: txtQuery, numMaxCount, numStartPost, txtName
	 * 
	 * 
	 * @param aID
	 * @return
	 * @throws Exception
	 */
	public EntityCollection processQuery(String name) throws Exception;

}
