/*******************************************************************************
 *  Imixs IX Workflow Technology
 *  Copyright (C) 2001, 2008 Imixs Software Solutions GmbH,  
 *  http://www.imixs.com
 *  
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the terms of the GNU General Public License 
 *  as published by the Free Software Foundation; either version 2 
 *  of the License, or (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 *  General Public License for more details.
 *  
 *  You can receive a copy of the GNU General Public
 *  License at http://www.gnu.org/licenses/gpl.html
 *  
 *  Contributors:  
 *  	Imixs Software Solutions GmbH - initial API and implementation
 *  	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.xml;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * The XMLitemCollection is a basic serializable representation of a pojo to map
 * a org.imixs.workflow.ItemCollection into a xml representation using JAXB api
 * 
 * @author rsoika
 * @version 0.0.1
 */
@XmlRootElement(name="entity")
public class XMLItemCollection implements java.io.Serializable {
	private org.imixs.workflow.xml.XMLItem[] item;

	public XMLItemCollection() {
		this.setItem(new XMLItem[] {});
	}

	public org.imixs.workflow.xml.XMLItem[] getItem() {
		return item;
	}

	public void setItem(org.imixs.workflow.xml.XMLItem[] item) {
		this.item = item;
	}

}
