/*******************************************************************************
 *  Imixs IX Workflow Technology
 *  Copyright (C) 2001, 2008 Imixs Software Solutions GmbH,  
 *  http://www.imixs.com
 *  
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the terms of the GNU General Public License 
 *  as published by the Free Software Foundation; either version 2 
 *  of the License, or (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 *  General Public License for more details.
 *  
 *  You can receive a copy of the GNU General Public
 *  License at http://www.gnu.org/licenses/gpl.html
 *  
 *  Contributors:  
 *  	Imixs Software Solutions GmbH - initial API and implementation
 *  	Ralph Soika
 *******************************************************************************/
package org.imixs.workflow.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import org.imixs.workflow.ItemCollection;

/**
 * An XMLItemCollectionAdapter converts a
 * <code>org.imixs.workflow.xml.XMLItemCollection</code> into a
 * <code> org.imixs.workflow.ItemCollection</code> and reverse
 * 
 * @author imixs.com - Ralph Soika
 * @version 1.1
 * @see org.imixs.workflow.ItemCollection
 */

public class XMLItemCollectionAdapter {

	/**
	 * This Methode converts a <code>org.imixs.workflow.service.ItemArray</code>
	 * into a <code> org.imixs.workflow.ItemCollection</code> Returns null if
	 * ItemArray == null
	 * 
	 * @param ItemArray
	 * @return ItemCollection
	 */
	@SuppressWarnings("unchecked")
	public static ItemCollection getItemCollection(XMLItemCollection entity) {
		ItemCollection itemCol = new ItemCollection();
		if (entity == null)
			return itemCol;

		try {
			XMLItem items[] = entity.getItem();
			if (items != null)
				for (int i = 0; i < items.length; i++) {
					XMLItem it = items[i];
					if (it==null)
						continue;
					String key = it.getName();
					Object[] it_value=it.getValue();
					if (it_value==null) {
						// no value found
						itemCol.replaceItemValue(key, new Vector());
					}
					else {
						Vector myVector = new Vector(Arrays.asList(it.getValue()));
						itemCol.replaceItemValue(key, myVector);
					}
				}
		} catch (Exception e) {
			System.out.println("[XMLItemCollectionAdapter] getItemCollection error");
			System.out.println(e.toString());
			itemCol = null;
		}

		return itemCol;
	}

	/**
	 * This Method converts a <code> org.imixs.workflow.ItemCollection</code>
	 * into a <code>Entity</code>
	 * 
	 * <p>
	 * The method verifies if the values stored are basic java types. If not 
	 * these values will not be converted!
	 * 
	 * @param aItemCollection
	 *            Collection Object to be converted
	 * @param doc
	 *            lotus.domino.Document where the Items should be stored
	 */
	@SuppressWarnings("unchecked")
	public static XMLItemCollection putItemCollection(ItemCollection aItemCollection)
			throws Exception {
		String sName = null;
		XMLItemCollection entity = new XMLItemCollection();
		int i = 0;
		try {

			if (aItemCollection != null) {
				Iterator it = aItemCollection.getAllItems().entrySet()
						.iterator();
				int max = aItemCollection.getAllItems().entrySet().size();
				XMLItem[] items = new XMLItem[max];

				while (it.hasNext()) {
					Map.Entry entry = (Map.Entry) it.next();
					sName = (String) entry.getKey();

					// ItemValue ermitteln
					Vector vOrg = (Vector) entry.getValue();

					if (!isBasicType(vOrg))
						continue;
					XMLItem item = new XMLItem();
					item.setName(sName);
					item.setValue(vOrg.toArray());

					items[i] = item;
					i++;
				}
				entity.setItem(items);
			}

		} catch (Exception e) {
			System.out.println("[XMLItemCollectionAdapter] Error putItemCollection ("
					+ sName + ")");
			throw e;
		}

		return entity;
	}
	
	
	
	/**
	 * This method test if the values of an vector are basic types
	 * @return
	 */
	private static boolean isBasicType(Vector v) {
		
		for (Object o: v) {
			
			//Package p=o.getClass().getPackage();
			Class c=o.getClass();
			
			String name=c.getName();
			
			if (!name.startsWith("java.lang.")  && !"java.util.Date".equals(name)) {
			
				System.out.println("WARNING : XMLItemCollectionAdapter - unsported java type: "+name);
				return false ;
			}
			
		}
		
		
		return true;
		
	}
	
	
	/**
	 * This method transforms a Collection<ItemCollection> into a EntityCollection
	 * 
	 * @param col
	 * @return
	 * @throws Exception
	 */
	public static EntityCollection putCollection(
			Collection<ItemCollection> col) throws Exception {
		EntityCollection entiCol = new EntityCollection();
		Iterator<ItemCollection> it = col.iterator();
		int max = col.size();
		int i = 0;
		XMLItemCollection[] entities = new XMLItemCollection[max];
		while (it.hasNext()) {
			ItemCollection icw = (ItemCollection) it.next();
			XMLItemCollection entity = putItemCollection(icw);
			entities[i] = entity;
			i++;
		}
		if (max > 0)
			entiCol.setEntity(entities);
		return entiCol;
	}
}
