/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.webservices.rest;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.imixs.workflow.webservices.Base64;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;

public class RestClient {
    private String serviceEndpoint;
    private String sUser = null;
    private String sPassword = null;
    private String encoding = "UTF-8";
    private int iLastHTTPResult = 0;

    public void setCredentials(String auser, String apw) {
        this.sUser = auser;
        this.sPassword = apw;
    }

    public void setEncoding(String aEncoding) {
        this.encoding = aEncoding;
    }

    public int postEntity(String uri, XMLItemCollection aItemCol) throws Exception {
        PrintWriter printWriter = null;
        HttpURLConnection urlConnection = null;
        try {
            this.serviceEndpoint = uri;
            this.iLastHTTPResult = 500;
            urlConnection = (HttpURLConnection)new URL(this.serviceEndpoint).openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setAllowUserInteraction(false);
            if (this.sUser != null) {
                urlConnection.setRequestProperty("Authorization", "Basic " + this.getAccessByUser());
            }
            urlConnection.setRequestProperty("Content-Type", "application/xml; charset=" + this.encoding);
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLItemCollection.class});
            Marshaller m = context.createMarshaller();
            m.marshal((Object)aItemCol, (Writer)writer);
            urlConnection.setRequestProperty("Content-Length", "" + new Integer(writer.toString().getBytes().length));
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), this.encoding)));
            printWriter.write(writer.toString());
            printWriter.close();
            String sHTTPResponse = urlConnection.getHeaderField(0);
            try {
                this.iLastHTTPResult = Integer.parseInt(sHTTPResponse.substring(9, 12));
            }
            catch (Exception eNumber) {
                this.iLastHTTPResult = 500;
            }
        }
        catch (Exception ioe) {
            throw ioe;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return this.iLastHTTPResult;
    }

    public int postCollection(String uri, EntityCollection aEntityCol) throws Exception {
        PrintWriter printWriter = null;
        HttpURLConnection urlConnection = null;
        try {
            this.serviceEndpoint = uri;
            this.iLastHTTPResult = 500;
            urlConnection = (HttpURLConnection)new URL(this.serviceEndpoint).openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setAllowUserInteraction(false);
            if (this.sUser != null) {
                urlConnection.setRequestProperty("Authorization", "Basic " + this.getAccessByUser());
            }
            urlConnection.setRequestProperty("Content-Type", "application/xml; charset=" + this.encoding);
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EntityCollection.class});
            Marshaller m = context.createMarshaller();
            m.marshal((Object)aEntityCol, (Writer)writer);
            urlConnection.setRequestProperty("Content-Length", "" + new Integer(writer.toString().getBytes().length));
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), this.encoding)));
            printWriter.write(writer.toString());
            printWriter.close();
            String sHTTPResponse = urlConnection.getHeaderField(0);
            try {
                this.iLastHTTPResult = Integer.parseInt(sHTTPResponse.substring(9, 12));
            }
            catch (Exception eNumber) {
                this.iLastHTTPResult = 500;
            }
        }
        catch (Exception ioe) {
            throw ioe;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return this.iLastHTTPResult;
    }

    private String getAccessByUser() {
        String sURLAccess = "";
        String sUserCode = this.sUser + ":" + this.sPassword;
        char[] authcode = Base64.encode(sUserCode.getBytes());
        sURLAccess = String.valueOf(authcode);
        return sURLAccess;
    }
}

