/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.webservices.soap;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.imixs.workflow.webservices.Base64;

public class ServiceClient {
    public static final int SOAP11 = 11;
    public static final int SOAP12 = 12;
    private int iSoapType = 11;
    private String serviceEndpoint;
    private String sUser = null;
    private String sPassword = null;
    private String encoding = "UTF-8";
    private int iLastHTTPResult = 0;

    public ServiceClient(String aServiceEndpoint) {
        this.serviceEndpoint = aServiceEndpoint;
    }

    public void setCredentials(String auser, String apw) {
        this.sUser = auser;
        this.sPassword = apw;
    }

    public void setSoapType(int i) {
        this.iSoapType = i;
    }

    public void setEncoding(String aEncoding) {
        this.encoding = aEncoding;
    }

    public Object callSOAPAction(QName soapAction, Object requestEntity) throws Exception {
        PrintWriter printWriter = null;
        String sSoapAction = soapAction.getLocalPart();
        try {
            URLConnection urlConnection = new URL(this.serviceEndpoint).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setAllowUserInteraction(false);
            if (this.sUser != null) {
                urlConnection.setRequestProperty("Authorization", "Basic " + this.getAccessByUser());
            }
            urlConnection.setRequestProperty("Content-Type", "text/xml; charset=" + this.encoding);
            urlConnection.setRequestProperty("SOAPAction", "/" + sSoapAction);
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), this.encoding)));
            printWriter.close();
            String sHTTPResponse = urlConnection.getHeaderField(0);
            try {
                this.iLastHTTPResult = Integer.parseInt(sHTTPResponse.substring(9, 12));
            }
            catch (Exception eNumber) {
                this.iLastHTTPResult = 500;
            }
            InputStream is = urlConnection.getInputStream();
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(is);
        }
        catch (Exception ioe) {
            throw ioe;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return null;
    }

    public int getLastHTTPResult() {
        return this.iLastHTTPResult;
    }

    public Object getLastSOAPResponse() {
        return null;
    }

    private Object createSOAPEnvelope() {
        return null;
    }

    private String getAccessByUser() {
        String sURLAccess = "";
        String sUserCode = this.sUser + ":" + this.sPassword;
        char[] authcode = Base64.encode(sUserCode.getBytes());
        sURLAccess = String.valueOf(authcode);
        return sURLAccess;
    }
}

