/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedInteger;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generate.silly.SillyEntity;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyEntity
extends SillyEntity {
    private final int id;
    private final String val;
    private final ImmutableMap<String, Integer> payload;
    private final ImmutableList<Integer> ints;
    private final UnsignedInteger der;

    private static ImmutableSillyEntity checkPreconditions(ImmutableSillyEntity instance) {
        return instance;
    }

    private ImmutableSillyEntity(Builder builder) {
        this.id = builder.id;
        this.val = builder.val;
        this.payload = builder.payloadBuilder.build();
        this.ints = builder.intsBuilder.build();
        this.der = (UnsignedInteger)Preconditions.checkNotNull((Object)super.der());
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String val() {
        return this.val;
    }

    public ImmutableMap<String, Integer> payload() {
        return this.payload;
    }

    public ImmutableList<Integer> ints() {
        return this.ints;
    }

    @Override
    public UnsignedInteger der() {
        return this.der;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof ImmutableSillyEntity && this.equalTo((ImmutableSillyEntity)another);
    }

    private boolean equalTo(ImmutableSillyEntity another) {
        return this.id == another.id && this.val.equals(another.val) && this.payload.equals(another.payload) && this.ints.equals(another.ints) && this.der.equals((Object)another.der);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.id;
        h = h * 17 + this.val.hashCode();
        h = h * 17 + this.payload.hashCode();
        h = h * 17 + this.ints.hashCode();
        h = h * 17 + this.der.hashCode();
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyEntity").add("id", this.id).add("val", (Object)this.val).add("payload", this.payload).add("ints", this.ints).add("der", (Object)this.der).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build SillyEntity: required attribute '%s' is not set";
        private int id;
        private boolean idIsSet;
        @Nullable
        private String val;
        private ImmutableMap.Builder<String, Integer> payloadBuilder = ImmutableMap.builder();
        private ImmutableList.Builder<Integer> intsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder copy(SillyEntity fromInstance) {
            Preconditions.checkNotNull((Object)fromInstance);
            this.id(fromInstance.id());
            this.val(fromInstance.val());
            this.putAllPayload(fromInstance.payload());
            this.addAllInts(fromInstance.ints());
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            this.idIsSet = true;
            return this;
        }

        public Builder val(String val) {
            this.val = (String)Preconditions.checkNotNull((Object)val);
            return this;
        }

        public Builder putPayload(String key, int value) {
            this.payloadBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putPayload(Map.Entry<? extends String, ? extends Integer> entry) {
            this.payloadBuilder.put(entry);
            return this;
        }

        public Builder putAllPayload(Map<? extends String, ? extends Integer> payloadEntries) {
            this.payloadBuilder.putAll(payloadEntries);
            return this;
        }

        public Builder clearPayload() {
            this.payloadBuilder = ImmutableMap.builder();
            return this;
        }

        public Builder addInts(int intsElement) {
            this.intsBuilder.add((Object)intsElement);
            return this;
        }

        public Builder addAllInts(Iterable<? extends Integer> intsElements) {
            this.intsBuilder.addAll(intsElements);
            return this;
        }

        public Builder clearInts() {
            this.intsBuilder = ImmutableList.builder();
            return this;
        }

        public ImmutableSillyEntity build() {
            Preconditions.checkState((boolean)this.idIsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"id"});
            Preconditions.checkState((this.val != null ? 1 : 0) != 0, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"val"});
            return ImmutableSillyEntity.checkPreconditions(new ImmutableSillyEntity(this));
        }
    }
}

