/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generate.silly.SillyInterned;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyInterned
extends SillyInterned {
    private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();
    private final int arg1;
    private final int arg2;
    private final int hashCode;

    private static ImmutableSillyInterned intern(ImmutableSillyInterned instance) {
        return ((InternProxy)ImmutableSillyInterned.INTERNER.intern((Object)new InternProxy((ImmutableSillyInterned)instance))).instance;
    }

    public static ImmutableSillyInterned of(int arg1, int arg2) {
        return ImmutableSillyInterned.checkPreconditions(new ImmutableSillyInterned(arg1, arg2));
    }

    private static ImmutableSillyInterned checkPreconditions(ImmutableSillyInterned instance) {
        instance = ImmutableSillyInterned.intern(instance);
        return instance;
    }

    private ImmutableSillyInterned(int arg1, int arg2) {
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.hashCode = this.computeHashCode();
    }

    private ImmutableSillyInterned(Builder builder) {
        this.arg1 = builder.arg1;
        this.arg2 = builder.arg2;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public int arg1() {
        return this.arg1;
    }

    @Override
    public int arg2() {
        return this.arg2;
    }

    public boolean equals(Object another) {
        return this == another;
    }

    private boolean equalTo(ImmutableSillyInterned another) {
        return this.arg1 == another.arg1 && this.arg2 == another.arg2;
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.arg1;
        h = h * 17 + this.arg2;
        return h;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyInterned").add("arg1", this.arg1).add("arg2", this.arg2).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build SillyInterned: required attribute '%s' is not set";
        private int arg1;
        private boolean arg1IsSet;
        private int arg2;
        private boolean arg2IsSet;

        private Builder() {
        }

        public Builder copy(SillyInterned fromInstance) {
            Preconditions.checkNotNull((Object)fromInstance);
            this.arg1(fromInstance.arg1());
            this.arg2(fromInstance.arg2());
            return this;
        }

        public Builder arg1(int arg1) {
            this.arg1 = arg1;
            this.arg1IsSet = true;
            return this;
        }

        public Builder arg2(int arg2) {
            this.arg2 = arg2;
            this.arg2IsSet = true;
            return this;
        }

        public ImmutableSillyInterned build() {
            Preconditions.checkState((boolean)this.arg1IsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"arg1"});
            Preconditions.checkState((boolean)this.arg2IsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"arg2"});
            return ImmutableSillyInterned.checkPreconditions(new ImmutableSillyInterned(this));
        }
    }

    private static class InternProxy {
        final ImmutableSillyInterned instance;

        InternProxy(ImmutableSillyInterned instance) {
            this.instance = instance;
        }

        public boolean equals(Object another) {
            return this.instance.equalTo(((InternProxy)another).instance);
        }

        public int hashCode() {
            return this.instance.computeHashCode();
        }
    }
}

