/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generate.silly.SillyMapHolder;
import org.immutables.generate.silly.SillyMapTup;
import org.immutables.generate.silly.SillyValue;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyMapHolder
extends SillyMapHolder {
    private final ImmutableMap<SillyValue, Integer> holder1;
    private final ImmutableMap<Integer, String> holder2;
    private final ImmutableMap<String, SillyMapTup> holder3;
    private final ImmutableSet<RetentionPolicy> zz;

    public static ImmutableSillyMapHolder of(Map<SillyValue, Integer> holder1, Map<Integer, String> holder2) {
        return ImmutableSillyMapHolder.checkPreconditions(new ImmutableSillyMapHolder(holder1, holder2));
    }

    private static ImmutableSillyMapHolder checkPreconditions(ImmutableSillyMapHolder instance) {
        return instance;
    }

    private ImmutableSillyMapHolder(Map<SillyValue, Integer> holder1, Map<Integer, String> holder2) {
        this.holder1 = Maps.immutableEnumMap(holder1);
        this.holder2 = ImmutableMap.copyOf(holder2);
        this.holder3 = ImmutableMap.of();
        this.zz = ImmutableSet.of();
    }

    private ImmutableSillyMapHolder(Builder builder) {
        this.holder1 = Maps.immutableEnumMap((Map)builder.holder1Builder.build());
        this.holder2 = builder.holder2Builder.build();
        this.holder3 = builder.holder3Builder.build();
        this.zz = Sets.immutableEnumSet((Iterable)builder.zzBuilder.build());
    }

    public ImmutableMap<SillyValue, Integer> holder1() {
        return this.holder1;
    }

    public ImmutableMap<Integer, String> holder2() {
        return this.holder2;
    }

    public ImmutableMap<String, SillyMapTup> holder3() {
        return this.holder3;
    }

    public ImmutableSet<RetentionPolicy> zz() {
        return this.zz;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof ImmutableSillyMapHolder && this.equalTo((ImmutableSillyMapHolder)another);
    }

    private boolean equalTo(ImmutableSillyMapHolder another) {
        return this.holder1.equals(another.holder1) && this.holder2.equals(another.holder2) && this.holder3.equals(another.holder3) && this.zz.equals(another.zz);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.holder1.hashCode();
        h = h * 17 + this.holder2.hashCode();
        h = h * 17 + this.holder3.hashCode();
        h = h * 17 + this.zz.hashCode();
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyMapHolder").add("holder1", this.holder1).add("holder2", this.holder2).add("holder3", this.holder3).add("zz", this.zz).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build SillyMapHolder: required attribute '%s' is not set";
        private ImmutableMap.Builder<SillyValue, Integer> holder1Builder = ImmutableMap.builder();
        private ImmutableMap.Builder<Integer, String> holder2Builder = ImmutableMap.builder();
        private ImmutableMap.Builder<String, SillyMapTup> holder3Builder = ImmutableMap.builder();
        private ImmutableSet.Builder<RetentionPolicy> zzBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public Builder copy(SillyMapHolder fromInstance) {
            Preconditions.checkNotNull((Object)fromInstance);
            this.putAllHolder1(fromInstance.holder1());
            this.putAllHolder2(fromInstance.holder2());
            this.putAllHolder3(fromInstance.holder3());
            this.addAllZz(fromInstance.zz());
            return this;
        }

        public Builder putHolder1(SillyValue key, int value) {
            this.holder1Builder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putHolder1(Map.Entry<? extends SillyValue, ? extends Integer> entry) {
            this.holder1Builder.put(entry);
            return this;
        }

        public Builder putAllHolder1(Map<? extends SillyValue, ? extends Integer> holder1Entries) {
            this.holder1Builder.putAll(holder1Entries);
            return this;
        }

        public Builder clearHolder1() {
            this.holder1Builder = ImmutableMap.builder();
            return this;
        }

        public Builder putHolder2(int key, String value) {
            this.holder2Builder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putHolder2(Map.Entry<? extends Integer, ? extends String> entry) {
            this.holder2Builder.put(entry);
            return this;
        }

        public Builder putAllHolder2(Map<? extends Integer, ? extends String> holder2Entries) {
            this.holder2Builder.putAll(holder2Entries);
            return this;
        }

        public Builder clearHolder2() {
            this.holder2Builder = ImmutableMap.builder();
            return this;
        }

        public Builder putHolder3(String key, SillyMapTup value) {
            this.holder3Builder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putHolder3(Map.Entry<? extends String, ? extends SillyMapTup> entry) {
            this.holder3Builder.put(entry);
            return this;
        }

        public Builder putAllHolder3(Map<? extends String, ? extends SillyMapTup> holder3Entries) {
            this.holder3Builder.putAll(holder3Entries);
            return this;
        }

        public Builder clearHolder3() {
            this.holder3Builder = ImmutableMap.builder();
            return this;
        }

        public Builder addZz(RetentionPolicy zzElement) {
            this.zzBuilder.add((Object)zzElement);
            return this;
        }

        public Builder addAllZz(Iterable<? extends RetentionPolicy> zzElements) {
            this.zzBuilder.addAll(zzElements);
            return this;
        }

        public Builder clearZz() {
            this.zzBuilder = ImmutableSet.builder();
            return this;
        }

        public ImmutableSillyMapHolder build() {
            return ImmutableSillyMapHolder.checkPreconditions(new ImmutableSillyMapHolder(this));
        }
    }
}

