/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.common.collect.OrdinalDomain;
import org.immutables.common.collect.internal.InterningOrdinalDomain;
import org.immutables.generate.silly.SillyOrdinal;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyOrdinal
extends SillyOrdinal {
    private static final InterningOrdinalDomain<InternProxy, SillyOrdinal> DOMAIN = new InterningOrdinalDomain<InternProxy, SillyOrdinal>(){

        protected SillyOrdinal extractValue(InternProxy proxy, int ordinal) {
            return new ImmutableSillyOrdinal(proxy.instance, ordinal);
        }

        public String toString() {
            return "ImmutableSillyOrdinal.ordinalDomain()";
        }
    };
    private final String name;
    private final int ordinal;

    private ImmutableSillyOrdinal(ImmutableSillyOrdinal instance, int ordinal) {
        this.name = instance.name;
        this.ordinal = ordinal;
    }

    public static OrdinalDomain<SillyOrdinal> ordinalDomain() {
        return DOMAIN;
    }

    public OrdinalDomain<SillyOrdinal> domain() {
        return DOMAIN;
    }

    private static ImmutableSillyOrdinal intern(ImmutableSillyOrdinal instance) {
        return (ImmutableSillyOrdinal)DOMAIN.internOrdinal((Object)new InternProxy(instance));
    }

    public static ImmutableSillyOrdinal of(String name) {
        return ImmutableSillyOrdinal.checkPreconditions(new ImmutableSillyOrdinal(name));
    }

    private static ImmutableSillyOrdinal checkPreconditions(ImmutableSillyOrdinal instance) {
        instance = ImmutableSillyOrdinal.intern(instance);
        return instance;
    }

    private ImmutableSillyOrdinal(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.ordinal = 0;
    }

    @Override
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public boolean equals(Object another) {
        return this == another;
    }

    private boolean equalTo(ImmutableSillyOrdinal another) {
        return this.name.equals(another.name);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyOrdinal").add("name", (Object)this.name).toString();
    }

    private static class InternProxy {
        final ImmutableSillyOrdinal instance;

        InternProxy(ImmutableSillyOrdinal instance) {
            this.instance = instance;
        }

        public boolean equals(Object another) {
            return this.instance.equalTo(((InternProxy)another).instance);
        }

        public int hashCode() {
            return this.instance.computeHashCode();
        }
    }
}

