/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generate.silly.SillyAbstract;
import org.immutables.generate.silly.SillyPolyHost2;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyPolyHost2
extends SillyPolyHost2 {
    private final SillyAbstract s;
    private final Optional<SillyAbstract> o;

    private static ImmutableSillyPolyHost2 checkPreconditions(ImmutableSillyPolyHost2 instance) {
        return instance;
    }

    private ImmutableSillyPolyHost2(Builder builder) {
        this.s = builder.s;
        this.o = builder.o;
    }

    @Override
    public SillyAbstract s() {
        return this.s;
    }

    @Override
    public Optional<SillyAbstract> o() {
        return this.o;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof ImmutableSillyPolyHost2 && this.equalTo((ImmutableSillyPolyHost2)another);
    }

    private boolean equalTo(ImmutableSillyPolyHost2 another) {
        return this.s.equals(another.s) && this.o.equals(another.o);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.s.hashCode();
        h = h * 17 + this.o.hashCode();
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyPolyHost2").add("s", (Object)this.s).add("o", this.o).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build SillyPolyHost2: required attribute '%s' is not set";
        @Nullable
        private SillyAbstract s;
        private Optional<SillyAbstract> o = Optional.absent();

        private Builder() {
        }

        public Builder copy(SillyPolyHost2 fromInstance) {
            Preconditions.checkNotNull((Object)fromInstance);
            this.s(fromInstance.s());
            Optional<SillyAbstract> optionalO = fromInstance.o();
            if (optionalO.isPresent()) {
                this.o = optionalO;
            }
            return this;
        }

        public Builder s(SillyAbstract s) {
            this.s = (SillyAbstract)Preconditions.checkNotNull((Object)s);
            return this;
        }

        public Builder o(SillyAbstract o) {
            this.o((Optional<SillyAbstract>)Optional.of((Object)o));
            return this;
        }

        public Builder o(Optional<SillyAbstract> o) {
            this.o = (Optional)Preconditions.checkNotNull(o);
            return this;
        }

        public ImmutableSillyPolyHost2 build() {
            Preconditions.checkState((this.s != null ? 1 : 0) != 0, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"s"});
            return ImmutableSillyPolyHost2.checkPreconditions(new ImmutableSillyPolyHost2(this));
        }
    }
}

