/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generate.silly.SillyStructure;
import org.immutables.generate.silly.SillySubstructure;
import org.immutables.generate.silly.SillyTuplie;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyStructure
extends SillyStructure {
    private final String attr1;
    private final boolean flag2;
    private final Optional<Integer> opt3;
    private final long very4;
    private final double wet5;
    private final ImmutableList<SillySubstructure> subs6;
    private final SillySubstructure nest7;
    private final Optional<SillyTuplie> tup3;
    private final int int9;

    private static ImmutableSillyStructure checkPreconditions(ImmutableSillyStructure instance) {
        return instance;
    }

    private ImmutableSillyStructure(Builder builder) {
        this.attr1 = builder.attr1;
        this.flag2 = builder.flag2;
        this.opt3 = builder.opt3;
        this.very4 = builder.very4;
        this.wet5 = builder.wet5;
        this.subs6 = builder.subs6Builder.build();
        this.nest7 = builder.nest7;
        this.tup3 = builder.tup3;
        this.int9 = builder.int9;
    }

    @Override
    public String attr1() {
        return this.attr1;
    }

    @Override
    public boolean flag2() {
        return this.flag2;
    }

    @Override
    public Optional<Integer> opt3() {
        return this.opt3;
    }

    @Override
    public long very4() {
        return this.very4;
    }

    @Override
    public double wet5() {
        return this.wet5;
    }

    public ImmutableList<SillySubstructure> subs6() {
        return this.subs6;
    }

    @Override
    public SillySubstructure nest7() {
        return this.nest7;
    }

    @Override
    public Optional<SillyTuplie> tup3() {
        return this.tup3;
    }

    @Override
    public int int9() {
        return this.int9;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof ImmutableSillyStructure && this.equalTo((ImmutableSillyStructure)another);
    }

    private boolean equalTo(ImmutableSillyStructure another) {
        return this.attr1.equals(another.attr1) && this.flag2 == another.flag2 && this.opt3.equals(another.opt3) && this.very4 == another.very4 && this.wet5 == another.wet5 && this.subs6.equals(another.subs6) && this.nest7.equals(another.nest7) && this.tup3.equals(another.tup3) && this.int9 == another.int9;
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.attr1.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.flag2);
        h = h * 17 + this.opt3.hashCode();
        h = h * 17 + Longs.hashCode((long)this.very4);
        h = h * 17 + Doubles.hashCode((double)this.wet5);
        h = h * 17 + this.subs6.hashCode();
        h = h * 17 + this.nest7.hashCode();
        h = h * 17 + this.tup3.hashCode();
        h = h * 17 + this.int9;
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyStructure").add("attr1", (Object)this.attr1).add("flag2", this.flag2).add("opt3", this.opt3).add("very4", this.very4).add("wet5", this.wet5).add("subs6", this.subs6).add("nest7", (Object)this.nest7).add("tup3", this.tup3).add("int9", this.int9).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build SillyStructure: required attribute '%s' is not set";
        @Nullable
        private String attr1;
        private boolean flag2;
        private boolean flag2IsSet;
        private Optional<Integer> opt3 = Optional.absent();
        private long very4;
        private boolean very4IsSet;
        private double wet5;
        private boolean wet5IsSet;
        private ImmutableList.Builder<SillySubstructure> subs6Builder = ImmutableList.builder();
        @Nullable
        private SillySubstructure nest7;
        private Optional<SillyTuplie> tup3 = Optional.absent();
        private int int9;
        private boolean int9IsSet;

        private Builder() {
        }

        public Builder copy(SillyStructure fromInstance) {
            Preconditions.checkNotNull((Object)fromInstance);
            this.attr1(fromInstance.attr1());
            this.flag2(fromInstance.flag2());
            Optional<Integer> optionalOpt3 = fromInstance.opt3();
            if (optionalOpt3.isPresent()) {
                this.opt3 = optionalOpt3;
            }
            this.very4(fromInstance.very4());
            this.wet5(fromInstance.wet5());
            this.addAllSubs6(fromInstance.subs6());
            this.nest7(fromInstance.nest7());
            Optional<SillyTuplie> optionalTup3 = fromInstance.tup3();
            if (optionalTup3.isPresent()) {
                this.tup3 = optionalTup3;
            }
            this.int9(fromInstance.int9());
            return this;
        }

        public Builder attr1(String attr1) {
            this.attr1 = (String)Preconditions.checkNotNull((Object)attr1);
            return this;
        }

        public Builder flag2(boolean flag2) {
            this.flag2 = flag2;
            this.flag2IsSet = true;
            return this;
        }

        public Builder opt3(int opt3) {
            this.opt3((Optional<Integer>)Optional.of((Object)opt3));
            return this;
        }

        public Builder opt3(Optional<Integer> opt3) {
            this.opt3 = (Optional)Preconditions.checkNotNull(opt3);
            return this;
        }

        public Builder very4(long very4) {
            this.very4 = very4;
            this.very4IsSet = true;
            return this;
        }

        public Builder wet5(double wet5) {
            this.wet5 = wet5;
            this.wet5IsSet = true;
            return this;
        }

        public Builder addSubs6(SillySubstructure subs6Element) {
            this.subs6Builder.add((Object)subs6Element);
            return this;
        }

        public Builder addAllSubs6(Iterable<? extends SillySubstructure> subs6Elements) {
            this.subs6Builder.addAll(subs6Elements);
            return this;
        }

        public Builder clearSubs6() {
            this.subs6Builder = ImmutableList.builder();
            return this;
        }

        public Builder nest7(SillySubstructure nest7) {
            this.nest7 = (SillySubstructure)Preconditions.checkNotNull((Object)nest7);
            return this;
        }

        public Builder tup3(SillyTuplie tup3) {
            this.tup3((Optional<SillyTuplie>)Optional.of((Object)tup3));
            return this;
        }

        public Builder tup3(Optional<SillyTuplie> tup3) {
            this.tup3 = (Optional)Preconditions.checkNotNull(tup3);
            return this;
        }

        public Builder int9(int int9) {
            this.int9 = int9;
            this.int9IsSet = true;
            return this;
        }

        public ImmutableSillyStructure build() {
            Preconditions.checkState((this.attr1 != null ? 1 : 0) != 0, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"attr1"});
            Preconditions.checkState((boolean)this.flag2IsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"flag2"});
            Preconditions.checkState((boolean)this.very4IsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"very4"});
            Preconditions.checkState((boolean)this.wet5IsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"wet5"});
            Preconditions.checkState((this.nest7 != null ? 1 : 0) != 0, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"nest7"});
            Preconditions.checkState((boolean)this.int9IsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"int9"});
            return ImmutableSillyStructure.checkPreconditions(new ImmutableSillyStructure(this));
        }
    }
}

