/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generate.silly.SillyValidatedBuiltValue;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyValidatedBuiltValue
extends SillyValidatedBuiltValue {
    private final int value;
    private final boolean negativeOnly;

    private static ImmutableSillyValidatedBuiltValue checkPreconditions(ImmutableSillyValidatedBuiltValue instance) {
        instance.validate();
        return instance;
    }

    private ImmutableSillyValidatedBuiltValue(Builder builder) {
        this.value = builder.value;
        this.negativeOnly = builder.negativeOnly;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public boolean negativeOnly() {
        return this.negativeOnly;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof ImmutableSillyValidatedBuiltValue && this.equalTo((ImmutableSillyValidatedBuiltValue)another);
    }

    private boolean equalTo(ImmutableSillyValidatedBuiltValue another) {
        return this.value == another.value && this.negativeOnly == another.negativeOnly;
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.value;
        h = h * 17 + Booleans.hashCode((boolean)this.negativeOnly);
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyValidatedBuiltValue").add("value", this.value).add("negativeOnly", this.negativeOnly).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build SillyValidatedBuiltValue: required attribute '%s' is not set";
        private int value;
        private boolean valueIsSet;
        private boolean negativeOnly;
        private boolean negativeOnlyIsSet;

        private Builder() {
        }

        public Builder copy(SillyValidatedBuiltValue fromInstance) {
            Preconditions.checkNotNull((Object)fromInstance);
            this.value(fromInstance.value());
            this.negativeOnly(fromInstance.negativeOnly());
            return this;
        }

        public Builder value(int value) {
            this.value = value;
            this.valueIsSet = true;
            return this;
        }

        public Builder negativeOnly(boolean negativeOnly) {
            this.negativeOnly = negativeOnly;
            this.negativeOnlyIsSet = true;
            return this;
        }

        public ImmutableSillyValidatedBuiltValue build() {
            Preconditions.checkState((boolean)this.valueIsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"value"});
            Preconditions.checkState((boolean)this.negativeOnlyIsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"negativeOnly"});
            return ImmutableSillyValidatedBuiltValue.checkPreconditions(new ImmutableSillyValidatedBuiltValue(this));
        }
    }
}

