/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.google.common.base.Objects;
import com.google.common.primitives.Booleans;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.generate.silly.SillyValidatedConstructedValue;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyValidatedConstructedValue
extends SillyValidatedConstructedValue {
    private final int value;
    private final boolean negativeOnly;

    public static ImmutableSillyValidatedConstructedValue of(int value, boolean negativeOnly) {
        return ImmutableSillyValidatedConstructedValue.checkPreconditions(new ImmutableSillyValidatedConstructedValue(value, negativeOnly));
    }

    private static ImmutableSillyValidatedConstructedValue checkPreconditions(ImmutableSillyValidatedConstructedValue instance) {
        instance.validate();
        return instance;
    }

    private ImmutableSillyValidatedConstructedValue(int value, boolean negativeOnly) {
        this.value = value;
        this.negativeOnly = negativeOnly;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public boolean negativeOnly() {
        return this.negativeOnly;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof ImmutableSillyValidatedConstructedValue && this.equalTo((ImmutableSillyValidatedConstructedValue)another);
    }

    private boolean equalTo(ImmutableSillyValidatedConstructedValue another) {
        return this.value == another.value && this.negativeOnly == another.negativeOnly;
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.value;
        h = h * 17 + Booleans.hashCode((boolean)this.negativeOnly);
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyValidatedConstructedValue").add("value", this.value).add("negativeOnly", this.negativeOnly).toString();
    }
}

