/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillyDumb;
import org.immutables.generate.silly.SillyDumb;

@ParametersAreNonnullByDefault
final class InternalSillyDumbMarshaling {
    private InternalSillyDumbMarshaling() {
    }

    static void marshalIterableOfSillyDumb(JsonGenerator generator, Iterable<SillyDumb> iterable) throws IOException {
        generator.writeStartArray();
        for (SillyDumb instance : iterable) {
            InternalSillyDumbMarshaling.marshalSillyDumb(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillyDumb(JsonGenerator generator, SillyDumb instance) throws IOException {
        List<String> d4Collection;
        generator.writeStartObject();
        Optional<Integer> a1Value = instance.a1();
        if (a1Value.isPresent()) {
            generator.writeFieldName("a");
            int unwrappeda1Value = (Integer)a1Value.get();
            BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)unwrappeda1Value);
        } else {
            generator.writeNullField("a");
        }
        List<String> b2Collection = instance.b2();
        if (!b2Collection.isEmpty()) {
            generator.writeArrayFieldStart("b");
            for (String e : b2Collection) {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Object)e);
            }
            generator.writeEndArray();
        } else {
            generator.writeArrayFieldStart("b");
            generator.writeEndArray();
        }
        Optional<Integer> c3Value = instance.c3();
        if (c3Value.isPresent()) {
            generator.writeFieldName("c");
            int unwrappedc3Value = (Integer)c3Value.get();
            BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)unwrappedc3Value);
        }
        if (!(d4Collection = instance.d4()).isEmpty()) {
            generator.writeArrayFieldStart("d");
            for (String e : d4Collection) {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Object)e);
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillyDumb", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillyDumb> unmarshalIterableOfSillyDumb(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyDumbMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillyDumbMarshaling.unmarshalSillyDumb(parser));
            }
        } else {
            InternalSillyDumbMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillyDumb>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillyDumbMarshaling.unmarshalSillyDumb(parser));
            }
        }
        return result;
    }

    static SillyDumb unmarshalSillyDumb(JsonParser parser) throws IOException {
        ImmutableSillyDumb.Builder builder = ImmutableSillyDumb.builder();
        String attributeName = "";
        try {
            JsonToken t = parser.getCurrentToken();
            InternalSillyDumbMarshaling.ensure(t == JsonToken.START_OBJECT, "new {", "", t);
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyDumbMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                attributeName = parser.getText();
                InternalSillyDumbMarshaling.unmarshalAttribute(parser, builder, attributeName);
            }
        }
        catch (JsonParseException jsonParse) {
            InternalSillyDumbMarshaling.ensure(false, attributeName, "?", jsonParse.getMessage());
        }
        return builder.build();
    }

    private static void unmarshalAttribute(JsonParser parser, ImmutableSillyDumb.Builder builder, String attributeName) throws IOException {
        switch (attributeName) {
            case "a": {
                InternalSillyDumbMarshaling.unmarshalAttributeA1(parser, builder);
                break;
            }
            case "b": {
                InternalSillyDumbMarshaling.unmarshalAttributeB2(parser, builder);
                break;
            }
            case "c": {
                InternalSillyDumbMarshaling.unmarshalAttributeC3(parser, builder);
                break;
            }
            case "d": {
                InternalSillyDumbMarshaling.unmarshalAttributeD4(parser, builder);
                break;
            }
            default: {
                InternalSillyDumbMarshaling.unmarshalUnknownAttribute(parser, attributeName);
            }
        }
    }

    private static void unmarshalUnknownAttribute(JsonParser parser, String attributeName) throws IOException {
        JsonToken t = parser.nextToken();
        if (!t.isScalarValue()) {
            parser.skipChildren();
        }
    }

    private static void unmarshalAttributeA1(JsonParser parser, ImmutableSillyDumb.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t != JsonToken.VALUE_NULL) {
            InternalSillyDumbMarshaling.ensure(t.isScalarValue(), "a1", "Optional<Integer>", t);
            builder.a1(parser.getIntValue());
        }
    }

    private static void unmarshalAttributeB2(JsonParser parser, ImmutableSillyDumb.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                String value = BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (String)null, String.class);
                builder.addB2(value);
            }
        } else if (t != JsonToken.VALUE_NULL) {
            String value = BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (String)null, String.class);
            builder.addB2(value);
        }
    }

    private static void unmarshalAttributeC3(JsonParser parser, ImmutableSillyDumb.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t != JsonToken.VALUE_NULL) {
            InternalSillyDumbMarshaling.ensure(t.isScalarValue(), "c3", "Optional<Integer>", t);
            builder.c3(parser.getIntValue());
        }
    }

    private static void unmarshalAttributeD4(JsonParser parser, ImmutableSillyDumb.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                String value = BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (String)null, String.class);
                builder.addD4(value);
            }
        } else if (t != JsonToken.VALUE_NULL) {
            String value = BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (String)null, String.class);
            builder.addD4(value);
        }
    }
}

