/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillyEntity;
import org.immutables.generate.silly.SillyEntity;

@ParametersAreNonnullByDefault
final class InternalSillyEntityMarshaling {
    private InternalSillyEntityMarshaling() {
    }

    static void marshalIterableOfSillyEntity(JsonGenerator generator, Iterable<SillyEntity> iterable) throws IOException {
        generator.writeStartArray();
        for (SillyEntity instance : iterable) {
            InternalSillyEntityMarshaling.marshalSillyEntity(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillyEntity(JsonGenerator generator, SillyEntity instance) throws IOException {
        List<Integer> intsCollection;
        generator.writeStartObject();
        generator.writeFieldName("_id");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)instance.id());
        generator.writeFieldName("v");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Object)instance.val());
        Map<String, Integer> payloadMap = instance.payload();
        if (!payloadMap.isEmpty()) {
            generator.writeObjectFieldStart("p");
            for (Map.Entry<String, Integer> e : payloadMap.entrySet()) {
                generator.writeFieldName(BuiltinMarshalingRoutines.marshalKey((Object)e.getKey()));
                int value = e.getValue();
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)value);
            }
            generator.writeEndObject();
        }
        if (!(intsCollection = instance.ints()).isEmpty()) {
            generator.writeArrayFieldStart("i");
            for (int e : intsCollection) {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)e);
            }
            generator.writeEndArray();
        }
        generator.writeFieldName("der");
        SillyEntity.marshal(generator, instance.der());
        generator.writeEndObject();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillyEntity", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillyEntity> unmarshalIterableOfSillyEntity(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyEntityMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillyEntityMarshaling.unmarshalSillyEntity(parser));
            }
        } else {
            InternalSillyEntityMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillyEntity>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillyEntityMarshaling.unmarshalSillyEntity(parser));
            }
        }
        return result;
    }

    static SillyEntity unmarshalSillyEntity(JsonParser parser) throws IOException {
        ImmutableSillyEntity.Builder builder = ImmutableSillyEntity.builder();
        String attributeName = "";
        try {
            JsonToken t = parser.getCurrentToken();
            InternalSillyEntityMarshaling.ensure(t == JsonToken.START_OBJECT, "new {", "", t);
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyEntityMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                attributeName = parser.getText();
                InternalSillyEntityMarshaling.unmarshalAttribute(parser, builder, attributeName);
            }
        }
        catch (JsonParseException jsonParse) {
            InternalSillyEntityMarshaling.ensure(false, attributeName, "?", jsonParse.getMessage());
        }
        return builder.build();
    }

    private static void unmarshalAttribute(JsonParser parser, ImmutableSillyEntity.Builder builder, String attributeName) throws IOException {
        switch (attributeName) {
            case "_id": {
                InternalSillyEntityMarshaling.unmarshalAttributeId(parser, builder);
                break;
            }
            case "v": {
                InternalSillyEntityMarshaling.unmarshalAttributeVal(parser, builder);
                break;
            }
            case "p": {
                InternalSillyEntityMarshaling.unmarshalAttributePayload(parser, builder);
                break;
            }
            case "i": {
                InternalSillyEntityMarshaling.unmarshalAttributeInts(parser, builder);
                break;
            }
            default: {
                InternalSillyEntityMarshaling.unmarshalUnknownAttribute(parser, attributeName);
            }
        }
    }

    private static void unmarshalUnknownAttribute(JsonParser parser, String attributeName) throws IOException {
        JsonToken t = parser.nextToken();
        if (!t.isScalarValue()) {
            parser.skipChildren();
        }
    }

    private static void unmarshalAttributeId(JsonParser parser, ImmutableSillyEntity.Builder builder) throws IOException {
        InternalSillyEntityMarshaling.ensure(parser.nextToken().isScalarValue(), "id", "int", parser.getCurrentToken());
        builder.id(parser.getIntValue());
    }

    private static void unmarshalAttributeVal(JsonParser parser, ImmutableSillyEntity.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        String value = BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (String)null, String.class);
        builder.val(value);
    }

    private static void unmarshalAttributePayload(JsonParser parser, ImmutableSillyEntity.Builder builder) throws IOException {
        parser.nextToken();
        builder.putAllPayload(InternalSillyEntityMarshaling.unmarshalMapPayload(parser));
    }

    private static Map<String, Integer> unmarshalMapPayload(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return ImmutableMap.of();
        }
        InternalSillyEntityMarshaling.ensure(t == JsonToken.START_OBJECT, "payload", "Map<String, Integer>", t);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
            InternalSillyEntityMarshaling.ensure(t == JsonToken.FIELD_NAME, "payload[*]", "Map<String, Integer>", t);
            String key = parser.getText();
            t = parser.nextToken();
            InternalSillyEntityMarshaling.ensure(t.isScalarValue(), "payload", "Map<String, Integer>", t);
            int value = parser.getIntValue();
            builder.put((Object)key, (Object)value);
        }
        return builder.build();
    }

    private static void unmarshalAttributeInts(JsonParser parser, ImmutableSillyEntity.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                InternalSillyEntityMarshaling.ensure(t.isScalarValue(), "ints", "List<Integer>", t);
                builder.addInts(parser.getIntValue());
            }
        } else if (t != JsonToken.VALUE_NULL) {
            InternalSillyEntityMarshaling.ensure(t.isScalarValue(), "ints", "List<Integer>", t);
            builder.addInts(parser.getIntValue());
        }
    }
}

