/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillyMapHolder;
import org.immutables.generate.silly.SillyMapHolder;
import org.immutables.generate.silly.SillyMapTup;
import org.immutables.generate.silly.SillyMapTupMarshaler;
import org.immutables.generate.silly.SillyMarshalingRoutines;
import org.immutables.generate.silly.SillyValue;

@ParametersAreNonnullByDefault
final class InternalSillyMapHolderMarshaling {
    private InternalSillyMapHolderMarshaling() {
    }

    static void marshalIterableOfSillyMapHolder(JsonGenerator generator, Iterable<SillyMapHolder> iterable) throws IOException {
        generator.writeStartArray();
        for (SillyMapHolder instance : iterable) {
            InternalSillyMapHolderMarshaling.marshalSillyMapHolder(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillyMapHolder(JsonGenerator generator, SillyMapHolder instance) throws IOException {
        Set<RetentionPolicy> zzCollection;
        Map<String, SillyMapTup> holder3Map;
        generator.writeStartObject();
        Map<SillyValue, Integer> holder1Map = instance.holder1();
        if (!holder1Map.isEmpty()) {
            generator.writeObjectFieldStart("holder1");
            for (Map.Entry<SillyValue, Integer> e : holder1Map.entrySet()) {
                generator.writeFieldName(BuiltinMarshalingRoutines.marshalKey((Object)((Object)e.getKey())));
                int value = e.getValue();
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)value);
            }
            generator.writeEndObject();
        } else {
            generator.writeObjectFieldStart("holder1");
            generator.writeEndObject();
        }
        Map<Integer, String> holder2Map = instance.holder2();
        if (!holder2Map.isEmpty()) {
            generator.writeObjectFieldStart("holder2");
            for (Map.Entry<Integer, String> e : holder2Map.entrySet()) {
                generator.writeFieldName(BuiltinMarshalingRoutines.marshalKey((Object)e.getKey()));
                String value = e.getValue();
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Object)value);
            }
            generator.writeEndObject();
        }
        if (!(holder3Map = instance.holder3()).isEmpty()) {
            generator.writeObjectFieldStart("holder3");
            for (Map.Entry<String, SillyMapTup> e : holder3Map.entrySet()) {
                generator.writeFieldName(BuiltinMarshalingRoutines.marshalKey((Object)e.getKey()));
                SillyMapTup value = e.getValue();
                SillyMapTupMarshaler.marshal(generator, value);
            }
            generator.writeEndObject();
        }
        if (!(zzCollection = instance.zz()).isEmpty()) {
            generator.writeArrayFieldStart("zz");
            for (RetentionPolicy e : zzCollection) {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Enum)e);
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillyMapHolder", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillyMapHolder> unmarshalIterableOfSillyMapHolder(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyMapHolderMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillyMapHolderMarshaling.unmarshalSillyMapHolder(parser));
            }
        } else {
            InternalSillyMapHolderMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillyMapHolder>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillyMapHolderMarshaling.unmarshalSillyMapHolder(parser));
            }
        }
        return result;
    }

    static SillyMapHolder unmarshalSillyMapHolder(JsonParser parser) throws IOException {
        ImmutableSillyMapHolder.Builder builder = ImmutableSillyMapHolder.builder();
        String attributeName = "";
        try {
            JsonToken t = parser.getCurrentToken();
            InternalSillyMapHolderMarshaling.ensure(t == JsonToken.START_OBJECT, "new {", "", t);
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyMapHolderMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                attributeName = parser.getText();
                InternalSillyMapHolderMarshaling.unmarshalAttribute(parser, builder, attributeName);
            }
        }
        catch (JsonParseException jsonParse) {
            InternalSillyMapHolderMarshaling.ensure(false, attributeName, "?", jsonParse.getMessage());
        }
        return builder.build();
    }

    private static void unmarshalAttribute(JsonParser parser, ImmutableSillyMapHolder.Builder builder, String attributeName) throws IOException {
        switch (attributeName) {
            case "holder1": {
                InternalSillyMapHolderMarshaling.unmarshalAttributeHolder1(parser, builder);
                break;
            }
            case "holder2": {
                InternalSillyMapHolderMarshaling.unmarshalAttributeHolder2(parser, builder);
                break;
            }
            case "holder3": {
                InternalSillyMapHolderMarshaling.unmarshalAttributeHolder3(parser, builder);
                break;
            }
            case "zz": {
                InternalSillyMapHolderMarshaling.unmarshalAttributeZz(parser, builder);
                break;
            }
            default: {
                InternalSillyMapHolderMarshaling.unmarshalUnknownAttribute(parser, attributeName);
            }
        }
    }

    private static void unmarshalUnknownAttribute(JsonParser parser, String attributeName) throws IOException {
        JsonToken t = parser.nextToken();
        if (!t.isScalarValue()) {
            parser.skipChildren();
        }
    }

    private static void unmarshalAttributeHolder1(JsonParser parser, ImmutableSillyMapHolder.Builder builder) throws IOException {
        parser.nextToken();
        builder.putAllHolder1(InternalSillyMapHolderMarshaling.unmarshalMapHolder1(parser));
    }

    private static Map<SillyValue, Integer> unmarshalMapHolder1(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return ImmutableMap.of();
        }
        InternalSillyMapHolderMarshaling.ensure(t == JsonToken.START_OBJECT, "holder1", "Map<SillyValue, Integer>", t);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
            InternalSillyMapHolderMarshaling.ensure(t == JsonToken.FIELD_NAME, "holder1[*]", "Map<SillyValue, Integer>", t);
            SillyValue key = SillyMarshalingRoutines.unmarshal(parser, null, SillyValue.class);
            t = parser.nextToken();
            InternalSillyMapHolderMarshaling.ensure(t.isScalarValue(), "holder1", "Map<SillyValue, Integer>", t);
            int value = parser.getIntValue();
            builder.put((Object)key, (Object)value);
        }
        return builder.build();
    }

    private static void unmarshalAttributeHolder2(JsonParser parser, ImmutableSillyMapHolder.Builder builder) throws IOException {
        parser.nextToken();
        builder.putAllHolder2(InternalSillyMapHolderMarshaling.unmarshalMapHolder2(parser));
    }

    private static Map<Integer, String> unmarshalMapHolder2(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return ImmutableMap.of();
        }
        InternalSillyMapHolderMarshaling.ensure(t == JsonToken.START_OBJECT, "holder2", "Map<Integer, String>", t);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
            InternalSillyMapHolderMarshaling.ensure(t == JsonToken.FIELD_NAME, "holder2[*]", "Map<Integer, String>", t);
            int key = Integer.parseInt(parser.getText());
            t = parser.nextToken();
            String value = parser.getText();
            builder.put((Object)key, (Object)value);
        }
        return builder.build();
    }

    private static void unmarshalAttributeHolder3(JsonParser parser, ImmutableSillyMapHolder.Builder builder) throws IOException {
        parser.nextToken();
        builder.putAllHolder3(InternalSillyMapHolderMarshaling.unmarshalMapHolder3(parser));
    }

    private static Map<String, SillyMapTup> unmarshalMapHolder3(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return ImmutableMap.of();
        }
        InternalSillyMapHolderMarshaling.ensure(t == JsonToken.START_OBJECT, "holder3", "Map<String, SillyMapTup>", t);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
            InternalSillyMapHolderMarshaling.ensure(t == JsonToken.FIELD_NAME, "holder3[*]", "Map<String, SillyMapTup>", t);
            String key = parser.getText();
            t = parser.nextToken();
            SillyMapTup value = SillyMapTupMarshaler.unmarshal(parser, null, SillyMapTup.class);
            builder.put((Object)key, (Object)value);
        }
        return builder.build();
    }

    private static void unmarshalAttributeZz(JsonParser parser, ImmutableSillyMapHolder.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                RetentionPolicy value = (RetentionPolicy)BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (Enum)null, RetentionPolicy.class);
                builder.addZz(value);
            }
        } else if (t != JsonToken.VALUE_NULL) {
            RetentionPolicy value = (RetentionPolicy)BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (Enum)null, RetentionPolicy.class);
            builder.addZz(value);
        }
    }
}

