/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillyMapTup;
import org.immutables.generate.silly.SillyMapTup;

@ParametersAreNonnullByDefault
final class InternalSillyMapTupMarshaling {
    private InternalSillyMapTupMarshaling() {
    }

    static void marshalIterableOfSillyMapTup(JsonGenerator generator, Iterable<SillyMapTup> iterable) throws IOException {
        generator.writeStartArray();
        for (SillyMapTup instance : iterable) {
            InternalSillyMapTupMarshaling.marshalSillyMapTup(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillyMapTup(JsonGenerator generator, SillyMapTup instance) throws IOException {
        generator.writeStartArray();
        Map<RetentionPolicy, Integer> holder1Map = instance.holder1();
        generator.writeStartObject();
        for (Map.Entry<RetentionPolicy, Integer> e : holder1Map.entrySet()) {
            generator.writeFieldName(BuiltinMarshalingRoutines.marshalKey((Object)((Object)e.getKey())));
            int value = e.getValue();
            BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)value);
        }
        generator.writeEndObject();
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)instance.value());
        generator.writeEndArray();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillyMapTup", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillyMapTup> unmarshalIterableOfSillyMapTup(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyMapTupMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillyMapTupMarshaling.unmarshalSillyMapTup(parser));
            }
        } else {
            InternalSillyMapTupMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillyMapTup>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillyMapTupMarshaling.unmarshalSillyMapTup(parser));
            }
        }
        return result;
    }

    private static JsonParser nextTokenAdvance(JsonParser parser) throws IOException {
        parser.nextToken();
        return parser;
    }

    static SillyMapTup unmarshalSillyMapTup(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        InternalSillyMapTupMarshaling.ensure(t == JsonToken.START_ARRAY, "of [", "", t);
        ImmutableSillyMapTup instance = ImmutableSillyMapTup.of(InternalSillyMapTupMarshaling.unmarshalConstructorArgumentHolder1(InternalSillyMapTupMarshaling.nextTokenAdvance(parser)), InternalSillyMapTupMarshaling.unmarshalConstructorArgumentValue(InternalSillyMapTupMarshaling.nextTokenAdvance(parser)));
        InternalSillyMapTupMarshaling.ensure(parser.nextToken() == JsonToken.END_ARRAY, "]", "", parser.getCurrentToken());
        return instance;
    }

    private static Map<RetentionPolicy, Integer> unmarshalConstructorArgumentHolder1(JsonParser parser) throws IOException {
        return InternalSillyMapTupMarshaling.unmarshalMapHolder1(parser);
    }

    private static Map<RetentionPolicy, Integer> unmarshalMapHolder1(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return ImmutableMap.of();
        }
        InternalSillyMapTupMarshaling.ensure(t == JsonToken.START_OBJECT, "holder1", "Map<RetentionPolicy, Integer>", t);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
            InternalSillyMapTupMarshaling.ensure(t == JsonToken.FIELD_NAME, "holder1[*]", "Map<RetentionPolicy, Integer>", t);
            RetentionPolicy key = (RetentionPolicy)BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (Enum)null, RetentionPolicy.class);
            t = parser.nextToken();
            InternalSillyMapTupMarshaling.ensure(t.isScalarValue(), "holder1", "Map<RetentionPolicy, Integer>", t);
            int value = parser.getIntValue();
            builder.put((Object)key, (Object)value);
        }
        return builder.build();
    }

    private static int unmarshalConstructorArgumentValue(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        InternalSillyMapTupMarshaling.ensure(t.isScalarValue(), "value", "int", t);
        return parser.getIntValue();
    }
}

