/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.Marshaler;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillyPolyHost;
import org.immutables.generate.silly.SillyAbstract;
import org.immutables.generate.silly.SillyPolyHost;
import org.immutables.generate.silly.SillySub1Marshaler;
import org.immutables.generate.silly.SillySub2Marshaler;

@ParametersAreNonnullByDefault
final class InternalSillyPolyHostMarshaling {
    private InternalSillyPolyHostMarshaling() {
    }

    static void marshalIterableOfSillyPolyHost(JsonGenerator generator, Iterable<SillyPolyHost> iterable) throws IOException {
        generator.writeStartArray();
        for (SillyPolyHost instance : iterable) {
            InternalSillyPolyHostMarshaling.marshalSillyPolyHost(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillyPolyHost(JsonGenerator generator, SillyPolyHost instance) throws IOException {
        generator.writeStartObject();
        List<SillyAbstract> sCollection = instance.s();
        if (!sCollection.isEmpty()) {
            generator.writeArrayFieldStart("s");
            for (SillyAbstract e : sCollection) {
                MarshalingSupport.marshalWithOneOfMarshalers((JsonGenerator)generator, (Object)e, (Marshaler[])new Marshaler[]{SillySub1Marshaler.instance(), SillySub2Marshaler.instance()});
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillyPolyHost", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillyPolyHost> unmarshalIterableOfSillyPolyHost(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyPolyHostMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillyPolyHostMarshaling.unmarshalSillyPolyHost(parser));
            }
        } else {
            InternalSillyPolyHostMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillyPolyHost>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillyPolyHostMarshaling.unmarshalSillyPolyHost(parser));
            }
        }
        return result;
    }

    static SillyPolyHost unmarshalSillyPolyHost(JsonParser parser) throws IOException {
        ImmutableSillyPolyHost.Builder builder = ImmutableSillyPolyHost.builder();
        String attributeName = "";
        try {
            JsonToken t = parser.getCurrentToken();
            InternalSillyPolyHostMarshaling.ensure(t == JsonToken.START_OBJECT, "new {", "", t);
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyPolyHostMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                attributeName = parser.getText();
                InternalSillyPolyHostMarshaling.unmarshalAttribute(parser, builder, attributeName);
            }
        }
        catch (JsonParseException jsonParse) {
            InternalSillyPolyHostMarshaling.ensure(false, attributeName, "?", jsonParse.getMessage());
        }
        return builder.build();
    }

    private static void unmarshalAttribute(JsonParser parser, ImmutableSillyPolyHost.Builder builder, String attributeName) throws IOException {
        switch (attributeName) {
            case "s": {
                InternalSillyPolyHostMarshaling.unmarshalAttributeS(parser, builder);
                break;
            }
            default: {
                InternalSillyPolyHostMarshaling.unmarshalUnknownAttribute(parser, attributeName);
            }
        }
    }

    private static void unmarshalUnknownAttribute(JsonParser parser, String attributeName) throws IOException {
        JsonToken t = parser.nextToken();
        if (!t.isScalarValue()) {
            parser.skipChildren();
        }
    }

    private static void unmarshalAttributeS(JsonParser parser, ImmutableSillyPolyHost.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                SillyAbstract value = (SillyAbstract)MarshalingSupport.unmarshalWithOneOfMarshalers((JsonParser)parser, (String)"SillyPolyHost", (String)"s", (String)"SillyAbstract", (Marshaler[])new Marshaler[]{SillySub1Marshaler.instance(), SillySub2Marshaler.instance()});
                builder.addS(value);
            }
        } else if (t != JsonToken.VALUE_NULL) {
            SillyAbstract value = (SillyAbstract)MarshalingSupport.unmarshalWithOneOfMarshalers((JsonParser)parser, (String)"SillyPolyHost", (String)"s", (String)"SillyAbstract", (Marshaler[])new Marshaler[]{SillySub1Marshaler.instance(), SillySub2Marshaler.instance()});
            builder.addS(value);
        }
    }
}

