/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillyStructure;
import org.immutables.generate.silly.SillyStructure;
import org.immutables.generate.silly.SillySubstructure;
import org.immutables.generate.silly.SillySubstructureMarshaler;
import org.immutables.generate.silly.SillyTuplie;
import org.immutables.generate.silly.SillyTuplieMarshaler;

@ParametersAreNonnullByDefault
final class InternalSillyStructureMarshaling {
    private InternalSillyStructureMarshaling() {
    }

    static void marshalIterableOfSillyStructure(JsonGenerator generator, Iterable<SillyStructure> iterable) throws IOException {
        generator.writeStartArray();
        for (SillyStructure instance : iterable) {
            InternalSillyStructureMarshaling.marshalSillyStructure(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillyStructure(JsonGenerator generator, SillyStructure instance) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("attr1");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Object)instance.attr1());
        generator.writeFieldName("flag2");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (boolean)instance.flag2());
        Optional<Integer> opt3Value = instance.opt3();
        if (opt3Value.isPresent()) {
            generator.writeFieldName("opt3");
            int unwrappedopt3Value = (Integer)opt3Value.get();
            BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)unwrappedopt3Value);
        }
        generator.writeFieldName("very4");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (long)instance.very4());
        generator.writeFieldName("wet5");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (double)instance.wet5());
        List<SillySubstructure> subs6Collection = instance.subs6();
        if (!subs6Collection.isEmpty()) {
            generator.writeArrayFieldStart("subs6");
            for (SillySubstructure e : subs6Collection) {
                SillySubstructureMarshaler.marshal(generator, e);
            }
            generator.writeEndArray();
        }
        generator.writeFieldName("nest7");
        SillySubstructureMarshaler.marshal(generator, instance.nest7());
        Optional<SillyTuplie> tup3Value = instance.tup3();
        if (tup3Value.isPresent()) {
            generator.writeFieldName("tup3");
            SillyTuplie unwrappedtup3Value = (SillyTuplie)tup3Value.get();
            SillyTuplieMarshaler.marshal(generator, unwrappedtup3Value);
        }
        generator.writeFieldName("int9");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)instance.int9());
        generator.writeEndObject();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillyStructure", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillyStructure> unmarshalIterableOfSillyStructure(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyStructureMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillyStructureMarshaling.unmarshalSillyStructure(parser));
            }
        } else {
            InternalSillyStructureMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillyStructure>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillyStructureMarshaling.unmarshalSillyStructure(parser));
            }
        }
        return result;
    }

    static SillyStructure unmarshalSillyStructure(JsonParser parser) throws IOException {
        ImmutableSillyStructure.Builder builder = ImmutableSillyStructure.builder();
        String attributeName = "";
        try {
            JsonToken t = parser.getCurrentToken();
            InternalSillyStructureMarshaling.ensure(t == JsonToken.START_OBJECT, "new {", "", t);
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyStructureMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                attributeName = parser.getText();
                InternalSillyStructureMarshaling.unmarshalAttribute(parser, builder, attributeName);
            }
        }
        catch (JsonParseException jsonParse) {
            InternalSillyStructureMarshaling.ensure(false, attributeName, "?", jsonParse.getMessage());
        }
        return builder.build();
    }

    private static void unmarshalAttribute(JsonParser parser, ImmutableSillyStructure.Builder builder, String attributeName) throws IOException {
        switch (attributeName) {
            case "attr1": {
                InternalSillyStructureMarshaling.unmarshalAttributeAttr1(parser, builder);
                break;
            }
            case "flag2": {
                InternalSillyStructureMarshaling.unmarshalAttributeFlag2(parser, builder);
                break;
            }
            case "opt3": {
                InternalSillyStructureMarshaling.unmarshalAttributeOpt3(parser, builder);
                break;
            }
            case "very4": {
                InternalSillyStructureMarshaling.unmarshalAttributeVery4(parser, builder);
                break;
            }
            case "wet5": {
                InternalSillyStructureMarshaling.unmarshalAttributeWet5(parser, builder);
                break;
            }
            case "subs6": {
                InternalSillyStructureMarshaling.unmarshalAttributeSubs6(parser, builder);
                break;
            }
            case "nest7": {
                InternalSillyStructureMarshaling.unmarshalAttributeNest7(parser, builder);
                break;
            }
            case "tup3": {
                InternalSillyStructureMarshaling.unmarshalAttributeTup3(parser, builder);
                break;
            }
            case "int9": {
                InternalSillyStructureMarshaling.unmarshalAttributeInt9(parser, builder);
                break;
            }
            default: {
                InternalSillyStructureMarshaling.unmarshalUnknownAttribute(parser, attributeName);
            }
        }
    }

    private static void unmarshalUnknownAttribute(JsonParser parser, String attributeName) throws IOException {
        JsonToken t = parser.nextToken();
        if (!t.isScalarValue()) {
            parser.skipChildren();
        }
    }

    private static void unmarshalAttributeAttr1(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        String value = BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (String)null, String.class);
        builder.attr1(value);
    }

    private static void unmarshalAttributeFlag2(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        InternalSillyStructureMarshaling.ensure(parser.nextToken().isScalarValue(), "flag2", "boolean", parser.getCurrentToken());
        builder.flag2(parser.getBooleanValue());
    }

    private static void unmarshalAttributeOpt3(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t != JsonToken.VALUE_NULL) {
            InternalSillyStructureMarshaling.ensure(t.isScalarValue(), "opt3", "Optional<Integer>", t);
            builder.opt3(parser.getIntValue());
        }
    }

    private static void unmarshalAttributeVery4(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        InternalSillyStructureMarshaling.ensure(parser.nextToken().isScalarValue(), "very4", "long", parser.getCurrentToken());
        builder.very4(parser.getLongValue());
    }

    private static void unmarshalAttributeWet5(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        InternalSillyStructureMarshaling.ensure(parser.nextToken().isScalarValue(), "wet5", "double", parser.getCurrentToken());
        builder.wet5(parser.getDoubleValue());
    }

    private static void unmarshalAttributeSubs6(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                SillySubstructure value = SillySubstructureMarshaler.unmarshal(parser, null, SillySubstructure.class);
                builder.addSubs6(value);
            }
        } else if (t != JsonToken.VALUE_NULL) {
            SillySubstructure value = SillySubstructureMarshaler.unmarshal(parser, null, SillySubstructure.class);
            builder.addSubs6(value);
        }
    }

    private static void unmarshalAttributeNest7(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        SillySubstructure value = SillySubstructureMarshaler.unmarshal(parser, null, SillySubstructure.class);
        builder.nest7(value);
    }

    private static void unmarshalAttributeTup3(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t != JsonToken.VALUE_NULL) {
            SillyTuplie value = SillyTuplieMarshaler.unmarshal(parser, null, SillyTuplie.class);
            builder.tup3(value);
        }
    }

    private static void unmarshalAttributeInt9(JsonParser parser, ImmutableSillyStructure.Builder builder) throws IOException {
        InternalSillyStructureMarshaling.ensure(parser.nextToken().isScalarValue(), "int9", "int", parser.getCurrentToken());
        builder.int9(parser.getIntValue());
    }
}

