/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillySub3;
import org.immutables.generate.silly.SillySub3;

@ParametersAreNonnullByDefault
final class InternalSillySub3Marshaling {
    private InternalSillySub3Marshaling() {
    }

    static void marshalIterableOfSillySub3(JsonGenerator generator, Iterable<SillySub3> iterable) throws IOException {
        generator.writeStartArray();
        for (SillySub3 instance : iterable) {
            InternalSillySub3Marshaling.marshalSillySub3(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillySub3(JsonGenerator generator, SillySub3 instance) throws IOException {
        generator.writeStartObject();
        List<Double> bCollection = instance.b();
        if (!bCollection.isEmpty()) {
            generator.writeArrayFieldStart("b");
            for (double e : bCollection) {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (double)e);
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillySub3", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillySub3> unmarshalIterableOfSillySub3(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillySub3Marshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillySub3Marshaling.unmarshalSillySub3(parser));
            }
        } else {
            InternalSillySub3Marshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillySub3>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillySub3Marshaling.unmarshalSillySub3(parser));
            }
        }
        return result;
    }

    static SillySub3 unmarshalSillySub3(JsonParser parser) throws IOException {
        ImmutableSillySub3.Builder builder = ImmutableSillySub3.builder();
        String attributeName = "";
        try {
            JsonToken t = parser.getCurrentToken();
            InternalSillySub3Marshaling.ensure(t == JsonToken.START_OBJECT, "new {", "", t);
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillySub3Marshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                attributeName = parser.getText();
                InternalSillySub3Marshaling.unmarshalAttribute(parser, builder, attributeName);
            }
        }
        catch (JsonParseException jsonParse) {
            InternalSillySub3Marshaling.ensure(false, attributeName, "?", jsonParse.getMessage());
        }
        return builder.build();
    }

    private static void unmarshalAttribute(JsonParser parser, ImmutableSillySub3.Builder builder, String attributeName) throws IOException {
        switch (attributeName) {
            case "b": {
                InternalSillySub3Marshaling.unmarshalAttributeB(parser, builder);
                break;
            }
            default: {
                InternalSillySub3Marshaling.unmarshalUnknownAttribute(parser, attributeName);
            }
        }
    }

    private static void unmarshalUnknownAttribute(JsonParser parser, String attributeName) throws IOException {
        JsonToken t = parser.nextToken();
        if (!t.isScalarValue()) {
            parser.skipChildren();
        }
    }

    private static void unmarshalAttributeB(JsonParser parser, ImmutableSillySub3.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                InternalSillySub3Marshaling.ensure(t.isScalarValue(), "b", "List<Double>", t);
                builder.addB(parser.getDoubleValue());
            }
        } else if (t != JsonToken.VALUE_NULL) {
            InternalSillySub3Marshaling.ensure(t.isScalarValue(), "b", "List<Double>", t);
            builder.addB(parser.getDoubleValue());
        }
    }
}

