/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillySubstructure;
import org.immutables.generate.silly.SillySubstructure;

@ParametersAreNonnullByDefault
final class InternalSillySubstructureMarshaling {
    private InternalSillySubstructureMarshaling() {
    }

    static void marshalIterableOfSillySubstructure(JsonGenerator generator, Iterable<SillySubstructure> iterable) throws IOException {
        generator.writeStartArray();
        for (SillySubstructure instance : iterable) {
            InternalSillySubstructureMarshaling.marshalSillySubstructure(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillySubstructure(JsonGenerator generator, SillySubstructure instance) throws IOException {
        List<Float> floats4Collection;
        Set<Integer> set3Collection;
        generator.writeStartObject();
        generator.writeFieldName("e1");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Enum)instance.enum1());
        Set<ElementType> set2Collection = instance.set2();
        if (!set2Collection.isEmpty()) {
            generator.writeArrayFieldStart("set2");
            for (ElementType e : set2Collection) {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Enum)e);
            }
            generator.writeEndArray();
        }
        if (!(set3Collection = instance.set3()).isEmpty()) {
            generator.writeArrayFieldStart("set3");
            for (int e : set3Collection) {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)e);
            }
            generator.writeEndArray();
        }
        if (!(floats4Collection = instance.floats4()).isEmpty()) {
            generator.writeArrayFieldStart("floats4");
            for (float e : floats4Collection) {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (float)e);
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillySubstructure", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillySubstructure> unmarshalIterableOfSillySubstructure(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillySubstructureMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillySubstructureMarshaling.unmarshalSillySubstructure(parser));
            }
        } else {
            InternalSillySubstructureMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillySubstructure>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillySubstructureMarshaling.unmarshalSillySubstructure(parser));
            }
        }
        return result;
    }

    static SillySubstructure unmarshalSillySubstructure(JsonParser parser) throws IOException {
        ImmutableSillySubstructure.Builder builder = ImmutableSillySubstructure.builder();
        String attributeName = "";
        try {
            JsonToken t = parser.getCurrentToken();
            InternalSillySubstructureMarshaling.ensure(t == JsonToken.START_OBJECT, "new {", "", t);
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillySubstructureMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                attributeName = parser.getText();
                InternalSillySubstructureMarshaling.unmarshalAttribute(parser, builder, attributeName);
            }
        }
        catch (JsonParseException jsonParse) {
            InternalSillySubstructureMarshaling.ensure(false, attributeName, "?", jsonParse.getMessage());
        }
        return builder.build();
    }

    private static void unmarshalAttribute(JsonParser parser, ImmutableSillySubstructure.Builder builder, String attributeName) throws IOException {
        switch (attributeName) {
            case "e1": {
                InternalSillySubstructureMarshaling.unmarshalAttributeEnum1(parser, builder);
                break;
            }
            case "set2": {
                InternalSillySubstructureMarshaling.unmarshalAttributeSet2(parser, builder);
                break;
            }
            case "set3": {
                InternalSillySubstructureMarshaling.unmarshalAttributeSet3(parser, builder);
                break;
            }
            case "floats4": {
                InternalSillySubstructureMarshaling.unmarshalAttributeFloats4(parser, builder);
                break;
            }
            default: {
                InternalSillySubstructureMarshaling.unmarshalUnknownAttribute(parser, attributeName);
            }
        }
    }

    private static void unmarshalUnknownAttribute(JsonParser parser, String attributeName) throws IOException {
        JsonToken t = parser.nextToken();
        if (!t.isScalarValue()) {
            parser.skipChildren();
        }
    }

    private static void unmarshalAttributeEnum1(JsonParser parser, ImmutableSillySubstructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        RetentionPolicy value = (RetentionPolicy)BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (Enum)null, RetentionPolicy.class);
        builder.enum1(value);
    }

    private static void unmarshalAttributeSet2(JsonParser parser, ImmutableSillySubstructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                ElementType value = (ElementType)BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (Enum)null, ElementType.class);
                builder.addSet2(value);
            }
        } else if (t != JsonToken.VALUE_NULL) {
            ElementType value = (ElementType)BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (Enum)null, ElementType.class);
            builder.addSet2(value);
        }
    }

    private static void unmarshalAttributeSet3(JsonParser parser, ImmutableSillySubstructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                InternalSillySubstructureMarshaling.ensure(t.isScalarValue(), "set3", "Set<Integer>", t);
                builder.addSet3(parser.getIntValue());
            }
        } else if (t != JsonToken.VALUE_NULL) {
            InternalSillySubstructureMarshaling.ensure(t.isScalarValue(), "set3", "Set<Integer>", t);
            builder.addSet3(parser.getIntValue());
        }
    }

    private static void unmarshalAttributeFloats4(JsonParser parser, ImmutableSillySubstructure.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                InternalSillySubstructureMarshaling.ensure(t.isScalarValue(), "floats4", "List<Float>", t);
                builder.addFloats4(parser.getFloatValue());
            }
        } else if (t != JsonToken.VALUE_NULL) {
            InternalSillySubstructureMarshaling.ensure(t.isScalarValue(), "floats4", "List<Float>", t);
            builder.addFloats4(parser.getFloatValue());
        }
    }
}

