/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.generate.silly.ImmutableSillyTuplie;
import org.immutables.generate.silly.SillyTuplie;

@ParametersAreNonnullByDefault
final class InternalSillyTuplieMarshaling {
    private InternalSillyTuplieMarshaling() {
    }

    static void marshalIterableOfSillyTuplie(JsonGenerator generator, Iterable<SillyTuplie> iterable) throws IOException {
        generator.writeStartArray();
        for (SillyTuplie instance : iterable) {
            InternalSillyTuplieMarshaling.marshalSillyTuplie(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillyTuplie(JsonGenerator generator, SillyTuplie instance) throws IOException {
        generator.writeStartArray();
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (float)instance.float1());
        Optional<Byte> opt2Value = instance.opt2();
        if (opt2Value.isPresent()) {
            byte unwrappedopt2Value = (Byte)opt2Value.get();
            BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (byte)unwrappedopt2Value);
        } else {
            generator.writeNull();
        }
        generator.writeStartArray();
        for (boolean e : instance.set3()) {
            BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (boolean)e);
        }
        generator.writeEndArray();
        generator.writeEndArray();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillyTuplie", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillyTuplie> unmarshalIterableOfSillyTuplie(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyTuplieMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillyTuplieMarshaling.unmarshalSillyTuplie(parser));
            }
        } else {
            InternalSillyTuplieMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillyTuplie>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillyTuplieMarshaling.unmarshalSillyTuplie(parser));
            }
        }
        return result;
    }

    private static JsonParser nextTokenAdvance(JsonParser parser) throws IOException {
        parser.nextToken();
        return parser;
    }

    static SillyTuplie unmarshalSillyTuplie(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        InternalSillyTuplieMarshaling.ensure(t == JsonToken.START_ARRAY, "of [", "", t);
        ImmutableSillyTuplie instance = ImmutableSillyTuplie.of(InternalSillyTuplieMarshaling.unmarshalConstructorArgumentFloat1(InternalSillyTuplieMarshaling.nextTokenAdvance(parser)), InternalSillyTuplieMarshaling.unmarshalConstructorArgumentOpt2(InternalSillyTuplieMarshaling.nextTokenAdvance(parser)), InternalSillyTuplieMarshaling.unmarshalConstructorArgumentSet3(InternalSillyTuplieMarshaling.nextTokenAdvance(parser)));
        InternalSillyTuplieMarshaling.ensure(parser.nextToken() == JsonToken.END_ARRAY, "]", "", parser.getCurrentToken());
        return instance;
    }

    private static float unmarshalConstructorArgumentFloat1(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        InternalSillyTuplieMarshaling.ensure(t.isScalarValue(), "float1", "float", t);
        return parser.getFloatValue();
    }

    private static Optional<Byte> unmarshalConstructorArgumentOpt2(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t != JsonToken.VALUE_NULL) {
            InternalSillyTuplieMarshaling.ensure(t.isScalarValue(), "opt2", "Optional<Byte>", t);
            return Optional.of((Object)parser.getByteValue());
        }
        return Optional.absent();
    }

    private static Set<Boolean> unmarshalConstructorArgumentSet3(JsonParser parser) throws IOException {
        JsonToken t = parser.getCurrentToken();
        ArrayList elements = Lists.newArrayList();
        if (t == JsonToken.START_ARRAY) {
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                InternalSillyTuplieMarshaling.ensure(t.isScalarValue(), "set3", "Set<Boolean>", t);
                elements.add(parser.getBooleanValue());
            }
        } else if (t != JsonToken.VALUE_NULL) {
            InternalSillyTuplieMarshaling.ensure(t.isScalarValue(), "set3", "Set<Boolean>", t);
            elements.add(parser.getBooleanValue());
        }
        return ImmutableSet.copyOf((Collection)elements);
    }
}

