/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly.repository;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedInteger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.common.concurrent.FluentFuture;
import org.immutables.common.marshal.Marshaler;
import org.immutables.common.repository.Repositories;
import org.immutables.common.repository.RepositorySetup;
import org.immutables.common.repository.internal.ConstraintSupport;
import org.immutables.common.repository.internal.RepositorySupport;
import org.immutables.generate.silly.SillyEntity;
import org.immutables.generate.silly.SillyEntityMarshaler;

@ParametersAreNonnullByDefault
@ThreadSafe
public final class SillyEntityRepository
extends Repositories.Repository<SillyEntity> {
    private static final String DOCUMENT_COLLECTION_NAME = "sillyEntity";

    private SillyEntityRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, (Marshaler)SillyEntityMarshaler.instance());
    }

    public static SillyEntityRepository create(RepositorySetup configuration) {
        return new SillyEntityRepository(configuration);
    }

    public FluentFuture<Integer> insert(SillyEntity document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends SillyEntity> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    public FluentFuture<Integer> deleteAll(Criteria criteria) {
        return super.doDelete((ConstraintSupport.ConstraintHost)criteria);
    }

    @CheckReturnValue
    public Finder findById(int id) {
        return this.find(SillyEntityRepository.where().id(id));
    }

    public FluentFuture<Integer> upsert(SillyEntity document) {
        Criteria byId = SillyEntityRepository.where().id(document.id());
        return super.doUpsert((ConstraintSupport.ConstraintHost)byId, (Object)document);
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, criteria);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public static Criteria where() {
        return new InternalCriteria(ConstraintSupport.nilConstraint());
    }

    private static Object wrapMarshalable(Object value) {
        return value;
    }

    private static Object wrapMarshalable(final UnsignedInteger value) {
        return new RepositorySupport.MarshalableWrapper(value){

            protected void marshalWrapped(JsonGenerator generator) throws IOException {
                SillyEntity.marshal(generator, value);
            }
        };
    }

    private static final class InternalCriteria
    extends Criteria
    implements ConstraintSupport.ConstraintHost {
        final ConstraintSupport.Constraint constraint;

        InternalCriteria(ConstraintSupport.Constraint constraint) {
            this.constraint = constraint;
        }

        public <V extends ConstraintSupport.ConstraintVisitor<V>> V accept(V visitor) {
            return (V)this.constraint.accept(visitor);
        }

        @Override
        public InternalCriteria id(int value) {
            return new InternalCriteria(this.constraint.equal("_id", false, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria idNot(int value) {
            return new InternalCriteria(this.constraint.equal("_id", true, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria idIn(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("_id", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria idIn(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntityRepository.wrapMarshalable(first));
            values.add(SillyEntityRepository.wrapMarshalable(second));
            for (int value : rest) {
                values.add(SillyEntityRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("_id", false, (Iterable)values));
        }

        @Override
        public InternalCriteria idNotIn(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("_id", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria idNotIn(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntityRepository.wrapMarshalable(first));
            values.add(SillyEntityRepository.wrapMarshalable(second));
            for (int value : rest) {
                values.add(SillyEntityRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("_id", true, (Iterable)values));
        }

        @Override
        public InternalCriteria val(String value) {
            return new InternalCriteria(this.constraint.equal("v", false, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria valNot(String value) {
            return new InternalCriteria(this.constraint.equal("v", true, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria valIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("v", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria valIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntityRepository.wrapMarshalable(first));
            values.add(SillyEntityRepository.wrapMarshalable(second));
            for (String value : rest) {
                values.add(SillyEntityRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("v", false, (Iterable)values));
        }

        @Override
        public InternalCriteria valNotIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("v", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria valNotIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntityRepository.wrapMarshalable(first));
            values.add(SillyEntityRepository.wrapMarshalable(second));
            for (String value : rest) {
                values.add(SillyEntityRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("v", true, (Iterable)values));
        }

        @Override
        public InternalCriteria valStartsWith(String prefix) {
            return new InternalCriteria(this.constraint.match("v", false, ConstraintSupport.prefixPatternOf((String)prefix)));
        }

        @Override
        public InternalCriteria valMatches(Pattern pattern) {
            return new InternalCriteria(this.constraint.match("v", false, pattern));
        }

        @Override
        public InternalCriteria valNotMatches(Pattern pattern) {
            return new InternalCriteria(this.constraint.match("v", true, pattern));
        }

        @Override
        public InternalCriteria valGreaterThan(String lower) {
            return this.valIn(Range.greaterThan((Comparable)((Object)lower)));
        }

        @Override
        public InternalCriteria valLessThan(String upper) {
            return this.valIn(Range.lessThan((Comparable)((Object)upper)));
        }

        @Override
        public InternalCriteria valAtMost(String upperInclusive) {
            return this.valIn(Range.atMost((Comparable)((Object)upperInclusive)));
        }

        @Override
        public InternalCriteria valAtLeast(String lowerInclusive) {
            return this.valIn(Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        @Override
        public InternalCriteria valIn(Range<String> range) {
            return new InternalCriteria(this.constraint.range("v", false, InternalCriteria.wrappedRangeVal(range)));
        }

        @Override
        public InternalCriteria valNotIn(Range<String> range) {
            return new InternalCriteria(this.constraint.range("v", true, InternalCriteria.wrappedRangeVal(range)));
        }

        private static Range<Comparable<Object>> wrappedRangeVal(Range<String> range) {
            if (range.hasLowerBound() && range.hasUpperBound()) {
                return Range.range((Comparable)((Comparable)SillyEntityRepository.wrapMarshalable(range.lowerEndpoint())), (BoundType)range.lowerBoundType(), (Comparable)((Comparable)SillyEntityRepository.wrapMarshalable(range.upperEndpoint())), (BoundType)range.upperBoundType());
            }
            if (range.hasLowerBound()) {
                return Range.downTo((Comparable)((Comparable)SillyEntityRepository.wrapMarshalable(range.lowerEndpoint())), (BoundType)range.lowerBoundType());
            }
            if (range.hasUpperBound()) {
                return Range.upTo((Comparable)((Comparable)SillyEntityRepository.wrapMarshalable(range.upperEndpoint())), (BoundType)range.upperBoundType());
            }
            throw new AssertionError();
        }

        @Override
        public InternalCriteria payload(String value) {
            return new InternalCriteria(this.constraint.equal("p", false, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria payloadNot(String value) {
            return new InternalCriteria(this.constraint.equal("p", true, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria payloadIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("p", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria payloadIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntityRepository.wrapMarshalable(first));
            values.add(SillyEntityRepository.wrapMarshalable(second));
            for (String value : rest) {
                values.add(SillyEntityRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("p", false, (Iterable)values));
        }

        @Override
        public InternalCriteria payloadNotIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("p", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria payloadNotIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntityRepository.wrapMarshalable(first));
            values.add(SillyEntityRepository.wrapMarshalable(second));
            for (String value : rest) {
                values.add(SillyEntityRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("p", true, (Iterable)values));
        }

        @Override
        public InternalCriteria intsEmpty() {
            return new InternalCriteria(this.constraint.size("i", false, 0));
        }

        @Override
        public InternalCriteria intsNonEmpty() {
            return new InternalCriteria(this.constraint.size("i", true, 0));
        }

        @Override
        public InternalCriteria intsSize(int size) {
            return new InternalCriteria(this.constraint.size("i", false, size));
        }

        @Override
        public InternalCriteria intsContains(int value) {
            return new InternalCriteria(this.constraint.equal("i", false, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria intsContainsAll(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.nested("i", (ConstraintSupport.ConstraintHost)ConstraintSupport.nilConstraint().equal("$all", false, (Object)wrappedValues)));
        }

        @Override
        public InternalCriteria der(UnsignedInteger value) {
            return new InternalCriteria(this.constraint.equal("der", false, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria derNot(UnsignedInteger value) {
            return new InternalCriteria(this.constraint.equal("der", true, SillyEntityRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria derIn(Iterable<UnsignedInteger> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (UnsignedInteger v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("der", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria derIn(UnsignedInteger first, UnsignedInteger second, UnsignedInteger ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntityRepository.wrapMarshalable(first));
            values.add(SillyEntityRepository.wrapMarshalable(second));
            for (UnsignedInteger value : rest) {
                values.add(SillyEntityRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("der", false, (Iterable)values));
        }

        @Override
        public InternalCriteria derNotIn(Iterable<UnsignedInteger> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (UnsignedInteger v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("der", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria derNotIn(UnsignedInteger first, UnsignedInteger second, UnsignedInteger ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntityRepository.wrapMarshalable(first));
            values.add(SillyEntityRepository.wrapMarshalable(second));
            for (UnsignedInteger value : rest) {
                values.add(SillyEntityRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("der", true, (Iterable)values));
        }

        @Override
        public InternalCriteria derGreaterThan(UnsignedInteger lower) {
            return this.derIn(Range.greaterThan((Comparable)lower));
        }

        @Override
        public InternalCriteria derLessThan(UnsignedInteger upper) {
            return this.derIn(Range.lessThan((Comparable)upper));
        }

        @Override
        public InternalCriteria derAtMost(UnsignedInteger upperInclusive) {
            return this.derIn(Range.atMost((Comparable)upperInclusive));
        }

        @Override
        public InternalCriteria derAtLeast(UnsignedInteger lowerInclusive) {
            return this.derIn(Range.atLeast((Comparable)lowerInclusive));
        }

        @Override
        public InternalCriteria derIn(Range<UnsignedInteger> range) {
            return new InternalCriteria(this.constraint.range("der", false, InternalCriteria.wrappedRangeDer(range)));
        }

        @Override
        public InternalCriteria derNotIn(Range<UnsignedInteger> range) {
            return new InternalCriteria(this.constraint.range("der", true, InternalCriteria.wrappedRangeDer(range)));
        }

        private static Range<Comparable<Object>> wrappedRangeDer(Range<UnsignedInteger> range) {
            if (range.hasLowerBound() && range.hasUpperBound()) {
                return Range.range((Comparable)((Comparable)SillyEntityRepository.wrapMarshalable((UnsignedInteger)range.lowerEndpoint())), (BoundType)range.lowerBoundType(), (Comparable)((Comparable)SillyEntityRepository.wrapMarshalable((UnsignedInteger)range.upperEndpoint())), (BoundType)range.upperBoundType());
            }
            if (range.hasLowerBound()) {
                return Range.downTo((Comparable)((Comparable)SillyEntityRepository.wrapMarshalable((UnsignedInteger)range.lowerEndpoint())), (BoundType)range.lowerBoundType());
            }
            if (range.hasUpperBound()) {
                return Range.upTo((Comparable)((Comparable)SillyEntityRepository.wrapMarshalable((UnsignedInteger)range.upperEndpoint())), (BoundType)range.upperBoundType());
            }
            throw new AssertionError();
        }

        @Override
        public InternalCriteria or() {
            return new InternalCriteria(this.constraint.disjunction());
        }

        public String toString() {
            return "SillyEntityRepository.where(" + RepositorySupport.stringify((ConstraintSupport.ConstraintHost)this) + ")";
        }
    }

    @Immutable
    public static abstract class Criteria
    extends Repositories.Criteria {
        Criteria() {
        }

        public abstract Criteria id(int var1);

        public abstract Criteria idNot(int var1);

        public abstract Criteria idIn(Iterable<Integer> var1);

        public abstract Criteria idIn(int var1, int var2, int ... var3);

        public abstract Criteria idNotIn(Iterable<Integer> var1);

        public abstract Criteria idNotIn(int var1, int var2, int ... var3);

        public abstract Criteria val(String var1);

        public abstract Criteria valNot(String var1);

        public abstract Criteria valIn(Iterable<String> var1);

        public abstract Criteria valIn(String var1, String var2, String ... var3);

        public abstract Criteria valNotIn(Iterable<String> var1);

        public abstract Criteria valNotIn(String var1, String var2, String ... var3);

        public abstract Criteria valStartsWith(String var1);

        public abstract Criteria valMatches(Pattern var1);

        public abstract Criteria valNotMatches(Pattern var1);

        public abstract Criteria valGreaterThan(String var1);

        public abstract Criteria valLessThan(String var1);

        public abstract Criteria valAtMost(String var1);

        public abstract Criteria valAtLeast(String var1);

        public abstract Criteria valIn(Range<String> var1);

        public abstract Criteria valNotIn(Range<String> var1);

        public abstract Criteria payload(String var1);

        public abstract Criteria payloadNot(String var1);

        public abstract Criteria payloadIn(Iterable<String> var1);

        public abstract Criteria payloadIn(String var1, String var2, String ... var3);

        public abstract Criteria payloadNotIn(Iterable<String> var1);

        public abstract Criteria payloadNotIn(String var1, String var2, String ... var3);

        public abstract Criteria intsEmpty();

        public abstract Criteria intsNonEmpty();

        public abstract Criteria intsSize(int var1);

        public abstract Criteria intsContains(int var1);

        public abstract Criteria intsContainsAll(Iterable<Integer> var1);

        public abstract Criteria der(UnsignedInteger var1);

        public abstract Criteria derNot(UnsignedInteger var1);

        public abstract Criteria derIn(Iterable<UnsignedInteger> var1);

        public abstract Criteria derIn(UnsignedInteger var1, UnsignedInteger var2, UnsignedInteger ... var3);

        public abstract Criteria derNotIn(Iterable<UnsignedInteger> var1);

        public abstract Criteria derNotIn(UnsignedInteger var1, UnsignedInteger var2, UnsignedInteger ... var3);

        public abstract Criteria derGreaterThan(UnsignedInteger var1);

        public abstract Criteria derLessThan(UnsignedInteger var1);

        public abstract Criteria derAtMost(UnsignedInteger var1);

        public abstract Criteria derAtLeast(UnsignedInteger var1);

        public abstract Criteria derIn(Range<UnsignedInteger> var1);

        public abstract Criteria derNotIn(Range<UnsignedInteger> var1);

        public abstract Criteria or();
    }

    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<SillyEntity, Indexer> {
        private Indexer(SillyEntityRepository repository) {
            super((Repositories.Repository)repository);
        }

        public Indexer withId() {
            this.fields = this.fields.equal("_id", false, (Object)1);
            return this;
        }

        public Indexer withIdDesceding() {
            this.fields = this.fields.equal("_id", false, (Object)-1);
            return this;
        }

        public Indexer withVal() {
            this.fields = this.fields.equal("v", false, (Object)1);
            return this;
        }

        public Indexer withValDesceding() {
            this.fields = this.fields.equal("v", false, (Object)-1);
            return this;
        }

        public Indexer withPayload() {
            this.fields = this.fields.equal("p", false, (Object)1);
            return this;
        }

        public Indexer withPayloadDesceding() {
            this.fields = this.fields.equal("p", false, (Object)-1);
            return this;
        }

        public Indexer withInts() {
            this.fields = this.fields.equal("i", false, (Object)1);
            return this;
        }

        public Indexer withIntsDesceding() {
            this.fields = this.fields.equal("i", false, (Object)-1);
            return this;
        }

        public Indexer withDer() {
            this.fields = this.fields.equal("der", false, (Object)1);
            return this;
        }

        public Indexer withDerDesceding() {
            this.fields = this.fields.equal("der", false, (Object)-1);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<SillyEntity, Modifier> {
        private Modifier(Repositories.Repository<SillyEntity> repository, ConstraintSupport.ConstraintHost criteria, ConstraintSupport.Constraint ordering, ConstraintSupport.Constraint exclusion) {
            super(repository);
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setVal(String value) {
            this.setFields = this.setFields.equal("v", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initVal(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("v", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier clearPayload() {
            this.setFields = this.setFields.equal("p", false, RepositorySupport.emptyBsonObject());
            return this;
        }

        public Modifier putPayload(String key, int value) {
            this.setFields = this.setFields.equal("p." + key, false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier removePayload(String key) {
            this.unsetFields = this.unsetFields.equal("p." + key, false, (Object)1);
            return this;
        }

        public Modifier clearInts() {
            this.unsetFields = this.unsetFields.equal("i", false, (Object)1);
            return this;
        }

        public Modifier removeInts(int value) {
            this.pullFields = this.pullFields.equal("i", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier addInts(int value) {
            this.pushFields = this.pushFields.equal("i", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier addAllInts(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : RepositorySupport.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal("i", false, v);
            return this;
        }

        public Modifier setDer(UnsignedInteger value) {
            this.setFields = this.setFields.equal("der", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initDer(UnsignedInteger value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("der", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }
    }

    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<SillyEntity> {
        private Updater(SillyEntityRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = (ConstraintSupport.ConstraintHost)criteria;
        }

        public Updater setVal(String value) {
            this.setFields = this.setFields.equal("v", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initVal(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("v", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Updater clearPayload() {
            this.setFields = this.setFields.equal("p", false, RepositorySupport.emptyBsonObject());
            return this;
        }

        public Updater putPayload(String key, int value) {
            this.setFields = this.setFields.equal("p." + key, false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Updater removePayload(String key) {
            this.unsetFields = this.unsetFields.equal("p." + key, false, (Object)1);
            return this;
        }

        public Updater clearInts() {
            this.unsetFields = this.unsetFields.equal("i", false, (Object)1);
            return this;
        }

        public Updater removeInts(int value) {
            this.pullFields = this.pullFields.equal("i", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Updater addInts(int value) {
            this.pushFields = this.pushFields.equal("i", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Updater addAllInts(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyEntityRepository.wrapMarshalable(v));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : RepositorySupport.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal("i", false, v);
            return this;
        }

        public Updater setDer(UnsignedInteger value) {
            this.setFields = this.setFields.equal("der", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initDer(UnsignedInteger value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("der", false, SillyEntityRepository.wrapMarshalable(value));
            return this;
        }
    }

    @NotThreadSafe
    public static final class Finder
    extends Repositories.Finder<SillyEntity, Finder> {
        private Finder(SillyEntityRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = (ConstraintSupport.ConstraintHost)criteria;
        }

        public Finder orderById() {
            this.ordering = this.ordering.equal("_id", false, (Object)1);
            return this;
        }

        public Finder orderByIdDesceding() {
            this.ordering = this.ordering.equal("_id", false, (Object)-1);
            return this;
        }

        public Finder orderByVal() {
            this.ordering = this.ordering.equal("v", false, (Object)1);
            return this;
        }

        public Finder orderByValDesceding() {
            this.ordering = this.ordering.equal("v", false, (Object)-1);
            return this;
        }

        public Finder orderByPayload() {
            this.ordering = this.ordering.equal("p", false, (Object)1);
            return this;
        }

        public Finder orderByPayloadDesceding() {
            this.ordering = this.ordering.equal("p", false, (Object)-1);
            return this;
        }

        public Finder orderByInts() {
            this.ordering = this.ordering.equal("i", false, (Object)1);
            return this;
        }

        public Finder orderByIntsDesceding() {
            this.ordering = this.ordering.equal("i", false, (Object)-1);
            return this;
        }

        public Finder orderByDer() {
            this.ordering = this.ordering.equal("der", false, (Object)1);
            return this;
        }

        public Finder orderByDerDesceding() {
            this.ordering = this.ordering.equal("der", false, (Object)-1);
            return this;
        }

        public Finder excludePayload() {
            this.exclusion = this.exclusion.equal("p", false, (Object)-1);
            return this;
        }

        public Finder excludeInts() {
            this.exclusion = this.exclusion.equal("i", false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier(this.repository, this.criteria, this.ordering, this.exclusion);
        }
    }
}

