/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly.repository;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.common.concurrent.FluentFuture;
import org.immutables.common.marshal.Marshaler;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.repository.Id;
import org.immutables.common.repository.Repositories;
import org.immutables.common.repository.RepositorySetup;
import org.immutables.common.repository.internal.ConstraintSupport;
import org.immutables.common.repository.internal.RepositorySupport;
import org.immutables.generate.silly.SillyEntitySecond;
import org.immutables.generate.silly.SillyEntitySecondMarshaler;

@ParametersAreNonnullByDefault
@ThreadSafe
public final class SillyEntitySecondRepository
extends Repositories.Repository<SillyEntitySecond> {
    private static final String DOCUMENT_COLLECTION_NAME = "ent2";

    private SillyEntitySecondRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, (Marshaler)SillyEntitySecondMarshaler.instance());
    }

    public static SillyEntitySecondRepository create(RepositorySetup configuration) {
        return new SillyEntitySecondRepository(configuration);
    }

    public FluentFuture<Integer> insert(SillyEntitySecond document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends SillyEntitySecond> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    public FluentFuture<Integer> deleteAll(Criteria criteria) {
        return super.doDelete((ConstraintSupport.ConstraintHost)criteria);
    }

    @CheckReturnValue
    public Finder findById(Id id) {
        return this.find(SillyEntitySecondRepository.where().id(id));
    }

    public FluentFuture<Integer> upsert(SillyEntitySecond document) {
        Criteria byId = SillyEntitySecondRepository.where().id(document.id());
        return super.doUpsert((ConstraintSupport.ConstraintHost)byId, (Object)document);
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, criteria);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public static Criteria where() {
        return new InternalCriteria(ConstraintSupport.nilConstraint());
    }

    private static Object wrapMarshalable(Object value) {
        return value;
    }

    private static Object wrapMarshalable(final Id value) {
        return new RepositorySupport.MarshalableWrapper(value){

            protected void marshalWrapped(JsonGenerator generator) throws IOException {
                BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Id)value);
            }
        };
    }

    private static final class InternalCriteria
    extends Criteria
    implements ConstraintSupport.ConstraintHost {
        final ConstraintSupport.Constraint constraint;

        InternalCriteria(ConstraintSupport.Constraint constraint) {
            this.constraint = constraint;
        }

        public <V extends ConstraintSupport.ConstraintVisitor<V>> V accept(V visitor) {
            return (V)this.constraint.accept(visitor);
        }

        @Override
        public InternalCriteria id(Id value) {
            return new InternalCriteria(this.constraint.equal("_id", false, SillyEntitySecondRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria idNot(Id value) {
            return new InternalCriteria(this.constraint.equal("_id", true, SillyEntitySecondRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria idIn(Iterable<Id> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Id v : values) {
                wrappedValues.add(SillyEntitySecondRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("_id", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria idIn(Id first, Id second, Id ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntitySecondRepository.wrapMarshalable(first));
            values.add(SillyEntitySecondRepository.wrapMarshalable(second));
            for (Id value : rest) {
                values.add(SillyEntitySecondRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("_id", false, (Iterable)values));
        }

        @Override
        public InternalCriteria idNotIn(Iterable<Id> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Id v : values) {
                wrappedValues.add(SillyEntitySecondRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("_id", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria idNotIn(Id first, Id second, Id ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyEntitySecondRepository.wrapMarshalable(first));
            values.add(SillyEntitySecondRepository.wrapMarshalable(second));
            for (Id value : rest) {
                values.add(SillyEntitySecondRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("_id", true, (Iterable)values));
        }

        @Override
        public InternalCriteria or() {
            return new InternalCriteria(this.constraint.disjunction());
        }

        public String toString() {
            return "SillyEntitySecondRepository.where(" + RepositorySupport.stringify((ConstraintSupport.ConstraintHost)this) + ")";
        }
    }

    @Immutable
    public static abstract class Criteria
    extends Repositories.Criteria {
        Criteria() {
        }

        public abstract Criteria id(Id var1);

        public abstract Criteria idNot(Id var1);

        public abstract Criteria idIn(Iterable<Id> var1);

        public abstract Criteria idIn(Id var1, Id var2, Id ... var3);

        public abstract Criteria idNotIn(Iterable<Id> var1);

        public abstract Criteria idNotIn(Id var1, Id var2, Id ... var3);

        public abstract Criteria or();
    }

    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<SillyEntitySecond, Indexer> {
        private Indexer(SillyEntitySecondRepository repository) {
            super((Repositories.Repository)repository);
        }

        public Indexer withId() {
            this.fields = this.fields.equal("_id", false, (Object)1);
            return this;
        }

        public Indexer withIdDesceding() {
            this.fields = this.fields.equal("_id", false, (Object)-1);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<SillyEntitySecond, Modifier> {
        private Modifier(Repositories.Repository<SillyEntitySecond> repository, ConstraintSupport.ConstraintHost criteria, ConstraintSupport.Constraint ordering, ConstraintSupport.Constraint exclusion) {
            super(repository);
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }
    }

    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<SillyEntitySecond> {
        private Updater(SillyEntitySecondRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = (ConstraintSupport.ConstraintHost)criteria;
        }
    }

    @NotThreadSafe
    public static final class Finder
    extends Repositories.Finder<SillyEntitySecond, Finder> {
        private Finder(SillyEntitySecondRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = (ConstraintSupport.ConstraintHost)criteria;
        }

        public Finder orderById() {
            this.ordering = this.ordering.equal("_id", false, (Object)1);
            return this;
        }

        public Finder orderByIdDesceding() {
            this.ordering = this.ordering.equal("_id", false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier(this.repository, this.criteria, this.ordering, this.exclusion);
        }
    }
}

