/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generate.silly.repository;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.common.concurrent.FluentFuture;
import org.immutables.common.marshal.Marshaler;
import org.immutables.common.repository.Repositories;
import org.immutables.common.repository.RepositorySetup;
import org.immutables.common.repository.internal.ConstraintSupport;
import org.immutables.common.repository.internal.RepositorySupport;
import org.immutables.generate.silly.SillyStructureWithId;
import org.immutables.generate.silly.SillyStructureWithIdMarshaler;
import org.immutables.generate.silly.SillySubstructure;
import org.immutables.generate.silly.SillySubstructureMarshaler;
import org.immutables.generate.silly.SillyTuplie;
import org.immutables.generate.silly.SillyTuplieMarshaler;

@ParametersAreNonnullByDefault
@ThreadSafe
public final class SillyStructureWithIdRepository
extends Repositories.Repository<SillyStructureWithId> {
    private static final String DOCUMENT_COLLECTION_NAME = "sillyStructureWithId";

    private SillyStructureWithIdRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, (Marshaler)SillyStructureWithIdMarshaler.instance());
    }

    public static SillyStructureWithIdRepository create(RepositorySetup configuration) {
        return new SillyStructureWithIdRepository(configuration);
    }

    public FluentFuture<Integer> insert(SillyStructureWithId document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends SillyStructureWithId> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    public FluentFuture<Integer> deleteAll(Criteria criteria) {
        return super.doDelete((ConstraintSupport.ConstraintHost)criteria);
    }

    @CheckReturnValue
    public Finder findById(String id) {
        return this.find(SillyStructureWithIdRepository.where().id(id));
    }

    public FluentFuture<Integer> upsert(SillyStructureWithId document) {
        Criteria byId = SillyStructureWithIdRepository.where().id(document.id());
        return super.doUpsert((ConstraintSupport.ConstraintHost)byId, (Object)document);
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, criteria);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public static Criteria where() {
        return new InternalCriteria(ConstraintSupport.nilConstraint());
    }

    private static Object wrapMarshalable(Object value) {
        return value;
    }

    private static Object wrapMarshalable(final SillySubstructure value) {
        return new RepositorySupport.MarshalableWrapper(value){

            protected void marshalWrapped(JsonGenerator generator) throws IOException {
                SillySubstructureMarshaler.marshal(generator, value);
            }
        };
    }

    private static Object wrapMarshalable(final SillyTuplie value) {
        return new RepositorySupport.MarshalableWrapper(value){

            protected void marshalWrapped(JsonGenerator generator) throws IOException {
                SillyTuplieMarshaler.marshal(generator, value);
            }
        };
    }

    private static final class InternalCriteria
    extends Criteria
    implements ConstraintSupport.ConstraintHost {
        final ConstraintSupport.Constraint constraint;

        InternalCriteria(ConstraintSupport.Constraint constraint) {
            this.constraint = constraint;
        }

        public <V extends ConstraintSupport.ConstraintVisitor<V>> V accept(V visitor) {
            return (V)this.constraint.accept(visitor);
        }

        @Override
        public InternalCriteria id(String value) {
            return new InternalCriteria(this.constraint.equal("_id", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria idNot(String value) {
            return new InternalCriteria(this.constraint.equal("_id", true, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria idIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("_id", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria idIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (String value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("_id", false, (Iterable)values));
        }

        @Override
        public InternalCriteria idNotIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("_id", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria idNotIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (String value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("_id", true, (Iterable)values));
        }

        @Override
        public InternalCriteria idStartsWith(String prefix) {
            return new InternalCriteria(this.constraint.match("_id", false, ConstraintSupport.prefixPatternOf((String)prefix)));
        }

        @Override
        public InternalCriteria idMatches(Pattern pattern) {
            return new InternalCriteria(this.constraint.match("_id", false, pattern));
        }

        @Override
        public InternalCriteria idNotMatches(Pattern pattern) {
            return new InternalCriteria(this.constraint.match("_id", true, pattern));
        }

        @Override
        public InternalCriteria idGreaterThan(String lower) {
            return this.idIn(Range.greaterThan((Comparable)((Object)lower)));
        }

        @Override
        public InternalCriteria idLessThan(String upper) {
            return this.idIn(Range.lessThan((Comparable)((Object)upper)));
        }

        @Override
        public InternalCriteria idAtMost(String upperInclusive) {
            return this.idIn(Range.atMost((Comparable)((Object)upperInclusive)));
        }

        @Override
        public InternalCriteria idAtLeast(String lowerInclusive) {
            return this.idIn(Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        @Override
        public InternalCriteria idIn(Range<String> range) {
            return new InternalCriteria(this.constraint.range("_id", false, InternalCriteria.wrappedRangeId(range)));
        }

        @Override
        public InternalCriteria idNotIn(Range<String> range) {
            return new InternalCriteria(this.constraint.range("_id", true, InternalCriteria.wrappedRangeId(range)));
        }

        private static Range<Comparable<Object>> wrappedRangeId(Range<String> range) {
            if (range.hasLowerBound() && range.hasUpperBound()) {
                return Range.range((Comparable)((Comparable)SillyStructureWithIdRepository.wrapMarshalable(range.lowerEndpoint())), (BoundType)range.lowerBoundType(), (Comparable)((Comparable)SillyStructureWithIdRepository.wrapMarshalable(range.upperEndpoint())), (BoundType)range.upperBoundType());
            }
            if (range.hasLowerBound()) {
                return Range.downTo((Comparable)((Comparable)SillyStructureWithIdRepository.wrapMarshalable(range.lowerEndpoint())), (BoundType)range.lowerBoundType());
            }
            if (range.hasUpperBound()) {
                return Range.upTo((Comparable)((Comparable)SillyStructureWithIdRepository.wrapMarshalable(range.upperEndpoint())), (BoundType)range.upperBoundType());
            }
            throw new AssertionError();
        }

        @Override
        public InternalCriteria attr1(String value) {
            return new InternalCriteria(this.constraint.equal("attr1", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria attr1Not(String value) {
            return new InternalCriteria(this.constraint.equal("attr1", true, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria attr1In(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("attr1", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria attr1In(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (String value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("attr1", false, (Iterable)values));
        }

        @Override
        public InternalCriteria attr1NotIn(Iterable<String> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (String v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("attr1", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria attr1NotIn(String first, String second, String ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (String value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("attr1", true, (Iterable)values));
        }

        @Override
        public InternalCriteria attr1StartsWith(String prefix) {
            return new InternalCriteria(this.constraint.match("attr1", false, ConstraintSupport.prefixPatternOf((String)prefix)));
        }

        @Override
        public InternalCriteria attr1Matches(Pattern pattern) {
            return new InternalCriteria(this.constraint.match("attr1", false, pattern));
        }

        @Override
        public InternalCriteria attr1NotMatches(Pattern pattern) {
            return new InternalCriteria(this.constraint.match("attr1", true, pattern));
        }

        @Override
        public InternalCriteria attr1GreaterThan(String lower) {
            return this.attr1In(Range.greaterThan((Comparable)((Object)lower)));
        }

        @Override
        public InternalCriteria attr1LessThan(String upper) {
            return this.attr1In(Range.lessThan((Comparable)((Object)upper)));
        }

        @Override
        public InternalCriteria attr1AtMost(String upperInclusive) {
            return this.attr1In(Range.atMost((Comparable)((Object)upperInclusive)));
        }

        @Override
        public InternalCriteria attr1AtLeast(String lowerInclusive) {
            return this.attr1In(Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        @Override
        public InternalCriteria attr1In(Range<String> range) {
            return new InternalCriteria(this.constraint.range("attr1", false, InternalCriteria.wrappedRangeAttr1(range)));
        }

        @Override
        public InternalCriteria attr1NotIn(Range<String> range) {
            return new InternalCriteria(this.constraint.range("attr1", true, InternalCriteria.wrappedRangeAttr1(range)));
        }

        private static Range<Comparable<Object>> wrappedRangeAttr1(Range<String> range) {
            if (range.hasLowerBound() && range.hasUpperBound()) {
                return Range.range((Comparable)((Comparable)SillyStructureWithIdRepository.wrapMarshalable(range.lowerEndpoint())), (BoundType)range.lowerBoundType(), (Comparable)((Comparable)SillyStructureWithIdRepository.wrapMarshalable(range.upperEndpoint())), (BoundType)range.upperBoundType());
            }
            if (range.hasLowerBound()) {
                return Range.downTo((Comparable)((Comparable)SillyStructureWithIdRepository.wrapMarshalable(range.lowerEndpoint())), (BoundType)range.lowerBoundType());
            }
            if (range.hasUpperBound()) {
                return Range.upTo((Comparable)((Comparable)SillyStructureWithIdRepository.wrapMarshalable(range.upperEndpoint())), (BoundType)range.upperBoundType());
            }
            throw new AssertionError();
        }

        @Override
        public InternalCriteria flag2(boolean value) {
            return new InternalCriteria(this.constraint.equal("flag2", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria opt3(int value) {
            return new InternalCriteria(this.constraint.equal("opt3", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria opt3Not(int value) {
            return new InternalCriteria(this.constraint.equal("opt3", true, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria opt3In(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("opt3", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria opt3In(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (int value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("opt3", false, (Iterable)values));
        }

        @Override
        public InternalCriteria opt3NotIn(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("opt3", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria opt3NotIn(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (int value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("opt3", true, (Iterable)values));
        }

        @Override
        public InternalCriteria opt3Present() {
            return new InternalCriteria(this.constraint.present("opt3", false));
        }

        @Override
        public InternalCriteria opt3Absent() {
            return new InternalCriteria(this.constraint.present("opt3", true));
        }

        @Override
        public InternalCriteria very4(long value) {
            return new InternalCriteria(this.constraint.equal("very4", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria very4Not(long value) {
            return new InternalCriteria(this.constraint.equal("very4", true, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria very4In(Iterable<Long> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Long v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("very4", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria very4In(long first, long second, long ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (long value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("very4", false, (Iterable)values));
        }

        @Override
        public InternalCriteria very4NotIn(Iterable<Long> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Long v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("very4", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria very4NotIn(long first, long second, long ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (long value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("very4", true, (Iterable)values));
        }

        @Override
        public InternalCriteria wet5(double value) {
            return new InternalCriteria(this.constraint.equal("wet5", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria wet5Not(double value) {
            return new InternalCriteria(this.constraint.equal("wet5", true, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria wet5In(Iterable<Double> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Double v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("wet5", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria wet5In(double first, double second, double ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (double value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("wet5", false, (Iterable)values));
        }

        @Override
        public InternalCriteria wet5NotIn(Iterable<Double> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Double v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("wet5", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria wet5NotIn(double first, double second, double ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (double value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("wet5", true, (Iterable)values));
        }

        @Override
        public InternalCriteria subs6Empty() {
            return new InternalCriteria(this.constraint.size("subs6", false, 0));
        }

        @Override
        public InternalCriteria subs6NonEmpty() {
            return new InternalCriteria(this.constraint.size("subs6", true, 0));
        }

        @Override
        public InternalCriteria subs6Size(int size) {
            return new InternalCriteria(this.constraint.size("subs6", false, size));
        }

        @Override
        public InternalCriteria subs6Contains(SillySubstructure value) {
            return new InternalCriteria(this.constraint.equal("subs6", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria subs6ContainsAll(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.nested("subs6", (ConstraintSupport.ConstraintHost)ConstraintSupport.nilConstraint().equal("$all", false, (Object)wrappedValues)));
        }

        @Override
        public InternalCriteria nest7(SillySubstructure value) {
            return new InternalCriteria(this.constraint.equal("nest7", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria nest7Not(SillySubstructure value) {
            return new InternalCriteria(this.constraint.equal("nest7", true, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria nest7In(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("nest7", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria nest7In(SillySubstructure first, SillySubstructure second, SillySubstructure ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (SillySubstructure value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("nest7", false, (Iterable)values));
        }

        @Override
        public InternalCriteria nest7NotIn(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("nest7", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria nest7NotIn(SillySubstructure first, SillySubstructure second, SillySubstructure ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (SillySubstructure value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("nest7", true, (Iterable)values));
        }

        @Override
        public InternalCriteria tup3(SillyTuplie value) {
            return new InternalCriteria(this.constraint.equal("tup3", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria tup3Not(SillyTuplie value) {
            return new InternalCriteria(this.constraint.equal("tup3", true, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria tup3In(Iterable<SillyTuplie> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillyTuplie v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("tup3", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria tup3In(SillyTuplie first, SillyTuplie second, SillyTuplie ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (SillyTuplie value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("tup3", false, (Iterable)values));
        }

        @Override
        public InternalCriteria tup3NotIn(Iterable<SillyTuplie> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillyTuplie v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("tup3", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria tup3NotIn(SillyTuplie first, SillyTuplie second, SillyTuplie ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (SillyTuplie value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("tup3", true, (Iterable)values));
        }

        @Override
        public InternalCriteria tup3Present() {
            return new InternalCriteria(this.constraint.present("tup3", false));
        }

        @Override
        public InternalCriteria tup3Absent() {
            return new InternalCriteria(this.constraint.present("tup3", true));
        }

        @Override
        public InternalCriteria int9(int value) {
            return new InternalCriteria(this.constraint.equal("int9", false, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria int9Not(int value) {
            return new InternalCriteria(this.constraint.equal("int9", true, SillyStructureWithIdRepository.wrapMarshalable(value)));
        }

        @Override
        public InternalCriteria int9In(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("int9", false, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria int9In(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (int value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("int9", false, (Iterable)values));
        }

        @Override
        public InternalCriteria int9NotIn(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            return new InternalCriteria(this.constraint.in("int9", true, (Iterable)wrappedValues));
        }

        @Override
        public InternalCriteria int9NotIn(int first, int second, int ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(first));
            values.add(SillyStructureWithIdRepository.wrapMarshalable(second));
            for (int value : rest) {
                values.add(SillyStructureWithIdRepository.wrapMarshalable(value));
            }
            return new InternalCriteria(this.constraint.in("int9", true, (Iterable)values));
        }

        @Override
        public InternalCriteria or() {
            return new InternalCriteria(this.constraint.disjunction());
        }

        public String toString() {
            return "SillyStructureWithIdRepository.where(" + RepositorySupport.stringify((ConstraintSupport.ConstraintHost)this) + ")";
        }
    }

    @Immutable
    public static abstract class Criteria
    extends Repositories.Criteria {
        Criteria() {
        }

        public abstract Criteria id(String var1);

        public abstract Criteria idNot(String var1);

        public abstract Criteria idIn(Iterable<String> var1);

        public abstract Criteria idIn(String var1, String var2, String ... var3);

        public abstract Criteria idNotIn(Iterable<String> var1);

        public abstract Criteria idNotIn(String var1, String var2, String ... var3);

        public abstract Criteria idStartsWith(String var1);

        public abstract Criteria idMatches(Pattern var1);

        public abstract Criteria idNotMatches(Pattern var1);

        public abstract Criteria idGreaterThan(String var1);

        public abstract Criteria idLessThan(String var1);

        public abstract Criteria idAtMost(String var1);

        public abstract Criteria idAtLeast(String var1);

        public abstract Criteria idIn(Range<String> var1);

        public abstract Criteria idNotIn(Range<String> var1);

        public abstract Criteria attr1(String var1);

        public abstract Criteria attr1Not(String var1);

        public abstract Criteria attr1In(Iterable<String> var1);

        public abstract Criteria attr1In(String var1, String var2, String ... var3);

        public abstract Criteria attr1NotIn(Iterable<String> var1);

        public abstract Criteria attr1NotIn(String var1, String var2, String ... var3);

        public abstract Criteria attr1StartsWith(String var1);

        public abstract Criteria attr1Matches(Pattern var1);

        public abstract Criteria attr1NotMatches(Pattern var1);

        public abstract Criteria attr1GreaterThan(String var1);

        public abstract Criteria attr1LessThan(String var1);

        public abstract Criteria attr1AtMost(String var1);

        public abstract Criteria attr1AtLeast(String var1);

        public abstract Criteria attr1In(Range<String> var1);

        public abstract Criteria attr1NotIn(Range<String> var1);

        public abstract Criteria flag2(boolean var1);

        public abstract Criteria opt3(int var1);

        public abstract Criteria opt3Not(int var1);

        public abstract Criteria opt3In(Iterable<Integer> var1);

        public abstract Criteria opt3In(int var1, int var2, int ... var3);

        public abstract Criteria opt3NotIn(Iterable<Integer> var1);

        public abstract Criteria opt3NotIn(int var1, int var2, int ... var3);

        public abstract Criteria opt3Present();

        public abstract Criteria opt3Absent();

        public abstract Criteria very4(long var1);

        public abstract Criteria very4Not(long var1);

        public abstract Criteria very4In(Iterable<Long> var1);

        public abstract Criteria very4In(long var1, long var3, long ... var5);

        public abstract Criteria very4NotIn(Iterable<Long> var1);

        public abstract Criteria very4NotIn(long var1, long var3, long ... var5);

        public abstract Criteria wet5(double var1);

        public abstract Criteria wet5Not(double var1);

        public abstract Criteria wet5In(Iterable<Double> var1);

        public abstract Criteria wet5In(double var1, double var3, double ... var5);

        public abstract Criteria wet5NotIn(Iterable<Double> var1);

        public abstract Criteria wet5NotIn(double var1, double var3, double ... var5);

        public abstract Criteria subs6Empty();

        public abstract Criteria subs6NonEmpty();

        public abstract Criteria subs6Size(int var1);

        public abstract Criteria subs6Contains(SillySubstructure var1);

        public abstract Criteria subs6ContainsAll(Iterable<SillySubstructure> var1);

        public abstract Criteria nest7(SillySubstructure var1);

        public abstract Criteria nest7Not(SillySubstructure var1);

        public abstract Criteria nest7In(Iterable<SillySubstructure> var1);

        public abstract Criteria nest7In(SillySubstructure var1, SillySubstructure var2, SillySubstructure ... var3);

        public abstract Criteria nest7NotIn(Iterable<SillySubstructure> var1);

        public abstract Criteria nest7NotIn(SillySubstructure var1, SillySubstructure var2, SillySubstructure ... var3);

        public abstract Criteria tup3(SillyTuplie var1);

        public abstract Criteria tup3Not(SillyTuplie var1);

        public abstract Criteria tup3In(Iterable<SillyTuplie> var1);

        public abstract Criteria tup3In(SillyTuplie var1, SillyTuplie var2, SillyTuplie ... var3);

        public abstract Criteria tup3NotIn(Iterable<SillyTuplie> var1);

        public abstract Criteria tup3NotIn(SillyTuplie var1, SillyTuplie var2, SillyTuplie ... var3);

        public abstract Criteria tup3Present();

        public abstract Criteria tup3Absent();

        public abstract Criteria int9(int var1);

        public abstract Criteria int9Not(int var1);

        public abstract Criteria int9In(Iterable<Integer> var1);

        public abstract Criteria int9In(int var1, int var2, int ... var3);

        public abstract Criteria int9NotIn(Iterable<Integer> var1);

        public abstract Criteria int9NotIn(int var1, int var2, int ... var3);

        public abstract Criteria or();
    }

    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<SillyStructureWithId, Indexer> {
        private Indexer(SillyStructureWithIdRepository repository) {
            super((Repositories.Repository)repository);
        }

        public Indexer withId() {
            this.fields = this.fields.equal("_id", false, (Object)1);
            return this;
        }

        public Indexer withIdDesceding() {
            this.fields = this.fields.equal("_id", false, (Object)-1);
            return this;
        }

        public Indexer withAttr1() {
            this.fields = this.fields.equal("attr1", false, (Object)1);
            return this;
        }

        public Indexer withAttr1Desceding() {
            this.fields = this.fields.equal("attr1", false, (Object)-1);
            return this;
        }

        public Indexer withFlag2() {
            this.fields = this.fields.equal("flag2", false, (Object)1);
            return this;
        }

        public Indexer withFlag2Desceding() {
            this.fields = this.fields.equal("flag2", false, (Object)-1);
            return this;
        }

        public Indexer withOpt3() {
            this.fields = this.fields.equal("opt3", false, (Object)1);
            return this;
        }

        public Indexer withOpt3Desceding() {
            this.fields = this.fields.equal("opt3", false, (Object)-1);
            return this;
        }

        public Indexer withVery4() {
            this.fields = this.fields.equal("very4", false, (Object)1);
            return this;
        }

        public Indexer withVery4Desceding() {
            this.fields = this.fields.equal("very4", false, (Object)-1);
            return this;
        }

        public Indexer withWet5() {
            this.fields = this.fields.equal("wet5", false, (Object)1);
            return this;
        }

        public Indexer withWet5Desceding() {
            this.fields = this.fields.equal("wet5", false, (Object)-1);
            return this;
        }

        public Indexer withSubs6() {
            this.fields = this.fields.equal("subs6", false, (Object)1);
            return this;
        }

        public Indexer withSubs6Desceding() {
            this.fields = this.fields.equal("subs6", false, (Object)-1);
            return this;
        }

        public Indexer withNest7() {
            this.fields = this.fields.equal("nest7", false, (Object)1);
            return this;
        }

        public Indexer withNest7Desceding() {
            this.fields = this.fields.equal("nest7", false, (Object)-1);
            return this;
        }

        public Indexer withTup3() {
            this.fields = this.fields.equal("tup3", false, (Object)1);
            return this;
        }

        public Indexer withTup3Desceding() {
            this.fields = this.fields.equal("tup3", false, (Object)-1);
            return this;
        }

        public Indexer withInt9() {
            this.fields = this.fields.equal("int9", false, (Object)1);
            return this;
        }

        public Indexer withInt9Desceding() {
            this.fields = this.fields.equal("int9", false, (Object)-1);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<SillyStructureWithId, Modifier> {
        private Modifier(Repositories.Repository<SillyStructureWithId> repository, ConstraintSupport.ConstraintHost criteria, ConstraintSupport.Constraint ordering, ConstraintSupport.Constraint exclusion) {
            super(repository);
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setAttr1(String value) {
            this.setFields = this.setFields.equal("attr1", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initAttr1(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("attr1", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier setFlag2(boolean value) {
            this.setFields = this.setFields.equal("flag2", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initFlag2(boolean value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("flag2", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier clearOpt3() {
            this.unsetFields = this.unsetFields.equal("opt3", false, (Object)1);
            return this;
        }

        public Modifier setOpt3(int value) {
            this.setFields = this.setFields.equal("opt3", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initOpt3(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("opt3", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier setVery4(long value) {
            this.setFields = this.setFields.equal("very4", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initVery4(long value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("very4", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier incrementVery4(long increment) {
            this.incrementFields = this.incrementFields.equal("very4", false, (Object)increment);
            return this;
        }

        public Modifier setWet5(double value) {
            this.setFields = this.setFields.equal("wet5", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initWet5(double value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("wet5", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier incrementWet5(double increment) {
            this.incrementFields = this.incrementFields.equal("wet5", false, (Object)increment);
            return this;
        }

        public Modifier clearSubs6() {
            this.unsetFields = this.unsetFields.equal("subs6", false, (Object)1);
            return this;
        }

        public Modifier removeSubs6(SillySubstructure value) {
            this.pullFields = this.pullFields.equal("subs6", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier addSubs6(SillySubstructure value) {
            this.pushFields = this.pushFields.equal("subs6", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier addAllSubs6(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : RepositorySupport.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal("subs6", false, v);
            return this;
        }

        public Modifier setNest7(SillySubstructure value) {
            this.setFields = this.setFields.equal("nest7", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initNest7(SillySubstructure value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("nest7", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier clearTup3() {
            this.unsetFields = this.unsetFields.equal("tup3", false, (Object)1);
            return this;
        }

        public Modifier setTup3(SillyTuplie value) {
            this.setFields = this.setFields.equal("tup3", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initTup3(SillyTuplie value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("tup3", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier setInt9(int value) {
            this.setFields = this.setFields.equal("int9", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier initInt9(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("int9", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Modifier incrementInt9(int increment) {
            this.incrementFields = this.incrementFields.equal("int9", false, (Object)increment);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<SillyStructureWithId> {
        private Updater(SillyStructureWithIdRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = (ConstraintSupport.ConstraintHost)criteria;
        }

        public Updater setAttr1(String value) {
            this.setFields = this.setFields.equal("attr1", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initAttr1(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("attr1", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater setFlag2(boolean value) {
            this.setFields = this.setFields.equal("flag2", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initFlag2(boolean value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("flag2", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater clearOpt3() {
            this.unsetFields = this.unsetFields.equal("opt3", false, (Object)1);
            return this;
        }

        public Updater setOpt3(int value) {
            this.setFields = this.setFields.equal("opt3", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initOpt3(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("opt3", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater setVery4(long value) {
            this.setFields = this.setFields.equal("very4", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initVery4(long value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("very4", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater incrementVery4(long increment) {
            this.incrementFields = this.incrementFields.equal("very4", false, (Object)increment);
            return this;
        }

        public Updater setWet5(double value) {
            this.setFields = this.setFields.equal("wet5", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initWet5(double value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("wet5", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater incrementWet5(double increment) {
            this.incrementFields = this.incrementFields.equal("wet5", false, (Object)increment);
            return this;
        }

        public Updater clearSubs6() {
            this.unsetFields = this.unsetFields.equal("subs6", false, (Object)1);
            return this;
        }

        public Updater removeSubs6(SillySubstructure value) {
            this.pullFields = this.pullFields.equal("subs6", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater addSubs6(SillySubstructure value) {
            this.pushFields = this.pushFields.equal("subs6", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater addAllSubs6(Iterable<SillySubstructure> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (SillySubstructure v : values) {
                wrappedValues.add(SillyStructureWithIdRepository.wrapMarshalable(v));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : RepositorySupport.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal("subs6", false, v);
            return this;
        }

        public Updater setNest7(SillySubstructure value) {
            this.setFields = this.setFields.equal("nest7", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initNest7(SillySubstructure value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("nest7", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater clearTup3() {
            this.unsetFields = this.unsetFields.equal("tup3", false, (Object)1);
            return this;
        }

        public Updater setTup3(SillyTuplie value) {
            this.setFields = this.setFields.equal("tup3", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initTup3(SillyTuplie value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("tup3", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater setInt9(int value) {
            this.setFields = this.setFields.equal("int9", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater initInt9(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal("int9", false, SillyStructureWithIdRepository.wrapMarshalable(value));
            return this;
        }

        public Updater incrementInt9(int increment) {
            this.incrementFields = this.incrementFields.equal("int9", false, (Object)increment);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Finder
    extends Repositories.Finder<SillyStructureWithId, Finder> {
        private Finder(SillyStructureWithIdRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = (ConstraintSupport.ConstraintHost)criteria;
        }

        public Finder orderById() {
            this.ordering = this.ordering.equal("_id", false, (Object)1);
            return this;
        }

        public Finder orderByIdDesceding() {
            this.ordering = this.ordering.equal("_id", false, (Object)-1);
            return this;
        }

        public Finder orderByAttr1() {
            this.ordering = this.ordering.equal("attr1", false, (Object)1);
            return this;
        }

        public Finder orderByAttr1Desceding() {
            this.ordering = this.ordering.equal("attr1", false, (Object)-1);
            return this;
        }

        public Finder orderByFlag2() {
            this.ordering = this.ordering.equal("flag2", false, (Object)1);
            return this;
        }

        public Finder orderByFlag2Desceding() {
            this.ordering = this.ordering.equal("flag2", false, (Object)-1);
            return this;
        }

        public Finder orderByOpt3() {
            this.ordering = this.ordering.equal("opt3", false, (Object)1);
            return this;
        }

        public Finder orderByOpt3Desceding() {
            this.ordering = this.ordering.equal("opt3", false, (Object)-1);
            return this;
        }

        public Finder orderByVery4() {
            this.ordering = this.ordering.equal("very4", false, (Object)1);
            return this;
        }

        public Finder orderByVery4Desceding() {
            this.ordering = this.ordering.equal("very4", false, (Object)-1);
            return this;
        }

        public Finder orderByWet5() {
            this.ordering = this.ordering.equal("wet5", false, (Object)1);
            return this;
        }

        public Finder orderByWet5Desceding() {
            this.ordering = this.ordering.equal("wet5", false, (Object)-1);
            return this;
        }

        public Finder orderBySubs6() {
            this.ordering = this.ordering.equal("subs6", false, (Object)1);
            return this;
        }

        public Finder orderBySubs6Desceding() {
            this.ordering = this.ordering.equal("subs6", false, (Object)-1);
            return this;
        }

        public Finder orderByNest7() {
            this.ordering = this.ordering.equal("nest7", false, (Object)1);
            return this;
        }

        public Finder orderByNest7Desceding() {
            this.ordering = this.ordering.equal("nest7", false, (Object)-1);
            return this;
        }

        public Finder orderByTup3() {
            this.ordering = this.ordering.equal("tup3", false, (Object)1);
            return this;
        }

        public Finder orderByTup3Desceding() {
            this.ordering = this.ordering.equal("tup3", false, (Object)-1);
            return this;
        }

        public Finder orderByInt9() {
            this.ordering = this.ordering.equal("int9", false, (Object)1);
            return this;
        }

        public Finder orderByInt9Desceding() {
            this.ordering = this.ordering.equal("int9", false, (Object)-1);
            return this;
        }

        public Finder excludeOpt3() {
            this.exclusion = this.exclusion.equal("opt3", false, (Object)-1);
            return this;
        }

        public Finder excludeSubs6() {
            this.exclusion = this.exclusion.equal("subs6", false, (Object)-1);
            return this;
        }

        public Finder excludeTup3() {
            this.exclusion = this.exclusion.equal("tup3", false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier(this.repository, this.criteria, this.ordering, this.exclusion);
        }
    }
}

