/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.service;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.service.SillyConfig;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSillyConfig
extends SillyConfig {
    private final String param1;
    private final int param2;

    private static ImmutableSillyConfig checkPreconditions(ImmutableSillyConfig instance) {
        return instance;
    }

    private ImmutableSillyConfig(Builder builder) {
        this.param1 = builder.param1;
        this.param2 = builder.param2;
    }

    @Override
    public String param1() {
        return this.param1;
    }

    @Override
    public int param2() {
        return this.param2;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof ImmutableSillyConfig && this.equalTo((ImmutableSillyConfig)another);
    }

    private boolean equalTo(ImmutableSillyConfig another) {
        return this.param1.equals(another.param1) && this.param2 == another.param2;
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.param1.hashCode();
        h = h * 17 + this.param2;
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((String)"SillyConfig").add("param1", (Object)this.param1).add("param2", this.param2).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build SillyConfig: required attribute '%s' is not set";
        @Nullable
        private String param1;
        private int param2;
        private boolean param2IsSet;

        private Builder() {
        }

        public Builder copy(SillyConfig fromInstance) {
            Preconditions.checkNotNull((Object)fromInstance);
            this.param1(fromInstance.param1());
            this.param2(fromInstance.param2());
            return this;
        }

        public Builder param1(String param1) {
            this.param1 = (String)Preconditions.checkNotNull((Object)param1);
            return this;
        }

        public Builder param2(int param2) {
            this.param2 = param2;
            this.param2IsSet = true;
            return this;
        }

        public ImmutableSillyConfig build() {
            Preconditions.checkState((this.param1 != null ? 1 : 0) != 0, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"param1"});
            Preconditions.checkState((boolean)this.param2IsSet, (String)REQUIRED_ATTRIBUTE, (Object[])new Object[]{"param2"});
            return ImmutableSillyConfig.checkPreconditions(new ImmutableSillyConfig(this));
        }
    }
}

