/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.service;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.common.marshal.internal.BuiltinMarshalingRoutines;
import org.immutables.common.marshal.internal.MarshalingSupport;
import org.immutables.service.ImmutableSillyConfig;
import org.immutables.service.SillyConfig;

@ParametersAreNonnullByDefault
final class InternalSillyConfigMarshaling {
    private InternalSillyConfigMarshaling() {
    }

    static void marshalIterableOfSillyConfig(JsonGenerator generator, Iterable<SillyConfig> iterable) throws IOException {
        generator.writeStartArray();
        for (SillyConfig instance : iterable) {
            InternalSillyConfigMarshaling.marshalSillyConfig(generator, instance);
        }
        generator.writeEndArray();
    }

    static void marshalSillyConfig(JsonGenerator generator, SillyConfig instance) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("param1");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (Object)instance.param1());
        generator.writeFieldName("param2");
        BuiltinMarshalingRoutines.marshal((JsonGenerator)generator, (int)instance.param2());
        generator.writeEndObject();
    }

    private static void ensure(boolean condition, String attributeName, String attributeType, Object message) {
        MarshalingSupport.ensureCondition((boolean)condition, (String)"SillyConfig", (String)attributeName, (String)attributeType, (Object)message);
    }

    static Iterable<SillyConfig> unmarshalIterableOfSillyConfig(JsonParser parser) throws IOException {
        ArrayList result = Lists.newArrayList();
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyConfigMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                parser.nextToken();
                result.add(InternalSillyConfigMarshaling.unmarshalSillyConfig(parser));
            }
        } else {
            InternalSillyConfigMarshaling.ensure(t == JsonToken.START_ARRAY, "*", "List<SillyConfig>", t);
            while ((t = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(InternalSillyConfigMarshaling.unmarshalSillyConfig(parser));
            }
        }
        return result;
    }

    static SillyConfig unmarshalSillyConfig(JsonParser parser) throws IOException {
        ImmutableSillyConfig.Builder builder = ImmutableSillyConfig.builder();
        String attributeName = "";
        try {
            JsonToken t = parser.getCurrentToken();
            InternalSillyConfigMarshaling.ensure(t == JsonToken.START_OBJECT, "new {", "", t);
            while ((t = parser.nextToken()) != JsonToken.END_OBJECT) {
                InternalSillyConfigMarshaling.ensure(t == JsonToken.FIELD_NAME, "*", "", t);
                attributeName = parser.getText();
                InternalSillyConfigMarshaling.unmarshalAttribute(parser, builder, attributeName);
            }
        }
        catch (JsonParseException jsonParse) {
            InternalSillyConfigMarshaling.ensure(false, attributeName, "?", jsonParse.getMessage());
        }
        return builder.build();
    }

    private static void unmarshalAttribute(JsonParser parser, ImmutableSillyConfig.Builder builder, String attributeName) throws IOException {
        switch (attributeName) {
            case "param1": {
                InternalSillyConfigMarshaling.unmarshalAttributeParam1(parser, builder);
                break;
            }
            case "param2": {
                InternalSillyConfigMarshaling.unmarshalAttributeParam2(parser, builder);
                break;
            }
            default: {
                InternalSillyConfigMarshaling.unmarshalUnknownAttribute(parser, attributeName);
            }
        }
    }

    private static void unmarshalUnknownAttribute(JsonParser parser, String attributeName) throws IOException {
        JsonToken t = parser.nextToken();
        if (!t.isScalarValue()) {
            parser.skipChildren();
        }
    }

    private static void unmarshalAttributeParam1(JsonParser parser, ImmutableSillyConfig.Builder builder) throws IOException {
        JsonToken t = parser.nextToken();
        String value = BuiltinMarshalingRoutines.unmarshal((JsonParser)parser, (String)null, String.class);
        builder.param1(value);
    }

    private static void unmarshalAttributeParam2(JsonParser parser, ImmutableSillyConfig.Builder builder) throws IOException {
        InternalSillyConfigMarshaling.ensure(parser.nextToken().isScalarValue(), "param2", "int", parser.getCurrentToken());
        builder.param2(parser.getIntValue());
    }
}

