/*
 * Decompiled with CFR 0.152.
 */
package org.imsglobal.aspect;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.imsglobal.aspect.Lti;
import org.imsglobal.aspect.LtiKeySecretService;
import org.imsglobal.lti.launch.LtiVerificationResult;
import org.imsglobal.lti.launch.LtiVerifier;

@Aspect
public class LtiLaunchVerifier {
    public LtiKeySecretService keyService;
    public LtiVerifier ltiVerifier;

    public LtiLaunchVerifier(LtiKeySecretService keyService, LtiVerifier ltiVerifier) {
        this.keyService = keyService;
        this.ltiVerifier = ltiVerifier;
    }

    @Around(value="@annotation(launch)")
    public Object verifyLtiLaunch(ProceedingJoinPoint pjp, Lti launch) throws Throwable {
        HttpServletRequest request = null;
        for (Object arg : pjp.getArgs()) {
            if (!HttpServletRequest.class.isInstance(arg)) continue;
            request = (HttpServletRequest)arg;
        }
        if (request == null) {
            throw new IllegalStateException(this.getErrorMessageForArgumentClass("HttpServletRequest", pjp.getSignature().toLongString()));
        }
        String oauthSecret = this.keyService.getSecretForKey(request.getParameter("oauth_consumer_key"));
        LtiVerificationResult ltiResult = this.ltiVerifier.verify(request, oauthSecret);
        Boolean ltiVerificationResultExists = false;
        ArrayList<Object> args = new ArrayList<Object>(pjp.getArgs().length);
        for (Object arg : pjp.getArgs()) {
            if (arg.getClass().equals(LtiVerificationResult.class)) {
                args.add(ltiResult);
                ltiVerificationResultExists = true;
                continue;
            }
            args.add(arg);
        }
        if (!ltiVerificationResultExists.booleanValue()) {
            throw new IllegalStateException(this.getErrorMessageForArgumentClass("LtiVerificationResult", pjp.getSignature().toLongString()));
        }
        return pjp.proceed(args.toArray());
    }

    public String getErrorMessageForArgumentClass(String argumentClass, String signature) {
        return "The LtiLaunchVerifier instance cannot find the " + argumentClass + " argument on method: " + signature + ", are you sure it was declared?";
    }
}

