/*
 * Decompiled with CFR 0.152.
 */
package org.imsglobal.lti.launch;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import org.apache.http.HttpRequest;
import org.imsglobal.lti.launch.LtiSigner;
import org.imsglobal.lti.launch.LtiSigningException;

public class LtiOauthSigner
implements LtiSigner {
    @Override
    public HttpRequest sign(HttpRequest request, String key, String secret) throws LtiSigningException {
        CommonsHttpOAuthConsumer signer = new CommonsHttpOAuthConsumer(key, secret);
        try {
            signer.sign((Object)request);
        }
        catch (OAuthCommunicationException | OAuthExpectationFailedException | OAuthMessageSignerException e) {
            throw new LtiSigningException("Exception encountered while singing Lti request...", (Exception)e);
        }
        return request;
    }

    @Override
    public Map<String, String> signParameters(Map<String, String> parameters, String key, String secret, String url, String method) throws LtiSigningException {
        OAuthMessage oam = new OAuthMessage(method, url, parameters.entrySet());
        OAuthConsumer cons = new OAuthConsumer(null, key, secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            oam.addRequiredParameters(acc);
            HashMap<String, String> signedParameters = new HashMap<String, String>();
            for (Map.Entry param : oam.getParameters()) {
                signedParameters.put((String)param.getKey(), (String)param.getValue());
            }
            return signedParameters;
        }
        catch (IOException | URISyntaxException | OAuthException e) {
            throw new LtiSigningException("Error signing LTI request.", (Exception)e);
        }
    }
}

