/*
 * Decompiled with CFR 0.152.
 */
package org.imsglobal.lti2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.imsglobal.lti.BasicLTIUtil;
import org.imsglobal.lti2.objects.consumer.ServiceOffered;
import org.imsglobal.lti2.objects.consumer.ToolConsumer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class LTI2Util {
    private static Logger M_log = Logger.getLogger(LTI2Util.class.toString());
    public static final String SCOPE_LtiLink = "LtiLink";
    public static final String SCOPE_ToolProxyBinding = "ToolProxyBinding";
    public static final String SCOPE_ToolProxy = "ToolProxy";
    private static final String EMPTY_JSON_OBJECT = "{\n}\n";

    public static String validateServices(ToolConsumer consumer, JSONObject providerProfile) {
        try {
            JSONObject security_contract = (JSONObject)providerProfile.get((Object)"security_contract");
            if (security_contract == null) {
                return "JSON missing security_contract";
            }
            JSONArray tool_services = (JSONArray)security_contract.get((Object)"tool_service");
            List<ServiceOffered> services_offered = consumer.getService_offered();
            if (tool_services != null) {
                for (Object o : tool_services) {
                    JSONObject tool_service = (JSONObject)o;
                    String json_service = (String)tool_service.get((Object)"service");
                    boolean found = false;
                    for (ServiceOffered service : services_offered) {
                        String service_endpoint = service.getEndpoint();
                        if (!service_endpoint.equals(json_service)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return "Service not allowed: " + json_service;
                }
            }
            return null;
        }
        catch (Exception e) {
            return "Exception:" + e.getLocalizedMessage();
        }
    }

    public static String validateCapabilities(ToolConsumer consumer, JSONObject providerProfile) {
        ArrayList<Properties> theTools = new ArrayList<Properties>();
        Properties info = new Properties();
        try {
            String retval = LTI2Util.parseToolProfile(theTools, info, providerProfile);
            if (retval != null) {
                return retval;
            }
            if (theTools.size() < 1) {
                return "No tools found in profile";
            }
            List<String> capabilities = consumer.getCapability_offered();
            for (Properties theTool : theTools) {
                String ec = (String)theTool.get("enabled_capability");
                JSONArray enabled_capability = (JSONArray)JSONValue.parse((String)ec);
                if (enabled_capability == null) continue;
                for (Object o : enabled_capability) {
                    ec = (String)o;
                    if (capabilities.contains(ec)) continue;
                    return "Capability not permitted=" + ec;
                }
            }
            return null;
        }
        catch (Exception e) {
            return "Exception:" + e.getLocalizedMessage();
        }
    }

    public static void allowEmail(List<String> capabilities) {
        capabilities.add("Person.email.primary");
    }

    public static void allowName(List<String> capabilities) {
        capabilities.add("User.username");
        capabilities.add("Person.name.fullname");
        capabilities.add("Person.name.given");
        capabilities.add("Person.name.family");
        capabilities.add("Person.name.full");
    }

    public static void allowResult(List<String> capabilities) {
        capabilities.add("Result.sourcedId");
        capabilities.add("Result.autocreate");
        capabilities.add("Result.url");
    }

    public static void allowSettings(List<String> capabilities) {
        capabilities.add("LtiLink.custom.url");
        capabilities.add("ToolProxy.custom.url");
        capabilities.add("ToolProxyBinding.custom.url");
    }

    public static Object getSettings(HttpServletRequest request, String scope, JSONObject link_settings, JSONObject binding_settings, JSONObject proxy_settings, String link_url, String binding_url, String proxy_url) {
        boolean acceptComplex;
        String bubbleStr = request.getParameter("bubble");
        String acceptHdr = request.getHeader("Accept");
        String contentHdr = request.getContentType();
        if (bubbleStr != null && bubbleStr.equals("all") && acceptHdr.indexOf("application/vnd.ims.lti.v2.toolsettings+json") < 0) {
            return "Simple format does not allow bubble=all";
        }
        if (!(SCOPE_LtiLink.equals(scope) || SCOPE_ToolProxyBinding.equals(scope) || SCOPE_ToolProxy.equals(scope))) {
            return "Bad Setttings Scope=" + scope;
        }
        boolean bubble = bubbleStr != null && "GET".equals(request.getMethod());
        boolean distinct = bubbleStr != null && "distinct".equals(bubbleStr);
        boolean bubbleAll = bubbleStr != null && "all".equals(bubbleStr);
        boolean bl = acceptComplex = acceptHdr == null || acceptHdr.indexOf("application/vnd.ims.lti.v2.toolsettings+json") >= 0;
        if (distinct && link_settings != null && scope.equals(SCOPE_LtiLink)) {
            for (String key : link_settings.keySet()) {
                if (binding_settings != null) {
                    binding_settings.remove((Object)key);
                }
                if (proxy_settings == null) continue;
                proxy_settings.remove((Object)key);
            }
        }
        if (distinct && binding_settings != null && scope.equals(SCOPE_ToolProxyBinding)) {
            for (String key : binding_settings.keySet()) {
                if (proxy_settings == null) continue;
                proxy_settings.remove((Object)key);
            }
        }
        JSONObject jsonResponse = null;
        if ((distinct || bubbleAll) && acceptComplex) {
            JSONObject cjson;
            jsonResponse = new JSONObject();
            jsonResponse.put((Object)"@context", (Object)"http://purl.imsglobal.org/ctx/lti/v2/ToolSettings");
            JSONArray graph = new JSONArray();
            boolean started = false;
            if (link_settings != null && SCOPE_LtiLink.equals(scope)) {
                cjson = new JSONObject();
                cjson.put((Object)"@id", (Object)link_url);
                cjson.put((Object)"@type", (Object)SCOPE_LtiLink);
                cjson.put((Object)"custom", (Object)link_settings);
                graph.add((Object)cjson);
                started = true;
            }
            if (binding_settings != null && (started || SCOPE_ToolProxyBinding.equals(scope))) {
                cjson = new JSONObject();
                cjson.put((Object)"@id", (Object)binding_url);
                cjson.put((Object)"@type", (Object)SCOPE_ToolProxyBinding);
                cjson.put((Object)"custom", (Object)binding_settings);
                graph.add((Object)cjson);
                started = true;
            }
            if (proxy_settings != null && (started || SCOPE_ToolProxy.equals(scope))) {
                cjson = new JSONObject();
                cjson.put((Object)"@id", (Object)proxy_url);
                cjson.put((Object)"@type", (Object)SCOPE_ToolProxy);
                cjson.put((Object)"custom", (Object)proxy_settings);
                graph.add((Object)cjson);
            }
            jsonResponse.put((Object)"@graph", (Object)graph);
        } else if (distinct) {
            jsonResponse = proxy_settings;
            if (SCOPE_LtiLink.equals(scope)) {
                jsonResponse.putAll((Map)binding_settings);
                jsonResponse.putAll((Map)link_settings);
            } else if (SCOPE_ToolProxyBinding.equals(scope)) {
                jsonResponse.putAll((Map)binding_settings);
            }
        } else {
            jsonResponse = new JSONObject();
            jsonResponse.put((Object)"@context", (Object)"http://purl.imsglobal.org/ctx/lti/v2/ToolSettings");
            JSONObject theSettings = null;
            String endpoint = null;
            if (SCOPE_LtiLink.equals(scope)) {
                endpoint = link_url;
                theSettings = link_settings;
            } else if (SCOPE_ToolProxyBinding.equals(scope)) {
                endpoint = binding_url;
                theSettings = binding_settings;
            }
            if (SCOPE_ToolProxy.equals(scope)) {
                endpoint = proxy_url;
                theSettings = proxy_settings;
            }
            if (acceptComplex) {
                JSONArray graph = new JSONArray();
                JSONObject cjson = new JSONObject();
                cjson.put((Object)"@id", (Object)endpoint);
                cjson.put((Object)"@type", (Object)scope);
                cjson.put((Object)"custom", (Object)theSettings);
                graph.add((Object)cjson);
                jsonResponse.put((Object)"@graph", (Object)graph);
            } else {
                jsonResponse = theSettings;
            }
        }
        return jsonResponse;
    }

    public static String parseToolProfile(List<Properties> theTools, Properties info, JSONObject jsonObject) {
        try {
            return LTI2Util.parseToolProfileInternal(theTools, info, jsonObject);
        }
        catch (Exception e) {
            M_log.warning("Internal error parsing tool proxy\n" + jsonObject.toString());
            e.printStackTrace();
            return "Internal error parsing tool proxy:" + e.getLocalizedMessage();
        }
    }

    private static String parseToolProfileInternal(List<Properties> theTools, Properties info, JSONObject jsonObject) {
        String vendorCode;
        Object o = null;
        JSONObject tool_profile = (JSONObject)jsonObject.get((Object)"tool_profile");
        if (tool_profile == null) {
            return "JSON missing tool_profile";
        }
        JSONObject product_instance = (JSONObject)tool_profile.get((Object)"product_instance");
        if (product_instance == null) {
            return "JSON missing product_instance";
        }
        String instance_guid = (String)product_instance.get((Object)"guid");
        if (instance_guid == null) {
            return "JSON missing product_info / guid";
        }
        info.put("instance_guid", instance_guid);
        JSONObject product_info = (JSONObject)product_instance.get((Object)"product_info");
        if (product_info == null) {
            return "JSON missing product_info";
        }
        JSONObject product_name = product_info == null ? null : (JSONObject)product_info.get((Object)"product_name");
        String productTitle = product_name == null ? null : (String)product_name.get((Object)"default_value");
        JSONObject description = product_info == null ? null : (JSONObject)product_info.get((Object)"description");
        String productDescription = description == null ? null : (String)description.get((Object)"default_value");
        JSONObject product_family = product_info == null ? null : (JSONObject)product_info.get((Object)"product_family");
        String productCode = product_family == null ? null : (String)product_family.get((Object)"code");
        JSONObject product_vendor = product_family == null ? null : (JSONObject)product_family.get((Object)"vendor");
        description = product_vendor == null ? null : (JSONObject)product_vendor.get((Object)"description");
        String vendorDescription = description == null ? null : (String)description.get((Object)"default_value");
        String string = vendorCode = product_vendor == null ? null : (String)product_vendor.get((Object)"code");
        if (productTitle == null || productDescription == null) {
            return "JSON missing product_name or description ";
        }
        if (productCode == null || vendorCode == null || vendorDescription == null) {
            return "JSON missing product code, vendor code or description";
        }
        info.put("product_name", productTitle);
        info.put("description", productDescription);
        info.put("product_description", productDescription);
        info.put("product_code", productCode);
        info.put("vendor_code", vendorCode);
        info.put("vendor_description", vendorDescription);
        o = tool_profile.get((Object)"base_url_choice");
        if (!(o instanceof JSONArray) || o == null) {
            return "JSON missing base_url_choices";
        }
        JSONArray base_url_choices = (JSONArray)o;
        String secure_base_url = null;
        String default_base_url = null;
        for (Object i : base_url_choices) {
            JSONObject url_choice = (JSONObject)i;
            secure_base_url = (String)url_choice.get((Object)"secure_base_url");
            default_base_url = (String)url_choice.get((Object)"default_base_url");
        }
        String launch_url = secure_base_url;
        if (launch_url == null) {
            launch_url = default_base_url;
        }
        if (launch_url == null) {
            return "Unable to determine launch URL";
        }
        o = (JSONArray)tool_profile.get((Object)"resource_handler");
        if (!(o instanceof JSONArray) || o == null) {
            return "JSON missing resource_handlers";
        }
        JSONArray resource_handlers = (JSONArray)o;
        for (Object i : resource_handlers) {
            String title;
            JSONObject resource_handler = (JSONObject)i;
            JSONObject resource_type_json = (JSONObject)resource_handler.get((Object)"resource_type");
            String resource_type_code = (String)resource_type_json.get((Object)"code");
            if (resource_type_code == null) {
                return "JSON missing resource_type code";
            }
            o = (JSONArray)resource_handler.get((Object)"message");
            if (!(o instanceof JSONArray) || o == null) {
                return "JSON missing resource_handler / message";
            }
            JSONArray messages = (JSONArray)o;
            JSONObject titleObject = (JSONObject)resource_handler.get((Object)"name");
            String string2 = title = titleObject == null ? null : (String)titleObject.get((Object)"default_value");
            if (title == null || titleObject == null) {
                return "JSON missing resource_handler / name / default_value";
            }
            JSONObject buttonObject = (JSONObject)resource_handler.get((Object)"short_name");
            String button = buttonObject == null ? null : (String)buttonObject.get((Object)"default_value");
            JSONObject descObject = (JSONObject)resource_handler.get((Object)"description");
            String resourceDescription = descObject == null ? null : (String)descObject.get((Object)"default_value");
            String path = null;
            JSONArray parameter = null;
            JSONArray enabled_capability = null;
            for (Object m : messages) {
                JSONObject message = (JSONObject)m;
                String message_type = (String)message.get((Object)"message_type");
                if (!"basic-lti-launch-request".equals(message_type)) continue;
                if (path != null) {
                    return "A resource_handler cannot have more than one basic-lti-launch-request message RT=" + resource_type_code;
                }
                path = (String)message.get((Object)"path");
                if (path == null) {
                    return "A basic-lti-launch-request message must have a path RT=" + resource_type_code;
                }
                o = (JSONArray)message.get((Object)"parameter");
                if (!(o instanceof JSONArray)) {
                    return "Must be an array: parameter RT=" + resource_type_code;
                }
                parameter = (JSONArray)o;
                o = (JSONArray)message.get((Object)"enabled_capability");
                if (!(o instanceof JSONArray)) {
                    return "Must be an array: enabled_capability RT=" + resource_type_code;
                }
                enabled_capability = (JSONArray)o;
            }
            if (path == null) continue;
            String thisLaunch = launch_url;
            if (!thisLaunch.endsWith("/") && !path.startsWith("/")) {
                thisLaunch = thisLaunch + "/";
            }
            thisLaunch = thisLaunch + path;
            try {
                URL url = new URL(thisLaunch);
            }
            catch (Exception e) {
                return "Bad launch URL=" + thisLaunch;
            }
            Properties theTool = new Properties();
            theTool.put("resource_type", resource_type_code);
            theTool.put("resource_type_code", resource_type_code);
            if (title == null) {
                title = productTitle;
            }
            if (title != null) {
                theTool.put("title", title);
            }
            if (button != null) {
                theTool.put("button", button);
            }
            if (resourceDescription == null) {
                resourceDescription = productDescription;
            }
            if (resourceDescription != null) {
                theTool.put("description", resourceDescription);
            }
            if (parameter != null) {
                theTool.put("parameter", parameter.toString());
            }
            if (enabled_capability != null) {
                theTool.put("enabled_capability", enabled_capability.toString());
            }
            theTool.put("launch", thisLaunch);
            theTools.add(theTool);
        }
        return null;
    }

    public static JSONObject parseSettings(String settings) {
        if (settings == null || settings.length() < 1) {
            settings = EMPTY_JSON_OBJECT;
        }
        return (JSONObject)JSONValue.parse((String)settings);
    }

    public static boolean mergeLTI1Custom(Properties custom, String customstr) {
        if (customstr == null || customstr.length() < 1) {
            return true;
        }
        String[] params = customstr.split("[\n;]");
        for (int i = 0; i < params.length; ++i) {
            String value;
            String key;
            int pos;
            String param = params[i];
            if (param == null || param.length() < 1 || (pos = param.indexOf("=")) < 1 || pos + 1 > param.length() || (key = LTI2Util.mapKeyName(param.substring(0, pos))) == null || custom.containsKey(key) || (value = param.substring(pos + 1)) == null || (value = value.trim()).length() < 1) continue;
            LTI2Util.setProperty(custom, key, value);
        }
        return true;
    }

    public static boolean mergeLTI2Custom(Properties custom, String customstr) {
        if (customstr == null || customstr.length() < 1) {
            return true;
        }
        JSONObject json = null;
        try {
            json = (JSONObject)JSONValue.parse((String)customstr.trim());
        }
        catch (Exception e) {
            M_log.warning("mergeLTI2Custom could not parse\n" + customstr);
            M_log.warning(e.getLocalizedMessage());
            return false;
        }
        if (json == null) {
            return false;
        }
        for (String key : json.keySet()) {
            Object value;
            if (custom.containsKey(key) || !((value = json.get((Object)key)) instanceof String)) continue;
            LTI2Util.setProperty(custom, key, (String)value);
        }
        return true;
    }

    public static boolean mergeLTI2Parameters(Properties custom, String customstr) {
        if (customstr == null || customstr.length() < 1) {
            return true;
        }
        JSONArray json = null;
        try {
            json = (JSONArray)JSONValue.parse((String)customstr.trim());
        }
        catch (Exception e) {
            M_log.warning("mergeLTI2Parameters could not parse\n" + customstr);
            M_log.warning(e.getLocalizedMessage());
            return false;
        }
        for (Object o : json) {
            JSONObject parameter = null;
            try {
                parameter = (JSONObject)o;
            }
            catch (Exception e) {
                M_log.warning("mergeLTI2Parameters did not find list of objects\n" + customstr);
                M_log.warning(e.getLocalizedMessage());
                return false;
            }
            String name = (String)parameter.get((Object)"name");
            if (name == null || custom.containsKey(name)) continue;
            String fixed = (String)parameter.get((Object)"fixed");
            String variable = (String)parameter.get((Object)"variable");
            if (variable != null) {
                LTI2Util.setProperty(custom, name, variable);
                continue;
            }
            if (fixed == null) continue;
            LTI2Util.setProperty(custom, name, fixed);
        }
        return true;
    }

    public static void substituteCustom(Properties custom, Properties lti2subst) {
        if (custom == null || lti2subst == null) {
            return;
        }
        Enumeration<?> e = custom.propertyNames();
        while (e.hasMoreElements()) {
            String newValue;
            String key = (String)e.nextElement();
            String value = custom.getProperty(key);
            if (value == null || value.length() < 1 || (newValue = lti2subst.getProperty(value)) == null || newValue.length() < 1) continue;
            LTI2Util.setProperty(custom, key, newValue);
        }
    }

    public static void addCustomToLaunch(Properties ltiProps, Properties custom) {
        Enumeration<?> e = custom.propertyNames();
        while (e.hasMoreElements()) {
            String keyStr = (String)e.nextElement();
            String value = custom.getProperty(keyStr);
            LTI2Util.setProperty(ltiProps, "custom_" + keyStr, value);
        }
    }

    public static void setProperty(Properties props, String key, String value) {
        BasicLTIUtil.setProperty(props, key, value);
    }

    public static String mapKeyName(String keyname) {
        return BasicLTIUtil.mapKeyName(keyname);
    }
}

